/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.util;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ChangeModuleID {
    private static final int COMPRESSION_FLAG = -1;
    private static final int COMPRESSION_MODE_GZIP = 1;

    private static MIBModule readModule(File f) throws IOException, ClassNotFoundException {
        FileInputStream file = new FileInputStream(f);
        ObjectInputStream input = new ObjectInputStream(file);
        int sz = input.readInt();
        MIBModule m = null;
        if (sz == -1) {
            GZIPInputStream zis = new GZIPInputStream(input);
            ObjectInputStream zois = new ObjectInputStream(zis);
            sz = zois.readInt();
            m = ChangeModuleID.readObjects(zois, sz);
        } else {
            m = ChangeModuleID.readObjects(input, sz);
        }
        try {
            input.close();
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return m;
    }

    private static MIBModule readObjects(ObjectInputStream input, int sz) throws ClassNotFoundException, IOException {
        MIBModule m = (MIBModule)input.readObject();
        m.reinit();
        for (int i = 0; i < sz - 1; ++i) {
            MIBObject obj = (MIBObject)input.readObject();
            m.add(obj);
        }
        return m;
    }

    protected static void saveModule(MIBModule m, File f, boolean useCompression) throws IOException {
        FileOutputStream file = new FileOutputStream(f);
        ObjectOutputStream output = new ObjectOutputStream(file);
        if (useCompression) {
            output.writeInt(-1);
            GZIPOutputStream zos = new GZIPOutputStream(output);
            ObjectOutputStream zoos = new ObjectOutputStream(zos);
            ChangeModuleID.writeObjects(m, zoos);
            zoos.flush();
            zoos.close();
        } else {
            ChangeModuleID.writeObjects(m, output);
        }
        output.flush();
        output.close();
    }

    private static void writeObjects(MIBModule m, ObjectOutputStream output) throws IOException {
        int size = m.size();
        if (m.objectsByName().get(m.getName()) == null) {
            ++size;
        }
        output.writeInt(size);
        output.writeObject(m);
        Enumeration<MIBObject> objects = m.objects();
        while (objects.hasMoreElements()) {
            MIBObject o = objects.nextElement();
            if (o instanceof MIBModule) continue;
            try {
                output.writeObject(o);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: ChangeModuleID [-i <ModuleDir>] [-n <Compiled-MIB-File> <New-Module-ID> [<New-MIB-File>]]");
        }
        if ("-i".equals(args[0])) {
            File[] files = new File(args[1]).listFiles();
            for (int i = 0; i < files.length; ++i) {
                try {
                    MIBModule m = ChangeModuleID.readModule(files[i]);
                    Integer newModuleID = new Integer(-m.getModuleID().intValue());
                    System.out.println("Converting " + m.getModuleName() + " from " + m.getModuleID() + " to " + newModuleID);
                    Iterator<MIBObject> it = m.objectsIterator();
                    while (it.hasNext()) {
                        MIBObject o = it.next();
                        o.setModuleID(newModuleID);
                        System.out.println(o.getName() + "=" + o.getOid() + "|" + o.getClass() + "#" + newModuleID);
                    }
                    m.setModuleID(newModuleID);
                    ChangeModuleID.saveModule(m, files[i], true);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            System.out.println("Converted " + files.length + " files.");
        } else if ("-n".equals(args[0])) {
            Integer newModuleID = new Integer(args[2]);
            try {
                MIBModule m = ChangeModuleID.readModule(new File(args[1]));
                Iterator<MIBObject> it = m.objectsIterator();
                while (it.hasNext()) {
                    MIBObject o = it.next();
                    o.setModuleID(newModuleID);
                }
                m.setModuleID(newModuleID);
                String newFile = args.length > 2 ? args[3] : args[1];
                ChangeModuleID.saveModule(m, new File(newFile), true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

