/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.pib;

import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.pib.IPibModule;
import com.agentpp.smi.IEnum;
import java.util.List;

public class PIBModule
extends MIBModule
implements IPibModule {
    public static final long serialVersionUID = 1000L;
    private List<MIBEnum> categories;

    public PIBModule(String newModuleName, Integer newModuleID) {
        super(newModuleName, newModuleID);
    }

    public PIBModule(PIBModule other) {
        super(other);
        this.categories = other.categories;
    }

    public void setCategories(List<MIBEnum> categories) {
        this.categories = categories;
    }

    @Override
    public MIBObject getClone() {
        return new PIBModule(this);
    }

    @Override
    public List<? extends IEnum> getCategories() {
        return this.categories;
    }

    @Override
    protected void toSMIDefinitionsBegin(int mode, StringBuffer buf) {
        if (mode != 8) {
            PIBModule.addKeyWord(mode, buf, " PIB-DEFINITIONS ::= BEGIN");
        } else {
            super.toSMIDefinitionsBegin(mode, buf);
        }
    }

    @Override
    protected String toPIB(int mode, int smiversion) {
        PIBModule c = (PIBModule)this.comparable(mode);
        if (mode != 8 && smiversion < 0 && this.categories != null) {
            StringBuffer buf = new StringBuffer();
            buf.append("\t");
            PIBModule.addKeyWord(mode, buf, "SUBJECT-CATEGORIES ");
            buf.append(" { ");
            if (this.categories != null && this.categories.size() > 1) {
                buf.append(lineSeparator);
                buf.append("\t\t\t");
            }
            MIBSyntax.toSMIEnums(mode, lineSeparator, buf, c == null || c.categories == null ? null : c.categories.iterator(), this.categories);
            if (this.categories != null && this.categories.size() > 1) {
                buf.append("\t}");
            } else {
                buf.append(" }");
            }
            buf.append(lineSeparator);
            return buf.toString();
        }
        return "";
    }
}

