/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.pib;

import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBObject;
import com.agentpp.pib.IPibIndexPart;
import java.util.Vector;

public class PIBIndexPart
extends MIBIndexPart
implements IPibIndexPart {
    public static final long serialVersionUID = 1000L;
    public static final int EXTENDS = 3;

    public PIBIndexPart() {
        this.setType(1);
    }

    public PIBIndexPart(int type) {
        this.setType(type);
    }

    public PIBIndexPart(int type, Vector<String> indexes) {
        super(type, indexes);
    }

    public PIBIndexPart(MIBIndexPart other) {
        this.setIndexPart(other.getIndexPart());
        this.implied = other.isImplied();
        this.type = other.getType();
    }

    @Override
    public boolean isExtends() {
        return this.getType() == 3;
    }

    public boolean isIndex() {
        return this.getType() == 1;
    }

    @Override
    public String toSMI(int mode, String lineSeparator) {
        StringBuffer buf = new StringBuffer();
        switch (this.getType()) {
            case 3: {
                MIBObject.addKeyWord(mode, buf, "EXTENDS ");
                break;
            }
            case 2: {
                MIBObject.addKeyWord(mode, buf, "AUGMENTS ");
                break;
            }
            default: {
                MIBObject.addKeyWord(mode, buf, "PIB-INDEX ");
            }
        }
        buf.append("{");
        buf.append(lineSeparator);
        Vector v = (Vector)this.indecies.clone();
        buf.append(MIBObject.formatObjectRefs(mode, "\t\t", v.iterator(), lineSeparator));
        buf.append(" }");
        buf.append(lineSeparator);
        return buf.toString();
    }
}

