/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.smi.ISyntax;
import com.agentpp.smi.ext.SMISyntax;
import com.agentpp.smi.ext.SMITextualConvention;
import com.agentpp.smiparser.SMI;
import java.io.Serializable;

public class MIBTextualConvention
extends MIBObject
implements Serializable,
SMITextualConvention {
    public static final long serialVersionUID = 1000L;
    protected MIBSyntax syntax = null;
    protected String displayHint = null;

    public MIBTextualConvention() {
    }

    public MIBTextualConvention(String name) {
        super(name);
    }

    public MIBTextualConvention(String name, Integer moduleID) {
        super(name, moduleID);
    }

    public MIBTextualConvention(MIBTextualConvention other) {
        super(other);
        this.syntax = new MIBSyntax(other.syntax);
        this.displayHint = other.displayHint;
    }

    @Override
    public MIBObject getClone() {
        return new MIBTextualConvention(this);
    }

    @Override
    public String getTypeString() {
        return SMI.ENTRY_TYPES[4];
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public void setSyntaxDef(SMISyntax syntax) {
        this.syntax = (MIBSyntax)syntax;
    }

    public void setSyntax(MIBSyntax syntax) {
        this.syntax = syntax;
    }

    public MIBSyntax getSyntax() {
        return this.syntax;
    }

    @Override
    public ISyntax getSyntaxDef() {
        return this.syntax;
    }

    @Override
    public void setDisplayHint(String hint) {
        this.displayHint = hint;
    }

    @Override
    public String getDisplayHint() {
        return this.displayHint;
    }

    @Override
    public boolean hasDisplayHint() {
        return this.displayHint != null && this.displayHint.length() > 0;
    }

    @Override
    public String toSMI(int mode, int smiversion, MIBRepository rep, String lineSeparator) {
        MIBTextualConvention c = (MIBTextualConvention)this.comparable(mode);
        StringBuffer buf = new StringBuffer();
        if (this.hasComment()) {
            MIBTextualConvention.addComment(mode, buf, this.asn1Comment, lineSeparator);
            buf.append(lineSeparator);
        }
        MIBTextualConvention.addObjectRef(null, mode, buf, this.name, c == null ? null : c.name);
        if (!this.hasStatus() || SMI.statusType(this.status) == 0) {
            buf.append(" ::= ");
            buf.append(this.syntax.toSMI(mode, rep, c == null ? null : c.syntax, lineSeparator));
        } else {
            buf.append(" ::= ");
            MIBTextualConvention.addKeyWord(mode, buf, "TEXTUAL-CONVENTION");
            buf.append(lineSeparator);
            if (this.hasDisplayHint()) {
                buf.append('\t');
                MIBTextualConvention.addKeyWord(mode, buf, "DISPLAY-HINT ");
                String cs = null;
                if (c != null) {
                    cs = c.hasDisplayHint() ? c.displayHint : "";
                }
                MIBTextualConvention.addString(mode, buf, this.displayHint, cs);
                buf.append(lineSeparator);
            }
            buf.append(this.getSMIDefBegin(mode, lineSeparator));
            buf.append('\t');
            MIBTextualConvention.addKeyWord(mode, buf, "SYNTAX ");
            buf.append(this.syntax.toSMI(mode, rep, c == null ? null : c.syntax, lineSeparator));
        }
        buf.append(lineSeparator);
        return buf.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MIBTextualConvention && super.equals(o)) {
            MIBTextualConvention other = (MIBTextualConvention)o;
            return MIBTextualConvention.saveCompare(this.syntax, other.syntax) && MIBTextualConvention.saveCompare(this.displayHint, other.displayHint);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void freeUserObjects() {
        super.freeUserObjects();
        if (this.syntax != null) {
            this.syntax.userObject = null;
        }
    }
}

