/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.smi.ext.SMIRevision;
import java.io.Serializable;

public class MIBRevision
implements Serializable,
SMIRevision {
    public static final long serialVersionUID = 1000L;
    protected String revision = null;
    protected String description = null;

    public MIBRevision() {
    }

    public MIBRevision(String r, String d) {
        this.revision = r;
        this.description = d;
    }

    @Override
    public String getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(String revision) {
        this.revision = revision;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String descr) {
        this.description = descr;
    }

    public String toSMI(int mode, MIBRevision c, String lineSeparator) {
        String d;
        StringBuffer buf = new StringBuffer("\t");
        MIBObject.addKeyWord(mode, buf, "REVISION ");
        MIBObject.addText(lineSeparator, mode, buf, this.revision, c == null ? null : c.revision);
        if ((mode & 0x20) > 0 && (d = MIBModule.getTimeFromUTC(MIBObject.getUnquotedString(this.revision))) != null) {
            buf.append("\t");
            MIBObject.addComment(mode, buf, "-- " + d, lineSeparator);
        }
        buf.append(lineSeparator);
        buf.append("\t");
        MIBObject.addKeyWord(mode, buf, "DESCRIPTION");
        buf.append(lineSeparator);
        MIBObject.addText(lineSeparator, mode, buf, MIBObject.formatLines("\t\t", this.description), c == null ? null : MIBObject.formatLines("\t\t", c.description));
        buf.append(lineSeparator);
        return buf.toString();
    }

    public String toString() {
        return this.revision;
    }

    public String toDetailedString() {
        return this.revision + "(" + this.description + ")";
    }

    public boolean equals(Object other) {
        if (other instanceof MIBRevision) {
            MIBRevision r = (MIBRevision)other;
            return r.revision.equals(this.revision);
        }
        return false;
    }
}

