/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.pib.PIBComplianceModule;
import com.agentpp.smi.IRequirementsSpec;
import com.agentpp.smi.ext.SMIComplianceStatement;
import com.agentpp.smi.ext.SMIRequirementsSpec;
import com.agentpp.smiparser.SMI;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class MIBCompliance
extends MIBObject
implements Serializable,
SMIComplianceStatement {
    public static final long serialVersionUID = 1000L;
    protected Vector modules = new Vector();

    public MIBCompliance() {
    }

    public MIBCompliance(ObjectID oid, String name, Integer moduleID) {
        super(oid, name, moduleID);
    }

    public MIBCompliance(MIBCompliance other) {
        super(other);
        for (Object module : other.modules) {
            this.modules.add(module instanceof PIBComplianceModule ? new PIBComplianceModule((PIBComplianceModule)module) : new MIBComplianceModule((MIBComplianceModule)module));
        }
    }

    @Override
    public MIBObject getClone() {
        return new MIBCompliance(this);
    }

    public void setModules(Vector newModules) {
        this.modules = newModules;
    }

    @Override
    public String getTypeString() {
        return SMI.ENTRY_TYPES[8];
    }

    @Override
    public int getType() {
        return 8;
    }

    public Vector getModules() {
        return this.modules;
    }

    @Override
    public final IRequirementsSpec[] getRequirements() {
        Object[] m = new MIBComplianceModule[this.modules.size()];
        this.modules.copyInto(m);
        return m;
    }

    @Override
    public final void setRequirements(SMIRequirementsSpec[] requirements) {
        this.modules = new Vector<SMIRequirementsSpec>(Arrays.asList(requirements));
    }

    @Override
    public String toSMI(int mode, int smiversion, MIBRepository rep, String lineSeparator) {
        MIBCompliance c = (MIBCompliance)this.comparable(mode);
        if (smiversion != 1) {
            StringBuffer buf = new StringBuffer(lineSeparator);
            MIBCompliance.addNavigationLinks(this, mode, buf, rep, lineSeparator);
            if (this.hasComment()) {
                MIBCompliance.addComment(mode, buf, this.asn1Comment, lineSeparator);
                buf.append(lineSeparator);
            }
            MIBCompliance.addObjectRef(null, mode, buf, this.name, c == null ? null : c.name);
            MIBCompliance.addKeyWord(mode, buf, " MODULE-COMPLIANCE");
            buf.append(lineSeparator);
            buf.append(this.getSMIDefBegin(mode, lineSeparator));
            Enumeration cen = null;
            if (c != null) {
                cen = c.modules.elements();
            }
            Enumeration en = this.modules.elements();
            while (en.hasMoreElements()) {
                Object compModule;
                MIBComplianceModule cs = null;
                if (cen != null) {
                    cs = cen.hasMoreElements() ? (MIBComplianceModule)cen.nextElement() : new MIBComplianceModule("");
                }
                if ((compModule = en.nextElement()) instanceof MIBComplianceModule) {
                    buf.append(((MIBComplianceModule)compModule).toSMI(mode, rep, cs, lineSeparator));
                    continue;
                }
                buf.append(compModule.toString());
            }
            buf.append(lineSeparator);
            buf.append(this.getSMIDefEnd(mode, rep, this.asn1CommentInline, lineSeparator));
            return buf.toString();
        }
        return "";
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MIBCompliance && super.equals(o)) {
            MIBCompliance other = (MIBCompliance)o;
            return MIBCompliance.saveCompare(this.modules, other.modules);
        }
        return false;
    }

    @Override
    public void freeUserObjects() {
        super.freeUserObjects();
        for (Object module : this.modules) {
            MIBComplianceModule cm = (MIBComplianceModule)module;
            cm.freeUserObjects();
        }
    }
}

