/*
 * Decompiled with CFR 0.152.
 */
package com.snmp4j.smi.util;

import com.snmp4j.smi.RepositoryDriver;
import com.snmp4j.smi.RepositoryIO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MemRepositoryDriver
implements RepositoryDriver {
    private final Map<String, byte[]> repository = new ConcurrentHashMap<String, byte[]>();

    @Override
    public void writeModule(final RepositoryIO event) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                MemRepositoryDriver.this.repository.put(event.getModuleName(), this.toByteArray());
            }
        };
        event.setOutputStream(byteArrayOutputStream);
    }

    @Override
    public void readModule(RepositoryIO event) {
        byte[] data = this.repository.get(event.getModuleName());
        if (data != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            event.setInputStream(inputStream);
        }
    }

    @Override
    public void deleteModule(RepositoryIO event) {
        this.repository.remove(event.getModuleName());
    }

    @Override
    public String[] listModuleNames() {
        return this.repository.keySet().toArray(new String[0]);
    }
}

