/*
 * Decompiled with CFR 0.152.
 */
package com.snmp4j.smi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class NamedInputStream {
    private final InputStream inputStream;
    private final String name;
    private ZipFormat zipFormat = ZipFormat.none;

    public NamedInputStream(File file) throws FileNotFoundException {
        this.inputStream = new FileInputStream(file);
        this.name = file.getPath();
    }

    public NamedInputStream(InputStream inputStream, String name) {
        this.inputStream = inputStream;
        this.name = name;
    }

    public NamedInputStream(InputStream inputStream, String name, ZipFormat zipFormat) {
        this(inputStream, name);
        this.zipFormat = zipFormat;
    }

    public synchronized InputStream getInputStream() {
        return this.inputStream;
    }

    public String getName() {
        return this.name;
    }

    public ZipFormat getZipFormat() {
        return this.zipFormat;
    }

    public String toString() {
        return "NamedInputStream{name='" + this.name + '\'' + ", zipFormat=" + (Object)((Object)this.zipFormat) + '}';
    }

    public static enum ZipFormat {
        none,
        ZIP;

    }
}

