/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.algorithms;

import com.objectspace.jgl.BidirectionalIterator;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.algorithms.Predicates;

public final class Heap {
    private Heap() {
    }

    public static void pushHeap(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2) {
        Heap.pushHeap(bidirectionalIterator, bidirectionalIterator2, new Predicates.HashComparator());
    }

    public static void pushHeap(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2, BinaryPredicate binaryPredicate) {
        if (!bidirectionalIterator.isCompatibleWith(bidirectionalIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        Heap.pushHeap(bidirectionalIterator, bidirectionalIterator.distance(bidirectionalIterator2) - 1, 0, bidirectionalIterator2.get(-1), binaryPredicate);
    }

    static void pushHeap(BidirectionalIterator bidirectionalIterator, int n, int n2, Object object, BinaryPredicate binaryPredicate) {
        int n3 = (n - 1) / 2;
        BidirectionalIterator bidirectionalIterator2 = (BidirectionalIterator)bidirectionalIterator.clone();
        while (n > n2 && binaryPredicate.execute(bidirectionalIterator2.get(n3), object)) {
            bidirectionalIterator2.put(n, bidirectionalIterator2.get(n3));
            n = n3;
            n3 = (n - 1) / 2;
        }
        bidirectionalIterator2.put(n, object);
    }

    public static void popHeap(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2) {
        Heap.popHeap(bidirectionalIterator, bidirectionalIterator2, new Predicates.HashComparator());
    }

    public static void popHeap(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2, BinaryPredicate binaryPredicate) {
        if (!bidirectionalIterator.isCompatibleWith(bidirectionalIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        Object object = bidirectionalIterator2.get(-1);
        bidirectionalIterator2.put(-1, bidirectionalIterator.get());
        Heap.adjustHeap(bidirectionalIterator, 0, bidirectionalIterator.distance(bidirectionalIterator2) - 1, object, binaryPredicate);
    }

    public static void makeHeap(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2) {
        Heap.makeHeap(bidirectionalIterator, bidirectionalIterator2, new Predicates.HashComparator());
    }

    public static void makeHeap(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2, BinaryPredicate binaryPredicate) {
        if (!bidirectionalIterator.isCompatibleWith(bidirectionalIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        int n = bidirectionalIterator.distance(bidirectionalIterator2);
        if (n < 2) {
            return;
        }
        int n2 = (n - 2) / 2;
        while (true) {
            Heap.adjustHeap(bidirectionalIterator, n2, n, bidirectionalIterator.get(n2), binaryPredicate);
            if (n2 == 0) {
                return;
            }
            --n2;
        }
    }

    public static void sortHeap(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2) {
        Heap.sortHeap(bidirectionalIterator, bidirectionalIterator2, new Predicates.HashComparator());
    }

    public static void sortHeap(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2, BinaryPredicate binaryPredicate) {
        if (!bidirectionalIterator.isCompatibleWith(bidirectionalIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        BidirectionalIterator bidirectionalIterator3 = (BidirectionalIterator)bidirectionalIterator2.clone();
        while (bidirectionalIterator.distance(bidirectionalIterator3) > 1) {
            Heap.popHeap(bidirectionalIterator, bidirectionalIterator3, binaryPredicate);
            bidirectionalIterator3.retreat();
        }
    }

    static void adjustHeap(BidirectionalIterator bidirectionalIterator, int n, int n2, Object object, BinaryPredicate binaryPredicate) {
        int n3 = n;
        int n4 = 2 * (n + 1);
        while (n4 < n2) {
            if (binaryPredicate.execute(bidirectionalIterator.get(n4), bidirectionalIterator.get(n4 - 1))) {
                --n4;
            }
            bidirectionalIterator.put(n, bidirectionalIterator.get(n4));
            n = n4;
            n4 = 2 * (n4 + 1);
        }
        if (n4 == n2) {
            bidirectionalIterator.put(n, bidirectionalIterator.get(n4 - 1));
            n = n4 - 1;
        }
        Heap.pushHeap(bidirectionalIterator, n, n3, object, binaryPredicate);
    }
}

