/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.LongBuffer;
import com.objectspace.jgl.adapters.LongIterator;
import java.util.Enumeration;

public class LongArray
extends ArrayAdapter {
    long[] array;
    static final long serialVersionUID = -8770508407315531857L;

    public LongArray() {
        this(new long[0]);
    }

    public LongArray(LongArray longArray) {
        this(longArray.array);
    }

    public LongArray(LongBuffer longBuffer) {
        this(longBuffer.get());
    }

    public LongArray(long[] lArray) {
        this.array = lArray;
    }

    public synchronized Object clone() {
        return new LongArray(this);
    }

    public synchronized String toString() {
        return Algorithms.Printing.toString(this, "long[]");
    }

    public boolean equals(Object object) {
        return object instanceof LongArray && this.equals((LongArray)object) || object instanceof LongBuffer && this.equals((LongBuffer)object);
    }

    public boolean equals(LongArray longArray) {
        return this.equals(longArray.array);
    }

    public boolean equals(LongBuffer longBuffer) {
        return this.equals(longBuffer.storage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean equals(long[] lArray) {
        long[] lArray2 = lArray;
        synchronized (lArray2) {
            if (this.array.length != lArray.length) {
                return false;
            }
            int n = 0;
            while (n < lArray.length) {
                if (this.array[n] != lArray[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }

    public long[] get() {
        return this.array;
    }

    public int size() {
        return this.array.length;
    }

    public int maxSize() {
        return this.array.length;
    }

    public Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public synchronized LongIterator begin() {
        return new LongIterator(this, 0);
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized LongIterator end() {
        return new LongIterator(this, this.array.length);
    }

    public Object at(int n) {
        return new Long(this.longAt(n));
    }

    public synchronized long longAt(int n) {
        return this.array[n];
    }

    public void put(int n, Object object) {
        this.put(n, ((Number)object).longValue());
    }

    public synchronized void put(int n, long l) {
        this.array[n] = l;
    }
}

