/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.snmpvalue;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.snmpvalue.ValueConverter;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;

public class IndexConverter {
    public static Variable getIndexVariable(IndexStruct index, ObjectID indexValue) {
        try {
            switch (index.baseType) {
                case 1: {
                    if (index.impliedLength || index.minLength == index.maxLength) {
                        return new OctetString(indexValue.asByteArray());
                    }
                    ObjectID suffix = indexValue.getSuffix(indexValue.size() - 1);
                    return new OctetString(suffix.asByteArray());
                }
                case 0: {
                    return new Integer32((int)indexValue.getLastSubID() & 0xFFFFFFFF);
                }
                case 9: {
                    return new TimeTicks(indexValue.getLastSubID());
                }
                case 5: {
                    return new IpAddress(indexValue.toString());
                }
                case 12: {
                    String id = indexValue.toString();
                    return new IpAddress(id.substring(id.indexOf(".") + 1));
                }
            }
            if (index.impliedLength || index.minLength == index.maxLength) {
                return new OID(indexValue.toString());
            }
            return new OID(indexValue.getSuffix(indexValue.size() - 1).toString());
        }
        catch (Exception e) {
            return new OID(indexValue.toString());
        }
    }

    public static Variable[] getIndexVariables(IndexStruct[] indexes, ObjectID[] indexValues) {
        int sz = Math.min(indexes.length, indexValues.length);
        Variable[] o = new Variable[sz];
        for (int i = 0; i < sz; ++i) {
            o[i] = IndexConverter.getIndexVariable(indexes[i], indexValues[i]);
        }
        return o;
    }

    public static String getIndexString(ValueConverter converter, IndexStruct index, ObjectID indexValue) {
        return IndexConverter.getIndexString(converter, index, indexValue, false, null, null, null, null, null);
    }

    public static String getIndexString(ValueConverter converter, IndexStruct index, Variable indexVariable, boolean withStringDelimiter, String fixedLengthQuote, String variableLengthQuote, String fixedLengthQuoteEscape, String variableLengthQuoteEscape, StringFormat nonPrintableAsHex) {
        Object o = converter.toNative(indexVariable, true);
        if (o == null) {
            return "?";
        }
        String s = o.toString();
        if (withStringDelimiter && (s.indexOf(46) >= 0 || index.baseType == 1 || index.baseType == 3 || converter.getEffectiveSyntax().hasEnums() || converter.displayHint != null)) {
            if (index.impliedLength || index.minLength == index.maxLength) {
                return fixedLengthQuote + IndexConverter.formatAndEscapeString(s, nonPrintableAsHex, fixedLengthQuote, fixedLengthQuoteEscape) + fixedLengthQuote;
            }
            return variableLengthQuote + IndexConverter.formatAndEscapeString(s, nonPrintableAsHex, variableLengthQuote, variableLengthQuoteEscape) + variableLengthQuote;
        }
        return s;
    }

    public static String getIndexString(ValueConverter converter, IndexStruct index, ObjectID indexValue, boolean withStringDelimiter, String fixedLengthQuote, String variableLengthQuote, String fixedLengthQuoteEscape, String variableLengthQuoteEscape, StringFormat nonPrintableAsHex) {
        return IndexConverter.getIndexString(converter, index, IndexConverter.getIndexVariable(index, indexValue), withStringDelimiter, fixedLengthQuote, variableLengthQuote, fixedLengthQuoteEscape, variableLengthQuoteEscape, nonPrintableAsHex);
    }

    private static String formatAndEscapeString(String s, StringFormat format, String escape, String escaped) {
        if (format != null && !IndexConverter.isPrintable(s)) {
            return format.getFormatIdentifier() + new OctetString(s).toString(format.getDelimiter(), format.getRadix());
        }
        return s.replaceAll(Pattern.quote(escape), Matcher.quoteReplacement(escaped));
    }

    public static boolean isPrintable(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isISOControl(c) && (c & 0xFF) < 128 || Character.isWhitespace(c) && ((c & 0xFF) < 28 || (c & 0xFF) > 31)) continue;
            return false;
        }
        return true;
    }

    public static String getIndexString(ValueConverter[] converter, IndexStruct[] indexes, ObjectID[] indexValues) {
        return IndexConverter.getIndexString(converter, indexes, indexValues, false, null, null, null, null, null);
    }

    public static String getIndexString(ValueConverter[] converter, IndexStruct[] indexes, ObjectID[] indexValues, boolean withStringDelimiter, String fixedLengthQuote, String variableLengthQuote, String fixedLengthQuoteEscape, String variableLengthQuoteEscape, StringFormat nonPrintableStringFormat) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < indexes.length && i < indexValues.length && i < converter.length; ++i) {
            buf.append(IndexConverter.getIndexString(converter[i], indexes[i], indexValues[i], withStringDelimiter, fixedLengthQuote, variableLengthQuote, fixedLengthQuoteEscape, variableLengthQuoteEscape, nonPrintableStringFormat));
            if (i + 1 >= indexes.length || i + 1 >= indexValues.length || i + 1 >= converter.length) continue;
            buf.append(".");
        }
        return buf.toString();
    }

    public static String getIndexString(ValueConverter[] converter, IndexStruct[] indexes, Variable[] indexVariables, boolean withStringDelimiter, String fixedLengthQuote, String variableLengthQuote, String fixedLengthQuoteEscape, String variableLengthQuoteEscape, StringFormat nonPrintableStringFormat) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < indexes.length && i < indexVariables.length && i < converter.length; ++i) {
            buf.append(IndexConverter.getIndexString(converter[i], indexes[i], indexVariables[i], withStringDelimiter, fixedLengthQuote, variableLengthQuote, fixedLengthQuoteEscape, variableLengthQuoteEscape, nonPrintableStringFormat));
            if (i + 1 >= indexes.length || i + 1 >= indexVariables.length || i + 1 >= converter.length) continue;
            buf.append(".");
        }
        return buf.toString();
    }

    public static ValueConverter[] getIndexValueConverter(MIBRepository rep, MIBObjectType table) {
        if (!table.isTable()) {
            return null;
        }
        Vector<? extends MIBObjectType> v = rep.getColumnarObjectsOfTable(table, true, false);
        ValueConverter[] vc = new ValueConverter[v.size()];
        for (int i = 0; i < vc.length; ++i) {
            MIBObjectType ot = (MIBObjectType)v.get(i);
            MIBTextualConvention tc = rep.getEffectiveSyntax(ot.getSyntax());
            vc[i] = new ValueConverter(ot, tc.getSyntax(), tc.getDisplayHint());
        }
        return vc;
    }

    public static String getIndexValueString(MIBRepository rep, MIBObjectType table, Variable[] indexVariables, boolean withStringDelimiter, String fixedLengthQuote, String variableLengthQuote, String fixedLengthQuoteEscape, String variableLengthQuoteEscape, StringFormat nonPrintableStringFormat) {
        ValueConverter[] vcs = IndexConverter.getIndexValueConverter(rep, table);
        IndexStruct[] ind = table.getIndexPart().getIndexStruct(rep);
        return IndexConverter.getIndexString(vcs, ind, indexVariables, withStringDelimiter, fixedLengthQuote, variableLengthQuote, fixedLengthQuoteEscape, variableLengthQuoteEscape, nonPrintableStringFormat);
    }

    public static enum StringFormat {
        hex(':', 16, "#x"),
        decimal('.', 10, "#d"),
        octal(':', 8, "#o"),
        binary(':', 2, "#b");

        private char delimiter;
        private int radix;
        private String formatIdentifier;

        private StringFormat(char separator, int radix, String formatIdentifier) {
            this.delimiter = separator;
            this.radix = radix;
            this.formatIdentifier = formatIdentifier;
        }

        public int getRadix() {
            return this.radix;
        }

        public char getDelimiter() {
            return this.delimiter;
        }

        public String getFormatIdentifier() {
            return this.formatIdentifier;
        }

        public static StringFormat getFormat(int radix) {
            for (StringFormat f : StringFormat.values()) {
                if (f.getRadix() != radix) continue;
                return f;
            }
            return null;
        }

        public static StringFormat getFormat(String id) {
            for (StringFormat f : StringFormat.values()) {
                if (!f.getFormatIdentifier().equals(id)) continue;
                return f;
            }
            return null;
        }
    }
}

