/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.smiparser.FileError;
import com.agentpp.smiparser.Token;

public class TokenMgrError
extends Error
implements FileError {
    private static final long serialVersionUID = 1L;
    static final int LEXICAL_ERROR = 0;
    static final int STATIC_LEXER_ERROR = 1;
    static final int INVALID_LEXICAL_STATE = 2;
    static final int LOOP_DETECTED = 3;
    int errorCode;
    public int errorLine = 0;
    public int errorColumn = 0;
    public int errorPos = 0;
    public String found = "";
    public String expected = "";
    public String tokenImage = "";

    protected static final String addEscapes(String str) {
        StringBuffer retval = new StringBuffer();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }

    protected static String LexicalError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar) {
        return "Lexical error at line " + errorLine + ", column " + errorColumn + ".  Encountered: " + (EOFSeen ? "<EOF> " : "\"" + TokenMgrError.addEscapes(String.valueOf(curChar)) + "\"" + " (" + curChar + "), ") + "after : \"" + TokenMgrError.addEscapes(errorAfter) + "\"";
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    @Override
    public String getFound() {
        return this.found;
    }

    @Override
    public String getFoundTokenImage() {
        return this.tokenImage;
    }

    @Override
    public int getLine() {
        return this.errorLine;
    }

    @Override
    public int getLastEndPosition() {
        return this.errorPos;
    }

    @Override
    public int getEndPosition() {
        return this.errorPos;
    }

    @Override
    public int getColumn() {
        return this.errorColumn;
    }

    @Override
    public String[] getExpected() {
        String[] e = new String[]{this.expected};
        return e;
    }

    @Override
    public String[] getExpectedImages() {
        return new String[0];
    }

    @Override
    public String[] getLastExpectedImages() {
        return this.getExpectedImages();
    }

    @Override
    public Token getToken() {
        return null;
    }

    @Override
    public int getErrorType() {
        return 50;
    }

    @Override
    public void freeUnusedTokens() {
    }

    @Override
    public int getEndLine() {
        return this.getLine();
    }

    @Override
    public int getEndColumn() {
        return this.getColumn();
    }

    public TokenMgrError() {
    }

    public TokenMgrError(String message, int reason) {
        super(message);
        this.errorCode = reason;
    }

    public TokenMgrError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar, int reason, int pos) {
        this(TokenMgrError.LexicalError(EOFSeen, lexState, errorLine, errorColumn, errorAfter, curChar), reason);
        this.errorCode = lexState;
        this.errorLine = errorLine;
        this.errorColumn = errorColumn;
        this.errorPos = pos;
        this.found = errorAfter;
    }
}

