/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.ObjectID;
import com.agentpp.smiparser.SMIObjectEntry;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.smiparser.SimpleNode;
import com.agentpp.smiparser.StringToken;
import java.util.ArrayList;

public class SMIObjectIdentifier
extends SimpleNode {
    private StringToken name;
    private StringToken[] tokenOid;
    private String[] oid;
    public static final int ID = -17;

    public SMIObjectIdentifier() {
        super(-17);
        this.name = new StringToken("", null);
    }

    public SMIObjectIdentifier(StringToken name) {
        super(-17);
        this.name = name;
        this.oid = null;
    }

    public long size() {
        return this.jjtGetNumChildren();
    }

    public final String[] getOid(SMIRepository smiRep) {
        if (this.oid == null) {
            this.oid = SMIObjectIdentifier.buildOid(this.createOid(smiRep));
            return this.oid;
        }
        return this.oid;
    }

    public String getName() {
        return this.name.string;
    }

    public static final ObjectID buildObjectID(StringToken[] tokenOid) {
        StringBuffer buf = new StringBuffer(128);
        for (int j = 0; j < tokenOid.length; ++j) {
            if (j > 0) {
                buf.append('.');
            }
            buf.append(tokenOid[j].string);
        }
        return new ObjectID(buf.toString());
    }

    public final ObjectID buildObjectID() {
        return SMIObjectIdentifier.buildObjectID(this.tokenOid);
    }

    public static String[] buildOid(StringToken[] oid) {
        String[] o = new String[oid.length];
        for (int j = 0; j < o.length; ++j) {
            o[j] = oid[j].string;
        }
        return o;
    }

    public StringToken[] createOid(SMIRepository smiRep) {
        boolean resolved = true;
        int sz = this.jjtGetNumChildren();
        ArrayList<StringToken> v = new ArrayList<StringToken>();
        for (int i = 0; i < sz; ++i) {
            SMIObjectEntry entry = (SMIObjectEntry)this.jjtGetChild(i);
            String subid = entry.getSubID();
            String subName = entry.getName();
            if (subid == null) {
                ObjectID foid = smiRep.getObjectID(subName);
                if (foid != null) {
                    v = new ArrayList();
                    String[] subids = SMIObjectIdentifier.fromString(foid.toString());
                    for (int k = 0; k < subids.length; ++k) {
                        v.add(new StringToken(subids[k], null));
                    }
                    continue;
                }
                resolved = false;
                v.add(new StringToken(subName, entry.getNameToken()));
                continue;
            }
            v.add(new StringToken(subid, null));
        }
        this.tokenOid = v.toArray(new StringToken[v.size()]);
        this.oid = SMIObjectIdentifier.buildOid(this.tokenOid);
        if (!"".equals(this.name)) {
            if (resolved) {
                try {
                    smiRep.addKnownObject(new MIBObject(this.buildObjectID(), this.name.string));
                }
                catch (SMIParseException i) {
                    // empty catch block
                }
                smiRep.checkUnresolved(this.name, this.tokenOid);
            } else {
                smiRep.addUnresolvedName(this.tokenOid, this.name);
                StringToken[] tempOid = this.tokenOid;
                this.tokenOid = null;
                this.oid = null;
                return tempOid;
            }
        }
        return this.tokenOid;
    }

    public StringToken getFirstUnresolvedSubId(SMIRepository smiRep) {
        if (this.oid != null) {
            return null;
        }
        StringToken[] tempOid = this.createOid(smiRep);
        for (int i = 0; i < tempOid.length; ++i) {
            for (int j = 0; j < tempOid[i].string.length(); ++j) {
                if (Character.isDigit(tempOid[i].string.charAt(j))) continue;
                return tempOid[i];
            }
        }
        return null;
    }

    public static String toString(String[] array) {
        return ObjectID.fromArray(array);
    }

    public static String toSMI(String[] array) {
        return ObjectID.fromArrayToSMI(array);
    }

    public static String[] fromString(String s) {
        return ObjectID.toArray(s);
    }

    @Override
    public String toString() {
        return ObjectID.fromArray(this.oid);
    }
}

