/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBCondGroup;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBException;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBRevision;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.pib.PIBIndexPart;
import com.agentpp.smi.IEnum;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.Node;
import com.agentpp.smiparser.SMI;
import com.agentpp.smiparser.SMIAgentCapabilities;
import com.agentpp.smiparser.SMICompliance;
import com.agentpp.smiparser.SMIDefaultValue;
import com.agentpp.smiparser.SMIDescription;
import com.agentpp.smiparser.SMIEnum;
import com.agentpp.smiparser.SMIFile;
import com.agentpp.smiparser.SMIIndex;
import com.agentpp.smiparser.SMIMib;
import com.agentpp.smiparser.SMIModule;
import com.agentpp.smiparser.SMINotifyType;
import com.agentpp.smiparser.SMIObject;
import com.agentpp.smiparser.SMIObjectType;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParseExceptionHandler;
import com.agentpp.smiparser.SMIParser;
import com.agentpp.smiparser.SMIParserVisitor;
import com.agentpp.smiparser.SMIRange;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.smiparser.SMIRevision;
import com.agentpp.smiparser.SMISeqEntries;
import com.agentpp.smiparser.SMISyntax;
import com.agentpp.smiparser.SMITextualConvention;
import com.agentpp.smiparser.SemanticError;
import com.agentpp.smiparser.SimpleNode;
import com.agentpp.smiparser.StringToken;
import com.agentpp.smiparser.Token;
import com.agentpp.smiparser.pib.PIBIndex;
import com.agentpp.smiparser.pib.PIBMib;
import com.agentpp.smiparser.pib.PIBModule;
import com.agentpp.smiparser.pib.PIBObjectType;
import com.objectspace.jgl.Pair;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;

public class SMI2Java
implements SMIParserVisitor,
SMIParseExceptionHandler {
    public static final String PIB_TAG_REFERENCE_ID = "TagReferenceId";
    public static final String PIB_REFERENCE_ID = "ReferenceId";
    public static final String PIB_TAG_ID = "TagId";
    protected MIBRepository rep = null;
    protected SMIRepository smiRep;
    protected MIBModule currentModule = null;
    protected boolean currentModuleImportListFound = false;
    protected ModuleInfo currentModuleInfo = null;
    protected MIBObject currentObject = null;
    protected MIBObjectType currentObjectType = null;
    protected MIBSyntax currentSyntax = null;
    protected Map tableEntryToObject = null;
    protected Map nameToSyntax = null;
    protected Map nameSequences;
    protected Map<String, StringToken> objectLists;
    protected Map<String, com.agentpp.mib.pib.PIBObjectType> pibInstanceIds;
    protected Vector groups = null;
    protected int options = 4;
    protected int currentSMIVersion = 1;
    protected String currentFile = "";
    protected int moduleCount = 0;
    protected int maxErrors = 0;
    protected List errors = new LinkedList();
    protected ArrayList failedImports = new ArrayList();
    protected boolean storeFileName = Boolean.getBoolean("com.agentpp.smi.storeMIBFileName");
    protected static final Object[][] IMPORT_MAPPINGS = new Object[][]{{new Integer(12), SMI.SMI_SYNTAX[12]}};

    public SMI2Java(SMIRepository smiRep, int options) {
        this.smiRep = smiRep;
        this.options = options;
        this.rep = new MIBRepository();
        this.tableEntryToObject = new HashMap(150);
        this.nameToSyntax = new HashMap(150);
        this.nameSequences = new HashMap(50);
        this.objectLists = new HashMap<String, StringToken>(20);
        this.pibInstanceIds = new HashMap<String, com.agentpp.mib.pib.PIBObjectType>(10);
        this.groups = new Vector(10, 10);
    }

    public MIBObject getCurrentObject() {
        return this.currentObject;
    }

    public void setParseContext(MIBModule module, Set excludedObjectNames) {
        MIBObject o;
        Iterator<Serializable> it = module.objectsIterator();
        while (it.hasNext()) {
            o = it.next();
            if (excludedObjectNames.contains(o.getName())) continue;
            this.smiRep.scope.addObject(o.getClone());
            try {
                this.smiRep.scope.addKnownObject(o);
            }
            catch (SMIParseException sMIParseException) {
                // empty catch block
            }
            if (o instanceof MIBObjectType) {
                MIBSyntax syn;
                MIBObjectType ot = (MIBObjectType)o;
                if (ot.isTable()) {
                    Vector<StringToken> seq = new Vector<StringToken>();
                    for (String n : ot.getTableEntriesVector()) {
                        seq.add(new StringToken(n, null));
                    }
                    this.nameSequences.put(ot.getTableEntriesVector(), seq);
                }
                if ((syn = ot.getSyntax()) == null || !Character.isUpperCase(syn.getSyntax().charAt(0)) || syn.getType() != 3) continue;
                this.tableEntryToObject.put(syn.getSyntax(), ot);
                continue;
            }
            if (o instanceof MIBGroup) {
                this.groups.add(o);
                continue;
            }
            if (o instanceof MIBCompliance) {
                Vector modules = ((MIBCompliance)o).getModules();
                if (modules == null) continue;
                for (Object mo : modules) {
                    MIBComplianceModule mcm;
                    String moduleName;
                    if (!(mo instanceof MIBComplianceModule) || (moduleName = (mcm = (MIBComplianceModule)mo).getModuleName()) == null || moduleName.trim().length() <= 0 || this.smiRep.isModuleAlreadyImported(moduleName)) continue;
                    this.smiRep.importModule(moduleName, this.rep, true);
                }
                continue;
            }
            if (!(o instanceof MIBAgentCaps)) continue;
            for (MIBSupportedModule sm : ((MIBAgentCaps)o).getModules()) {
                if (this.smiRep.isModuleAlreadyImported(sm.getSupports())) continue;
                this.smiRep.importModule(sm.getSupports(), this.rep, true);
            }
        }
        for (MIBImport imp : module.getImportsVector()) {
            if (!this.smiRep.isModuleAlreadyImported(imp.getSource())) {
                this.smiRep.importModule(imp.getSource(), this.rep, false);
            }
            String[] is = imp.getImports();
            for (int i = 0; i < is.length; ++i) {
                MIBObject o2;
                if (SMI.isKeyWord(is[i]) || (o2 = this.smiRep.scope.rep.getObject(imp.getSource(), is[i])) == null) continue;
                try {
                    this.smiRep.addKnownObject(o2);
                    continue;
                }
                catch (SMIParseException ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.currentModule = (MIBModule)module.getClone();
        this.currentModuleInfo = new ModuleInfo(module.getModuleName(), module.getImportSources());
        it = module.objectsIterator();
        while (it.hasNext()) {
            o = (MIBObject)it.next();
            if (excludedObjectNames.contains(o.getName())) continue;
            this.rep.addObject(o.getClone());
        }
    }

    public final MIBRepository getRepository() {
        return this.rep;
    }

    protected final int getTokenSUPPORTS() {
        return 97;
    }

    protected final int getTokenDEFVAL() {
        return 55;
    }

    protected final int getTokenSYNTAX() {
        return 63;
    }

    protected final int getTokenWRITESYNTAX() {
        return 89;
    }

    protected void checkRestrictedSyntax(Token t, String oname, MIBSyntax syntax, int syntaxTokenType) throws SMIParseException {
        if (!syntax.isRestrictiveSyntax(this.smiRep.scope.rep)) {
            this.throwLocalizedError(t, new Vector<String>(Arrays.asList(oname)), 4000, syntaxTokenType, 1);
        }
    }

    protected void checkDisplayHint(MIBTextualConvention tc) throws SMIParseException {
        if (tc != null && tc.hasDisplayHint()) {
            MIBSyntax syntax = tc.getSyntax();
            if (syntax == null) {
                return;
            }
            if (syntax.hasEnums() || SMI.SMI_SYNTAX[2].equals(syntax.getSyntax()) || SMI.SMI_SYNTAX[12].equals(syntax.getSyntax()) || SMI.SMI_SYNTAX[3].equals(syntax.getSyntax()) || SMI.SMI_SYNTAX[5].equals(syntax.getSyntax()) || SMI.SMI_SYNTAX[6].equals(syntax.getSyntax()) || SMI.SMI_SYNTAX[9].equals(syntax.getSyntax())) {
                this.throwLocalizedError(tc, new Vector<String>(Arrays.asList(tc.getName())), 4100, 80, 1);
            } else if (Pattern.matches(SMIParser.DISPLAYHINT_FORMATS[1], tc.getDisplayHint())) {
                if (SMI.SMI_SYNTAX[1].equals(syntax.getSyntax())) {
                    this.throwLocalizedError(tc, new Vector<String>(Arrays.asList(tc.getName(), tc.getDisplayHint())), 4101, 80, 1);
                }
            } else if (!SMI.SMI_SYNTAX[1].equals(syntax.getSyntax())) {
                this.throwLocalizedError(tc, new Vector<String>(Arrays.asList(tc.getName(), tc.getDisplayHint())), 4101, 80, 1);
            }
        }
    }

    protected void checkSyntax(StringToken oname, StringToken syntax) throws SMIParseException {
        if (syntax == null) {
            return;
        }
        StringToken s = (StringToken)this.nameToSyntax.get(oname);
        if (s != null && !syntax.equals(s) && (this.options & 2) == 0) {
            MIBObject o = this.rep.getObject(oname.string);
            if (o != null && o.userObject instanceof Token) {
                Token t = (Token)o.userObject;
                SemanticError err = new SemanticError(1200, t.beginLine, t.beginColumn, t.endPos, t, t.image, oname.string, new String[0]);
                this.error(new SMIParseException(err, 1200));
            } else {
                this.throwLocalizedError(oname.token, 1200);
            }
        }
        this.nameToSyntax.put(oname, syntax);
    }

    protected ModuleInfo readModule(SMIMib current) throws SMIParseException {
        this.currentSMIVersion = current.version;
        ImportModuleListener l = this.smiRep.getModuleImporter();
        Integer moduleID = l.createModuleID(current.getName());
        if (moduleID == null) {
            moduleID = new Integer(this.moduleCount);
        }
        this.currentModule = current instanceof PIBMib ? new com.agentpp.mib.pib.PIBModule(current.getName(), moduleID) : new MIBModule(current.getName(), moduleID);
        this.currentObject = null;
        this.currentModule.setLastChange(new Date(System.currentTimeMillis()));
        if (this.storeFileName) {
            try {
                this.currentModule.setFileName(new File(this.currentFile).getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.currentModule.setName(current.getName());
        if (current.getToken() != null) {
            this.currentModule.setStartPosition(current.getToken().endPos - current.getToken().image.length());
        }
        this.currentModule.setOid(new ObjectID());
        this.currentModule.setSMIVersion(this.currentSMIVersion);
        this.currentModule.setCopyrightComment(current.asn1Comment);
        this.currentModule.setCopyrightCommentEnd(current.asn1EndComment);
        this.rep.addObject(this.currentModule);
        for (MIBImport mibImport : current.getImports()) {
            this.readImports(mibImport);
        }
        return new ModuleInfo(this.currentModule.getModuleName(), current.getImportSources().toArray(new String[0]));
    }

    protected void readModuleIdentity(SMIModule o) throws SMIParseException {
        this.currentSMIVersion = 2;
        this.currentModule.setRevisionsVector(null);
        this.currentModule.setOrganization(o.getOrganization());
        this.currentModule.setContactInfo(o.getContactInfo());
        this.currentModule.setLastUpdated(o.getLastUpdated());
        this.currentModule.setSMIVersion(2);
        this.currentModule.setReleased(1);
        this.currentObject = this.currentModule;
    }

    protected void readPibModuleIdentity(PIBModule o) throws SMIParseException {
        this.currentSMIVersion = -1;
        if (this.currentModule instanceof com.agentpp.mib.pib.PIBModule) {
            ((com.agentpp.mib.pib.PIBModule)this.currentModule).setCategories(o.getCategories());
        }
        this.currentModule.setRevisionsVector(null);
        this.currentModule.setOrganization(o.getOrganization());
        this.currentModule.setContactInfo(o.getContactInfo());
        this.currentModule.setLastUpdated(o.getLastUpdated());
        this.currentModule.setSMIVersion(-1);
        this.currentModule.setReleased(1);
        this.currentObject = this.currentModule;
    }

    protected void readObject(SMIObject currentSMIObject) throws SMIParseException {
        StringToken unresolved;
        ObjectID oid = new ObjectID(currentSMIObject.getPrintableOid(this.smiRep));
        if (!oid.isValid() && (unresolved = currentSMIObject.getFirstUnresolvedSubId(this.smiRep)) != null && unresolved.string.length() > 0) {
            if (Character.isUpperCase(unresolved.string.charAt(0))) {
                String uname;
                String moduleName = oid.getSubID(0);
                if ((oid = this.smiRep.getObjectID(moduleName, uname = oid.getSubID(1))) == null) {
                    if (unresolved.token != null) {
                        this.throwLocalizedError(unresolved.token, 1502);
                    } else if (currentSMIObject.getToken() != null) {
                        Token t = currentSMIObject.getToken();
                        this.error(new SMIParseException(new SemanticError(1502, t.beginLine, t.beginColumn, t.endPos, t, unresolved.string, t.image, new String[0]), 1502));
                    } else {
                        this.error(new SMIParseException(unresolved.string, 1502));
                    }
                }
            } else if (unresolved.token != null) {
                this.throwLocalizedError(unresolved.token, 1502);
            } else if (currentSMIObject.getToken() != null) {
                Token t = currentSMIObject.getToken();
                this.error(new SMIParseException(new SemanticError(1502, t.beginLine, t.beginColumn, t.endPos, t, unresolved.string, t.image, new String[0]), 1502));
            } else {
                this.error(new SMIParseException(unresolved.string, 1502));
            }
        }
        if (currentSMIObject.getType() != 4 && !oid.isValid()) {
            this.currentObject = null;
            return;
        }
        switch (currentSMIObject.getType()) {
            case 1: {
                this.currentObject = this.currentModule instanceof com.agentpp.mib.pib.PIBModule ? new com.agentpp.mib.pib.PIBObjectType(new ObjectID(currentSMIObject.getPrintableOid(this.smiRep)), currentSMIObject.getName(), this.currentModule.getModuleID()) : new MIBObjectType(new ObjectID(currentSMIObject.getPrintableOid(this.smiRep)), currentSMIObject.getName(), this.currentModule.getModuleID());
                this.currentObject.setStatus(currentSMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
                break;
            }
            case 2: 
            case 3: {
                this.currentObject = new MIBNotifyType(new ObjectID(currentSMIObject.getPrintableOid(this.smiRep)), currentSMIObject.getName(), this.currentModule.getModuleID(), currentSMIObject.getType());
                this.currentObject.setStatus(currentSMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
                break;
            }
            case 4: {
                this.currentObject = new MIBTextualConvention(currentSMIObject.getName(), this.currentModule.getModuleID());
                this.currentObject.setStatus(currentSMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
                break;
            }
            case 5: {
                this.rep.renameObject(this.currentModule, new ObjectID(currentSMIObject.getPrintableOid(this.smiRep)), currentSMIObject.getName());
                this.currentModule.setStatus(currentSMIObject.getStatus());
                this.currentModule.setComment(currentSMIObject.asn1Comment);
                this.currentModule.setInlineComment(currentSMIObject.inlineAsn1Comment);
                break;
            }
            case 6: 
            case 7: {
                this.currentObject = new MIBGroup(new ObjectID(currentSMIObject.getPrintableOid(this.smiRep)), currentSMIObject.getName(), this.currentModule.getModuleID(), currentSMIObject.getType());
                this.currentObject.setStatus(currentSMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.groups.addElement(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
                break;
            }
            case 9: {
                this.currentObject = new MIBAgentCaps(new ObjectID(currentSMIObject.getPrintableOid(this.smiRep)), currentSMIObject.getName(), this.currentModule.getModuleID());
                this.currentObject.setStatus(currentSMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
                break;
            }
            case 8: {
                this.currentObject = new MIBCompliance(new ObjectID(currentSMIObject.getPrintableOid(this.smiRep)), currentSMIObject.getName(), this.currentModule.getModuleID());
                this.currentObject.setStatus(currentSMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
                break;
            }
            default: {
                this.currentObject = new MIBObject(new ObjectID(currentSMIObject.getPrintableOid(this.smiRep)), currentSMIObject.getName(), this.currentModule.getModuleID());
                this.currentObject.setStatus(currentSMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
            }
        }
        if (this.currentObject != null) {
            this.currentObject.setModuleID(this.currentModule.getModuleID());
            this.currentObject.setSequenceID(currentSMIObject.sequenceID);
            if (!this.currentObject.hasComment()) {
                this.currentObject.setComment(currentSMIObject.asn1Comment);
            }
            if (!this.currentObject.hasInlineComment()) {
                this.currentObject.setInlineComment(currentSMIObject.inlineAsn1Comment);
            }
            this.currentObject.setReleased(1);
            this.currentObject.userObject = currentSMIObject.getToken();
            this.smiRep.addObject(this.currentObject);
        } else {
            this.smiRep.addObject(new MIBObject(new ObjectID(currentSMIObject.getPrintableOid(this.smiRep)), currentSMIObject.getName()));
        }
    }

    protected final StringToken getStringToken(MIBSyntax syn) {
        if (syn == null) {
            return null;
        }
        return syn.userObject != null ? (StringToken)syn.userObject : new StringToken(syn.getSyntax(), null);
    }

    protected void readPibObjectType(PIBObjectType o) throws SMIParseException {
        if (!(this.currentObject instanceof com.agentpp.mib.pib.PIBObjectType)) {
            return;
        }
        this.readObjectType(o);
        com.agentpp.mib.pib.PIBObjectType pot = (com.agentpp.mib.pib.PIBObjectType)this.currentObject;
        pot.setInstallErrors(o.getInstallErrors());
        pot.setUniqueObjects(this.convertStringToken(o.getUniqueObjects()));
        pot.setPibReferences(this.convertStringToken(o.getPibReferences()));
        pot.setTag(this.convertStringToken(o.getTag()));
        this.checkPibObjectType(pot, o);
    }

    protected void readObjectType(SMIObjectType o) throws SMIParseException {
        MIBSyntax syn;
        if (!(this.currentObject instanceof MIBObjectType)) {
            return;
        }
        MIBObjectType ot = (MIBObjectType)this.currentObject;
        ot.setAccess(o.getAccess());
        ot.setUnits(o.getUnits());
        ot.setSyntax(o.syntax);
        this.currentSyntax = syn = o.syntax;
        if (syn == null) {
            return;
        }
        this.checkSyntax(new StringToken(ot.getName(), (Token)ot.userObject), (StringToken)syn.userObject);
        if (syn.getType() == 3 || syn.getType() == 2) {
            this.smiRep.checkUnresolvedSyntax(this.getStringToken(syn));
        }
        if (Character.isUpperCase(syn.getSyntax().charAt(0)) && syn.getType() == 3) {
            this.tableEntryToObject.put(syn.getSyntax(), ot);
            Vector v = this.smiRep.getSequence(syn.getSyntax());
            if (v != null && v.size() > 0) {
                MIBTextualConvention tc = new MIBTextualConvention(syn.getSyntax());
                tc.userObject = this.getStringToken((MIBSyntax)syn).token;
                this.smiRep.addKnownObject(tc);
                Vector<String> vn = new Vector<String>(v.size() + 1);
                Enumeration en = v.elements();
                while (en.hasMoreElements()) {
                    StringToken st = (StringToken)en.nextElement();
                    vn.addElement(st.string);
                }
                ot.setTableEntriesVector(vn);
            }
        }
    }

    protected void checkPibObjectType(com.agentpp.mib.pib.PIBObjectType ot, PIBObjectType o) throws SMIParseException {
        MIBSyntax syntax;
        com.agentpp.mib.pib.PIBObjectType pibIndexObjectType;
        if (ot.getTag() != null && ot.getSyntax() != null && !PIB_TAG_REFERENCE_ID.equals(ot.getSyntax().getSyntax())) {
            this.throwLocalizedError(o.getTag().token, null, 6001, this.getTokenPIBTAG(), 0);
        }
        if (ot.getPibReferences() != null && ot.getSyntax() != null && !PIB_REFERENCE_ID.equals(ot.getSyntax().getSyntax())) {
            this.throwLocalizedError(o.getTag().token, null, 6002, this.getTokenPIBREFERENCES(), 0);
        }
        if (ot.getSyntax() != null && PIB_TAG_REFERENCE_ID.equals(ot.getSyntax().getSyntax()) && ot.getTag() == null) {
            this.throwLocalizedError(ot, null, 6003, this.getTokenPIBREFERENCES(), 0);
        }
        if (ot.getSyntax() != null && PIB_REFERENCE_ID.equals(ot.getSyntax().getSyntax()) && ot.getPibReferences() == null) {
            this.throwLocalizedError((Token)ot.userObject, null, 6004, -1, 0);
        } else if (ot.getPibReferences() != null) {
            this.smiRep.checkUnresolvedObject(o.getPibReferences(), com.agentpp.mib.pib.PIBObjectType.class);
        }
        if (ot.getUniqueObjects() != null && ot.getIndex() instanceof PIBIndexPart && ((PIBIndexPart)ot.getIndex()).isIndex()) {
            HashSet uniqueSet = new HashSet(ot.getUniqueObjects().size());
            for (String unique : ot.getUniqueObjects()) {
                if (ot.getIndex().getIndexPartVector().contains(unique)) {
                    this.throwLocalizedError(ot, new Vector<String>(Arrays.asList(ot.getName(), unique)), 6005, this.getTokenUNIQENESS(), 0);
                }
                if (uniqueSet.contains(unique)) {
                    this.throwLocalizedError(ot, new Vector<String>(Arrays.asList(ot.getName(), unique)), 6006, this.getTokenUNIQENESS(), 0);
                }
                uniqueSet.add(unique);
            }
        }
        if (ot.getInstallErrors() != null) {
            for (MIBEnum installError : ot.getInstallErrors()) {
                if (installError.hasValidValue() && installError.getLongValue() >= 0L && installError.getLongValue() <= 65535L) continue;
                this.throwLocalizedError(ot, new Vector<String>(Arrays.asList(ot.getName(), installError.getValue(), installError.getLabel())), 6007, this.getTokenINSTALLERRORS(), 0);
            }
        }
        if (!((pibIndexObjectType = this.pibInstanceIds.get(ot.getName())) == null || pibIndexObjectType.getIndexPart() == null || pibIndexObjectType.getIndexPart().getType() != 1 || (syntax = ot.getSyntax()) != null && syntax.getType() == 3 && "InstanceId".equals(syntax.getSyntax()))) {
            this.throwLocalizedError(pibIndexObjectType, null, 6000, this.getTokenPIBINDEX(), 0);
        }
    }

    protected void readNotifyType(SMINotifyType o) throws SMIParseException {
        if (!(this.currentObject instanceof MIBNotifyType)) {
            return;
        }
        MIBNotifyType nt = (MIBNotifyType)this.currentObject;
        nt.setEnterprise(o.getEnterprise());
    }

    protected void readSeqEntries(SMISeqEntries s) throws SMIParseException {
        String parent = ((SMIObject)s.jjtGetParent()).getName();
        MIBObject obj = null;
        if (parent.length() == 0) {
            return;
        }
        obj = Character.isUpperCase(parent.charAt(0)) ? (MIBObject)this.tableEntryToObject.get(parent) : this.rep.getObject(parent);
        Vector entries = s.entries();
        Vector<String> names = new Vector<String>(entries.size());
        Enumeration en = entries.elements();
        while (en.hasMoreElements()) {
            Pair p = (Pair)en.nextElement();
            names.add(((StringToken)p.first).string);
            Class c = null;
            if (obj != null && (obj instanceof MIBObjectType || obj instanceof MIBNotifyType)) {
                c = MIBObjectType.class;
            }
            if (obj != null && obj instanceof MIBGroup && obj.getType() == 6) {
                c = MIBObjectType.class;
            } else if (obj != null && obj instanceof MIBGroup) {
                c = MIBNotifyType.class;
            }
            this.smiRep.checkUnresolvedObject((StringToken)p.first, c);
            if (p.second == null) continue;
            this.checkSyntax((StringToken)p.first, (StringToken)p.second);
        }
        this.nameSequences.put(names, entries);
        if (obj != null) {
            if (obj instanceof MIBObjectType) {
                MIBObjectType ot = (MIBObjectType)obj;
                if (!ot.hasIndexPart()) {
                    this.throwInconsistentSyntaxError(ot);
                }
                ot.setTableEntriesVector(names);
                if (ot.getSyntax() != null) {
                    MIBTextualConvention tc = new MIBTextualConvention(ot.getSyntax().getSyntax());
                    tc.userObject = this.getStringToken(ot.getSyntax());
                    this.smiRep.addKnownObject(tc);
                }
            }
            if (obj instanceof MIBNotifyType) {
                MIBNotifyType nt = (MIBNotifyType)obj;
                nt.setVariablesVector(names);
            }
            if (obj instanceof MIBGroup) {
                MIBGroup mg = (MIBGroup)obj;
                mg.setObjectsVector(names);
            }
        } else {
            Vector v = this.smiRep.getSequence(parent);
            if (v != null) {
                Enumeration en2 = entries.elements();
                while (en2.hasMoreElements()) {
                    Pair st = (Pair)en2.nextElement();
                    v.add(st.first);
                }
            }
        }
    }

    protected void throwInconsistentSyntaxError(MIBObjectType ot) throws SMIParseException {
        if (ot.userObject != null && ot.userObject instanceof Token) {
            this.throwLocalizedError(ot, new Vector<String>(Arrays.asList(ot.getName())), 1200, 63, 1);
        } else {
            this.error(new SMIParseException(ot.getName(), 1200));
        }
    }

    protected List<String> convertStringToken(List<StringToken> stringTokens) {
        if (stringTokens == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(stringTokens.size());
        for (StringToken stringToken : stringTokens) {
            result.add(stringToken.string);
        }
        return result;
    }

    protected String convertStringToken(StringToken stringToken) {
        return stringToken == null ? null : stringToken.string;
    }

    protected void readRevision(SMIRevision r) throws SMIParseException {
        this.currentModule.addRevision(new MIBRevision(r.getRevision(), r.getDescription()));
    }

    protected void readSyntax(SMISyntax syn) throws SMIParseException {
        MIBSyntax s = new MIBSyntax(syn.getSyntax().string, syn.getType());
        s.userObject = syn.getSyntax();
        if (!(syn.jjtGetParent() instanceof SMISeqEntries) && this.currentObject instanceof MIBAgentCaps && (syn.getType() == 3 || syn.getType() == 2)) {
            this.smiRep.checkUnresolvedSyntax(this.getStringToken(s));
        }
        if (this.currentSyntax == null) {
            this.currentSyntax = s;
        }
    }

    protected void readRange(SMIRange r) throws SMIParseException {
        if (this.currentSyntax != null) {
            this.currentSyntax.addRange(new MIBRange(r.getLower(), r.getUpper()));
        }
    }

    protected void readEnum(SMIEnum e) throws SMIParseException {
        if (this.currentSyntax != null) {
            this.currentSyntax.addEnum(new MIBEnum(e.getLabel(), e.getValue(), e.comment));
        } else if (this.currentObject instanceof com.agentpp.mib.pib.PIBModule) {
            List<? extends IEnum> clist;
            com.agentpp.mib.pib.PIBModule pModule = (com.agentpp.mib.pib.PIBModule)this.currentObject;
            if (pModule.getCategories() == null) {
                clist = new ArrayList<IEnum>();
                pModule.setCategories(clist);
            } else {
                clist = pModule.getCategories();
            }
            clist.add(new MIBEnum(e.getLabel(), e.getValue(), e.comment));
        }
    }

    protected void readVariable(StringToken v) {
        Class c = null;
        c = this.currentObject instanceof MIBGroup && ((MIBGroup)this.currentObject).getType() == 7 ? MIBNotifyType.class : MIBObjectType.class;
        this.smiRep.checkUnresolvedObject(v, c);
        if (this.currentObject instanceof MIBNotifyType) {
            MIBNotifyType nt = (MIBNotifyType)this.currentObject;
            nt.addVariable(v.string);
            this.addObjectToObjectsList(nt.getName(), v);
        }
        if (this.currentObject instanceof MIBGroup) {
            MIBGroup mg = (MIBGroup)this.currentObject;
            mg.addObject(v.string);
            this.addObjectToObjectsList(mg.getName(), v);
        }
    }

    protected void addObjectToObjectsList(String objectName, StringToken objectItem) {
        this.objectLists.put(objectName + " " + objectItem.string, objectItem);
    }

    protected void readIndex(SMIIndex index) throws SMIParseException {
        MIBObject at;
        String module;
        Vector entries = index.getIndecies();
        Vector<String> indexes = new Vector<String>(entries.size() + 1);
        MIBObjectType ot = (MIBObjectType)this.currentObject;
        Enumeration en = entries.elements();
        while (en.hasMoreElements()) {
            Class<MIBObjectType> c = MIBObjectType.class;
            StringToken s = (StringToken)en.nextElement();
            if (this.currentModule.getSMIVersion() != 1 || !SMI.isASN1KeyWord(s.string)) {
                this.smiRep.checkUnresolvedObject(s, c);
                if (ot instanceof com.agentpp.mib.pib.PIBObjectType) {
                    MIBSyntax syntax;
                    module = this.currentModule.getImportSource(s.string);
                    at = null;
                    at = module == null ? this.currentModule.getObjectByName(s.string) : this.smiRep.getObject(module, s.string);
                    if (at == null) {
                        this.smiRep.checkUnresolvedSyntax(new StringToken(s.string, s.token));
                        this.pibInstanceIds.put(s.string, (com.agentpp.mib.pib.PIBObjectType)ot);
                    } else if (!(at instanceof com.agentpp.mib.pib.PIBObjectType) || index.getType() == 1 && !((MIBObjectType)at).isColumnarObject()) {
                        this.throwInvalidIndex(ot, 1810);
                    } else if (!(index.getType() != 1 || (syntax = ((MIBObjectType)at).getSyntax()) != null && syntax.getType() == 3 && "InstanceId".equals(syntax.getSyntax()))) {
                        this.throwLocalizedError(s.token, 6000);
                    }
                }
            }
            indexes.add(s.string);
        }
        if (ot == null) {
            return;
        }
        int type = index.getType() == 2 ? 2 : (index.getType() == 3 ? 3 : 1);
        MIBIndexPart ip = index instanceof PIBIndex ? new PIBIndexPart(type, indexes) : new MIBIndexPart(type, indexes);
        ip.setImplied(index.getImplied());
        if (ot instanceof com.agentpp.mib.pib.PIBObjectType) {
            if (!(index instanceof PIBIndex)) {
                ((com.agentpp.mib.pib.PIBObjectType)ot).setMibIndexPart(ip);
            } else {
                ot.setIndexPart(ip);
            }
        } else {
            ot.setIndexPart(ip);
        }
        if (ip.isAugment() || ip instanceof PIBIndexPart && ((PIBIndexPart)ip).isExtends()) {
            String augmented = (String)ip.getIndexPartVector().get(0);
            module = this.currentModule.getImportSource(augmented);
            at = null;
            at = module == null ? this.currentModule.getObjectByName(augmented) : this.smiRep.getObject(module, augmented);
            if (at == null) {
                this.smiRep.checkUnresolvedSyntax(new StringToken(augmented, index.getToken()));
            } else if (!(at instanceof MIBObjectType) || !((MIBObjectType)at).isTable()) {
                this.throwLocalizedError(ot, new Vector<String>(Arrays.asList(augmented, at.getTypeString())), 1600, this.getTokenINDEX(), 1);
            } else if (((MIBObjectType)at).getIndexPart() != null && !(ip instanceof PIBIndexPart) && ((MIBObjectType)at).getIndexPart().isAugment()) {
                this.throwInvalidIndex(ot);
            }
        }
    }

    private void checkIndexLength(MIBObjectType ot, MIBIndexPart indexPart) throws SMIParseException {
        if (indexPart != null) {
            IndexStruct[] is = indexPart.getIndexStruct(this.smiRep.scope.rep);
            if (is == null) {
                is = indexPart.getIndexStruct(this.rep);
            }
            if (is == null) {
                return;
            }
            int sumLength = ot.getOid().size();
            for (int i = 0; i < is.length; ++i) {
                if (is[i] == null) continue;
                sumLength += is[i].minLength;
                if (is[i].minLength == is[i].maxLength) continue;
                ++sumLength;
            }
            if (is[is.length - 1] != null) {
                int maxLength = is[is.length - 1].maxLength;
                if (maxLength <= 0 || sumLength > 128) {
                    this.throwInvalidIndex(ot, 1812);
                }
                int minLength = is[is.length - 1].minLength;
                if (indexPart.isImplied() && minLength != maxLength && minLength == 0) {
                    this.throwInvalidImpliedLengthIndex(ot);
                }
            }
        }
    }

    protected int getTokenINDEX() {
        return 54;
    }

    private void throwInvalidIndex(MIBObjectType ot) throws SMIParseException {
        this.throwInvalidIndex(ot, 1810);
    }

    private void throwInvalidIndex(MIBObjectType ot, int error) throws SMIParseException {
        if (ot.userObject != null && ot.userObject instanceof Token) {
            Token t = (Token)ot.userObject;
            this.error(new SMIParseException(new SemanticError(error, t.beginLine, t.beginColumn, t.endPos, t, ot.getName(), t.image, new String[0]), error));
        } else {
            this.error(new SMIParseException(ot.getName(), error));
        }
    }

    private void throwInvalidImpliedLengthIndex(MIBObjectType ot) throws SMIParseException {
        this.throwInvalidIndex(ot, 1813);
    }

    public final void throwLocalizedError(MIBObject ot, Vector objects, int error, int preceedingToken, int offset) throws SMIParseException {
        if (ot.userObject != null && ot.userObject instanceof Token) {
            Token t = (Token)ot.userObject;
            while (t.next != null && t.kind != preceedingToken) {
                t = t.next;
            }
            for (int i = 0; i < offset && t.next != null; ++i) {
                t = t.next;
            }
            this.error(new SMIParseException(new SemanticError(error, t.beginLine, t.beginColumn, t.endPos, t, ot.getName(), t.image, new String[0]), error, (List)objects));
        } else {
            this.error(new SMIParseException(ot.getName(), error, (List)objects));
        }
    }

    public final void throwLocalizedError(MIBObject ot, Vector objects, int error, int preceedingToken, int offset, int errorObjectIndex) throws SMIParseException {
        if (ot.userObject != null && ot.userObject instanceof Token) {
            Token t = (Token)ot.userObject;
            while (t.next != null && t.kind != preceedingToken) {
                t = t.next;
            }
            for (int i = 0; i < offset && t.next != null; ++i) {
                t = t.next;
            }
            this.error(new SMIParseException(new SemanticError(error, t.beginLine, t.beginColumn, t.endPos, t, errorObjectIndex < 0 ? ot.getName() : (String)objects.get(errorObjectIndex), t.image, new String[0]), error, (List)objects));
        } else {
            this.error(new SMIParseException(ot.getName(), error, (List)objects));
        }
    }

    public final void throwLocalizedError(Token t, List objects, int error, int preceedingToken, int offset) throws SMIParseException {
        if (preceedingToken >= 0) {
            while (t.next != null && t.kind != preceedingToken) {
                t = t.next;
            }
        }
        for (int i = 0; i < offset && t.next != null; ++i) {
            t = t.next;
        }
        this.error(new SMIParseException(new SemanticError(error, t.beginLine, t.beginColumn, t.endPos, t, objects != null && objects.size() > 0 ? objects.get(0).toString() : t.image, t.image, new String[0]), error, objects));
    }

    public final void throwLocalizedError(Token t, List objects, int error, int preceedingToken, String foundImage) throws SMIParseException {
        if (preceedingToken >= 0) {
            while (t.next != null && t.kind != preceedingToken) {
                t = t.next;
            }
        }
        if (foundImage != null) {
            while (t.next != null && !t.image.equals(foundImage)) {
                t = t.next;
            }
        }
        this.error(new SMIParseException(new SemanticError(error, t.beginLine, t.beginColumn, t.endPos, t, foundImage == null ? objects.get(0).toString() : foundImage, t.image, new String[0]), error, objects));
    }

    public final void throwLocalizedError(Token t, List objects, int error, String foundImage) throws SMIParseException {
        if (foundImage != null) {
            while (t.next != null && !t.image.equals(foundImage)) {
                t = t.next;
            }
        }
        this.error(new SMIParseException(new SemanticError(error, t.beginLine, t.beginColumn, t.endPos, t, foundImage == null ? objects.get(0).toString() : foundImage, t.image, new String[0]), error, objects));
    }

    public final void throwLocalizedError(Token t, int error) throws SMIParseException {
        this.error(new SMIParseException(new SemanticError(error, t.beginLine, t.beginColumn, t.endPos, t, t.image, t.image, new String[0]), error, new Vector(1)));
    }

    public final void throwNegativeIndex(MIBObjectType ot, String oname) throws SMIParseException {
        Vector<String> v = new Vector<String>(2);
        v.add(ot.getName());
        v.add(oname);
        if (ot.userObject != null && ot.userObject instanceof Token) {
            Token t = (Token)ot.userObject;
            while (t.next != null && t.kind != 54) {
                t = t.next;
            }
            for (int i = 0; i < 2 && t.next != null; ++i) {
                t = t.next;
            }
            this.error(new SMIParseException(new SemanticError(1820, t.beginLine, t.beginColumn, t.endPos, t, ot.getName(), t.image, new String[0]), 1820, v));
        } else {
            this.error(new SMIParseException(ot.getName(), 1820, v));
        }
    }

    protected void checkDefaultValue(MIBObjectType ot, MIBSyntax refinement, String defaultValue, Token objectToken, int tokenType) throws SMIParseException {
        MIBTextualConvention tc;
        if (!ot.hasDefaultValue()) {
            return;
        }
        Object value = MIBObjectType.getDefaultValue(this.smiRep.scope.rep, refinement, defaultValue);
        if (value == null) {
            this.throwLocalizedError(objectToken, new Vector<Object>(Arrays.asList(ot.getName())), 3002, tokenType, 2);
        }
        if ((tc = this.smiRep.scope.rep.getEffectiveSyntax(refinement)).getSyntax() != null) {
            long len;
            if (SMI.isCounter(tc.getSyntax().getSyntax())) {
                this.throwLocalizedError(objectToken, new Vector<Object>(Arrays.asList(ot.getName())), 3003, tokenType, 2);
            }
            if (value instanceof Number) {
                long v = (Long)value;
                if (!tc.getSyntax().isIncludedInRanges(v) || SMI.isUnsignedNumeric(tc.getSyntax().getSyntax()) && (v < 0L || v > 0xFFFFFFFFL) || SMI.SMI_SYNTAX[8].equals(tc.getSyntax().getSyntax()) && (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE)) {
                    this.throwLocalizedError(objectToken, new Vector<Object>(Arrays.asList(ot.getName())), 3000, tokenType, 2);
                }
            } else if (value instanceof byte[]) {
                long len2 = ((byte[])value).length;
                if (tc.getSyntax().getSyntax().equals(SMI.SMI_SYNTAX[9]) && len2 != 4L || !tc.getSyntax().isIncludedInRanges(len2)) {
                    this.throwLocalizedError(objectToken, new Vector<Object>(Arrays.asList(ot.getName())), 3000, tokenType, 2);
                }
            } else if (value instanceof ObjectID && (len = (long)((ObjectID)value).size()) > 128L) {
                this.throwLocalizedError(objectToken, new Vector<Object>(Arrays.asList(ot.getName())), 3000, tokenType, 2);
            }
        }
    }

    public void checkDefaultValue(MIBObjectType ot) throws SMIParseException {
        if (ot.hasDefaultValue() && ot.getSyntax() != null) {
            Object value = ot.getDefaultValue(this.smiRep.scope.rep);
            if (value == null) {
                this.throwLocalizedError(ot, new Vector<Object>(Arrays.asList(ot.getName())), 3002, this.getTokenDEFVAL(), 2);
            }
            if (ot.getSyntax() != null) {
                long len;
                MIBTextualConvention tc = this.smiRep.scope.rep.getEffectiveSyntax(ot.getSyntax());
                if (SMI.isCounter(tc.getSyntax().getSyntax())) {
                    this.throwLocalizedError(ot, new Vector<Object>(Arrays.asList(ot.getName())), 3003, this.getTokenDEFVAL(), 2);
                }
                if (value instanceof Number) {
                    long v = (Long)value;
                    if (!tc.getSyntax().isIncludedInRanges(v) || SMI.isUnsignedNumeric(tc.getSyntax().getSyntax()) && (v < 0L || v > 0xFFFFFFFFL) || SMI.SMI_SYNTAX[8].equals(tc.getSyntax().getSyntax()) && (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE)) {
                        this.throwLocalizedError(ot, new Vector<Object>(Arrays.asList(ot.getName())), 3000, this.getTokenDEFVAL(), 2);
                    }
                } else if (value instanceof byte[]) {
                    long len2 = ((byte[])value).length;
                    if (tc.getSyntax().getSyntax().equals(SMI.SMI_SYNTAX[9]) && len2 != 4L || !tc.getSyntax().isIncludedInRanges(len2)) {
                        this.throwLocalizedError(ot, new Vector<Object>(Arrays.asList(ot.getName())), 3000, this.getTokenDEFVAL(), 2);
                    }
                } else if (value instanceof ObjectID && (len = (long)((ObjectID)value).size()) > 128L) {
                    this.throwLocalizedError(ot, new Vector<Object>(Arrays.asList(ot.getName())), 3000, this.getTokenDEFVAL(), 2);
                }
            }
        }
    }

    protected void checkVariation(String module, MIBVariation mv, Token t) throws SMIParseException {
        MIBModule src;
        String srcModule;
        MIBObject o = null;
        MIBObjectType ot = null;
        o = module != null && module.length() > 0 && !module.equals(this.currentModule.getModuleName()) ? this.smiRep.scope.rep.getObject(module, mv.getVariation()) : this.rep.getObject(mv.getVariation());
        if (o == null && (srcModule = this.currentModule.getImportSource(mv.getVariation())) != null && (src = this.smiRep.scope.rep.getModule(srcModule)) != null) {
            o = src.getObjectByName(mv.getVariation());
        }
        if (mv instanceof MIBCondGroup) {
            if (!(o instanceof MIBGroup)) {
                this.throwLocalizedError(t, new Vector<String>(Arrays.asList(o == null ? "undefined" : o.getTypeString(), mv.getVariation())), 1601, -1, 0);
            }
            return;
        }
        if (o instanceof MIBNotifyType) {
            if (mv.hasAccess() && !mv.getAccess().equals(SMI.ACCESS[6])) {
                this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 1050, this.getTokenACCESS(), 0);
            }
            if (mv instanceof MIBException && ((MIBException)mv).hasAccess() && !mv.getAccess().equals(SMI.ACCESS[6])) {
                this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 1050, this.getTokenACCESS(), 0);
            }
            if (mv.hasSyntax()) {
                this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 1050, this.getTokenSYNTAX(), 0);
            }
            if (mv.hasWriteSyntax()) {
                this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 1050, this.getTokenWRITESYNTAX(), 0);
            }
            if (mv.hasDefaultValue()) {
                this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 1050, this.getTokenDEFVAL(), 0);
            }
        } else if (o == null) {
            this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 1502, -1, 0);
        } else if (!(o instanceof MIBObjectType)) {
            this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation(), o == null ? "unknown" : o.getTypeString())), 1602, -1, 0);
        } else {
            ot = (MIBObjectType)o;
            if (ot.getSyntax() != null) {
                MIBSyntax syntax = this.smiRep.scope.rep.getEffectiveSyntax(ot.getSyntax()).getSyntax();
                if (mv.hasSyntax()) {
                    syntax = this.smiRep.scope.rep.getEffectiveSyntax(mv.getSyntax()).getSyntax();
                    if (!ot.getSyntax().isRestrictiveSyntax(this.smiRep.scope.rep, mv.getSyntax())) {
                        this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 4000, this.getTokenSYNTAX(), 1);
                    }
                }
                if (mv.hasSyntax()) {
                    if (SMI.isCounter(mv.getSyntax().getSyntax())) {
                        this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 3003, this.getTokenSYNTAX(), 1);
                    } else if (mv.hasDefaultValue()) {
                        this.checkDefaultValue(ot, syntax, mv.getDefval(), t, this.getTokenDEFVAL());
                    }
                }
                if (mv.hasWriteSyntax()) {
                    if (SMI.isCounter(mv.getWriteSyntax().getSyntax())) {
                        this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 3003, this.getTokenWRITESYNTAX(), 1);
                    }
                    if (!ot.getSyntax().isRestrictiveSyntax(this.smiRep.scope.rep, mv.getWriteSyntax())) {
                        this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 4000, this.getTokenWRITESYNTAX(), 1);
                    }
                }
                if (mv.hasCreationRequires()) {
                    if (!ot.isTable()) {
                        this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 1220, this.getTokenCREATION_REQUIRES(), 0);
                    } else {
                        for (String cr : mv.getCreationRequiresVector()) {
                            MIBObjectType column;
                            MIBObject col = module != null && module.length() > 0 && !module.equals(this.currentModule.getModuleName()) ? this.smiRep.scope.rep.getObject(module, cr) : this.rep.getObject(cr);
                            if (!(col instanceof MIBObjectType) || (column = (MIBObjectType)col).isColumnarObject() && column.getAccess().equals(SMI.ACCESS[3])) continue;
                            this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 1221, this.getTokenCREATION_REQUIRES(), cr);
                        }
                    }
                }
            }
        }
    }

    protected final int getTokenCREATION_REQUIRES() {
        return 100;
    }

    protected final int getTokenACCESS() {
        return 59;
    }

    protected void checkWhetherIndexIsPositive(MIBObjectType ot) throws SMIParseException {
        if (ot.getIndexPart().isAugment() || ot.getIndexPart().getType() == 3 || ot.getOid() == null || !ot.getOid().isValid()) {
            return;
        }
        if (!ot.isTable()) {
            this.throwLocalizedError(ot, new Vector(), 1851, 54, 0);
        }
        int n = 0;
        MIBIndexPart indexPart = ot instanceof com.agentpp.mib.pib.PIBObjectType ? ((com.agentpp.mib.pib.PIBObjectType)ot).getMibIndexPart() : ot.getIndexPart();
        if (indexPart != null) {
            Enumeration en = indexPart.getIndexPartVector().elements();
            while (en.hasMoreElements()) {
                String oname = en.nextElement().toString();
                MIBObject o = this.smiRep.scope.rep.getObject(oname);
                if (o == null) {
                    o = this.smiRep.getKnownObject(oname);
                }
                if (!(o instanceof MIBObjectType)) {
                    this.throwInvalidIndex(ot);
                } else {
                    MIBTextualConvention tc;
                    MIBSyntax effective;
                    if (!((MIBObjectType)o).isColumnarObject()) {
                        Vector<String> objs = new Vector<String>(2);
                        objs.add(ot.getName());
                        objs.add(oname);
                        this.throwLocalizedError(ot, objs, 1850, 54, 2 + n * 2);
                    }
                    if (((MIBObjectType)o).getSyntax() != null && !SMI.isUnsignedNumeric((effective = (tc = this.rep.getEffectiveSyntax(((MIBObjectType)o).getSyntax())).getSyntax()).getSyntax()) && SMI.isNumeric(effective.getSyntax()) && Math.max(effective.getMinOfRanges(), effective.getMinOfEnums()) < 0L) {
                        this.throwNegativeIndex(ot, o.getName());
                    }
                }
                ++n;
            }
        }
        this.checkIndexLength(ot, ot.getIndexPart());
        if (ot instanceof com.agentpp.mib.pib.PIBObjectType) {
            this.checkIndexLength(ot, indexPart);
        }
    }

    protected String readImports(MIBImport list) throws SMIParseException {
        String cyclic;
        String source = list.getSource();
        Vector<String> entries = list.getImportsVector();
        Token[] token = (Token[])list.getUserObject();
        if (!(this.smiRep.isModuleAlreadyImported(source) || this.smiRep.importModule(source, this.rep, false) || this.failedImports.contains(source))) {
            this.failedImports.add(source);
            this.throwLocalizedError(token[1], new Vector<String>(Arrays.asList(source)), 1100, source);
        }
        if ((cyclic = this.smiRep.hasCircularImport(source, this.currentModule.getModuleName())) != null) {
            this.throwLocalizedError(token[1], new Vector<String>(Arrays.asList(cyclic)), 1101, source);
        }
        Enumeration<String> en = entries.elements();
        while (en.hasMoreElements()) {
            Vector<String> v;
            String oname = en.nextElement();
            if (SMI.isASN1KeyWord(oname)) {
                this.throwLocalizedError(token[0], new Vector<String>(Arrays.asList(oname)), 1114, oname);
                continue;
            }
            MIBObject o = this.smiRep.getObject(source, oname);
            if (o instanceof MIBNotifyType) {
                v = new Vector<String>(1);
                v.add(o.getName());
                this.throwLocalizedError(token[0], v, 1114, o.getName());
                continue;
            }
            if (o != null) {
                Vector sources = this.currentModule.getImportSources(oname);
                if (sources.size() > 0) {
                    if (!sources.contains(source)) {
                        MIBObject dup = this.smiRep.getKnownObject(oname);
                        String moduleName = this.smiRep.getModuleName(dup.getModuleID());
                        if (moduleName != null) {
                            dup = dup.getClone();
                            dup.setName(moduleName + "." + dup.getName());
                            this.smiRep.replaceKnownObject(oname, dup);
                        }
                    } else {
                        Vector<String> v2 = new Vector<String>(2);
                        v2.add(oname);
                        v2.add(source);
                        this.throwLocalizedError(token[0], v2, 1113, null);
                    }
                    o = o.getClone();
                    o.setName(source + "." + o.getName());
                    this.smiRep.addKnownObject(o);
                    continue;
                }
                this.smiRep.addKnownObject(o);
                continue;
            }
            if (SMI.isKeyWord(oname) || source == null || this.failedImports.contains(source)) continue;
            v = new Vector(2);
            v.add(oname);
            v.add(source);
            this.throwLocalizedError(token[0].next, v, 1112, null);
        }
        MIBImport mi = new MIBImport(source, entries, list.getComment());
        this.currentModule.addImport(mi);
        this.smiRep.createOids(this.currentModule.getModuleName());
        return source;
    }

    protected void checkAgentCaps(MIBAgentCaps ac) throws SMIParseException {
        Enumeration<MIBSupportedModule> en = ac.getModules().elements();
        while (en.hasMoreElements()) {
            MIBSupportedModule m = en.nextElement();
            Enumeration ven = m.getVariationsVector().elements();
            while (ven.hasMoreElements()) {
                MIBVariation mv = (MIBVariation)ven.nextElement();
                this.smiRep.checkUnresolvedObject(new StringToken(mv.getVariation(), null), null);
                this.checkVariation(m.getSupports(), mv, (Token)mv.getUserObject());
            }
        }
    }

    protected void readAgentCaps(SMIAgentCapabilities node) throws SMIParseException {
        MIBAgentCaps ac = (MIBAgentCaps)this.currentObject;
        if (ac == null) {
            return;
        }
        ac.setProductRelease(node.productRelease);
        Vector v = node.acModules;
        ac.setModules(v);
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            MIBSupportedModule sm = (MIBSupportedModule)en.nextElement();
            if (!this.smiRep.isModuleAlreadyImported(sm.getSupports()) && !this.smiRep.importModule(sm.getSupports(), this.rep, true)) {
                this.throwLocalizedError((Token)sm.getUserObject(), new Vector<String>(Arrays.asList(sm.getSupports())), 1100, this.getTokenSUPPORTS(), sm.getSupports());
            }
            for (int i = 0; i < sm.getIncludes().size(); ++i) {
                StringToken str = (StringToken)sm.getIncludes().get(i);
                sm.getIncludes().set(i, str.string);
                Class<MIBGroup> c = MIBGroup.class;
                this.smiRep.checkUnresolvedObject(str, c);
            }
            Enumeration ven = sm.getVariationsVector().elements();
            while (ven.hasMoreElements()) {
                MIBVariation mv = (MIBVariation)ven.nextElement();
                this.smiRep.checkUnresolvedObject(new StringToken(mv.getVariation(), null), null);
                for (int i = 0; i < mv.getCreationRequiresVector().size(); ++i) {
                    StringToken str = (StringToken)mv.getCreationRequiresVector().get(i);
                    mv.getCreationRequiresVector().set(i, str.string);
                    Class<MIBObjectType> c = MIBObjectType.class;
                    this.smiRep.checkUnresolvedObject(str, c);
                }
            }
        }
    }

    protected void readCompliance(SMICompliance node) throws SMIParseException {
        if (!(this.currentObject instanceof MIBCompliance)) {
            return;
        }
        MIBCompliance mc = (MIBCompliance)this.currentObject;
        mc.setModules(node.modules);
        if (node.modules != null) {
            for (Object mo : node.modules) {
                MIBComplianceModule mcm;
                String moduleName;
                if (!(mo instanceof MIBComplianceModule) || (moduleName = (mcm = (MIBComplianceModule)mo).getModuleName()) == null || moduleName.trim().length() <= 0 || this.smiRep.isModuleAlreadyImported(moduleName)) continue;
                this.smiRep.importModule(moduleName, this.rep, true);
            }
        }
    }

    @Override
    public Object visit(SimpleNode node, Object data) throws SMIParseException {
        this.healBrokenNodeStructure(node, data);
        if (this.currentModuleInfo != null || node.getId() == -4 || node.getId() == -29) {
            switch (node.getId()) {
                case -5: {
                    this.currentFile = ((SMIFile)node).getName();
                    break;
                }
                case -4: {
                    if (this.currentModuleInfo != null) break;
                    this.smiRep.setScope(((SMIMib)node).getName(), this);
                    this.currentModuleInfo = this.readModule((SMIMib)node);
                    ((Vector)data).addElement(this.currentModuleInfo);
                    break;
                }
                case -29: {
                    this.smiRep.setScope(((PIBMib)node).getName(), this);
                    this.currentModuleInfo = this.readModule((PIBMib)node);
                    ((Vector)data).addElement(this.currentModuleInfo);
                    break;
                }
                case -3: {
                    this.readModuleIdentity((SMIModule)node);
                    break;
                }
                case -30: {
                    this.readPibModuleIdentity((PIBModule)node);
                    break;
                }
                case -1: {
                    this.currentSyntax = null;
                    if (((SMIObject)node).getType() == 11) break;
                    try {
                        this.readObject((SMIObject)node);
                    }
                    catch (SMIParseException re) {
                        this.error(re);
                    }
                    break;
                }
                case -16: {
                    this.readObjectType((SMIObjectType)node);
                    break;
                }
                case -31: {
                    this.readPibObjectType((PIBObjectType)node);
                    break;
                }
                case -15: {
                    this.readNotifyType((SMINotifyType)node);
                    break;
                }
                case -12: {
                    break;
                }
                case -20: {
                    this.readSeqEntries((SMISeqEntries)node);
                    break;
                }
                case -7: {
                    if (this.currentObject == null) break;
                    SMIDescription descr = (SMIDescription)node;
                    if (descr.alreadyAssigned) break;
                    this.currentObject.setDescription(descr.getValue());
                    break;
                }
                case -24: {
                    if (this.currentObject == null) break;
                    this.currentObject.setReference(node.toString());
                    break;
                }
                case -19: {
                    this.readRevision((SMIRevision)node);
                    break;
                }
                case -8: {
                    if (!(this.currentObject instanceof MIBObjectType)) break;
                    MIBObjectType ot = (MIBObjectType)this.currentObject;
                    ot.setDefaultValue(((SMIDefaultValue)node).getDefaultValue().string);
                    if (!ot.hasDefaultValue() || ot.getSyntax() == null || ot.getDefaultValue().indexOf("{") >= 0 || !ot.getSyntax().getSyntax().equals(SMI.SMI_SYNTAX[2])) break;
                    this.smiRep.checkUnresolvedObject(((SMIDefaultValue)node).getDefaultValue(), MIBObject.class);
                    break;
                }
                case -21: {
                    this.readSyntax((SMISyntax)node);
                    break;
                }
                case -23: {
                    this.readVariable(new StringToken(node.toString(), node.getToken()));
                    break;
                }
                case -14: {
                    this.readIndex((SMIIndex)node);
                    break;
                }
                case -22: {
                    MIBTextualConvention tc = (MIBTextualConvention)this.currentObject;
                    SMITextualConvention t = (SMITextualConvention)node;
                    tc.setDisplayHint(t.getDisplayHint());
                    tc.setSyntax(t.syntax);
                    this.currentSyntax = t.syntax;
                    this.checkSyntax(new StringToken(tc.getName(), (Token)tc.userObject), (StringToken)this.currentSyntax.userObject);
                    switch (this.currentSyntax.getType()) {
                        case 2: 
                        case 3: {
                            this.smiRep.checkUnresolvedSyntax(this.getStringToken(this.currentSyntax));
                        }
                    }
                    this.smiRep.replaceKnownObject(tc.getName(), tc);
                    break;
                }
                case -9: {
                    this.readAgentCaps((SMIAgentCapabilities)node);
                    break;
                }
                case -11: {
                    this.readCompliance((SMICompliance)node);
                }
            }
        }
        node.childrenAccept(this, data);
        if (node.getId() == -4) {
            this.checkModule();
            this.currentModuleInfo = null;
        }
        return data;
    }

    protected void healBrokenNodeStructure(SimpleNode node, Object data) throws SMIParseException {
        if (this.currentModuleInfo == null && node.getId() != 0 && node.getId() != -4 && node.getId() != -29 && node.getId() != -5 && node.children != null) {
            for (Node childNode : node.children) {
                if (!(childNode instanceof SimpleNode)) continue;
                SimpleNode simpleNode = (SimpleNode)childNode;
                if (simpleNode.getId() == -4) {
                    this.smiRep.setScope(((SMIMib)simpleNode).getName(), this);
                    this.currentModuleInfo = this.readModule((SMIMib)simpleNode);
                    ((Vector)data).addElement(this.currentModuleInfo);
                    continue;
                }
                if (simpleNode.getId() != -29) continue;
                this.smiRep.setScope(((PIBMib)simpleNode).getName(), this);
                this.currentModuleInfo = this.readModule((PIBMib)simpleNode);
                ((Vector)data).addElement(this.currentModuleInfo);
                break;
            }
        }
    }

    public void checkModule() throws SMIParseException {
        int v;
        Iterator en;
        this.smiRep.resolveNames();
        this.smiRep.resolveSyntaxes();
        if (this.smiRep.existsUnresolvedNames()) {
            this.checkUnresolvedNames();
        }
        this.smiRep.resolveSyntaxes();
        if (this.smiRep.existsUnresolvedSyntaxes()) {
            en = this.smiRep.getUnresolvedSyntaxes();
            while (en.hasNext()) {
                Map.Entry entry = (Map.Entry)en.next();
                StringToken st = (StringToken)entry.getKey();
                if (st.token == null) {
                    this.error(new SMIParseException(st.string, 1500, new Vector<Object>(Arrays.asList(st.string))));
                    continue;
                }
                this.throwLocalizedError(st.token, 1500);
            }
        }
        if (this.smiRep.existsWrongTypes()) {
            en = this.smiRep.getWrongTypes();
            while (en.hasNext()) {
                Object[] wrongType = (Object[])en.next();
                this.throwLocalizedError(((StringToken)wrongType[0]).token, new Vector<Object>(Arrays.asList(wrongType)), 1700, null);
            }
        }
        if ((v = this.currentModule.getSMIVersion()) != 1) {
            this.rep.structureChanged();
            this.checkAccess();
        }
        Hashtable h = this.buildImportHash(this.currentModule);
        Enumeration<? extends MIBObject> en2 = this.rep.objectsByName();
        while (en2.hasMoreElements()) {
            MIBObject o = en2.nextElement();
            if (this.currentModule != null && !o.getModuleID().equals(this.currentModule.getModuleID())) continue;
            this.checkImports(this.currentModule, o, h);
            if (v == 1) continue;
            this.checkGroups(o);
            this.recheckObject(o);
        }
        ++this.moduleCount;
    }

    public void recheckObject(MIBObject o) throws SMIParseException {
        if (o instanceof MIBObjectType) {
            Object stringToken;
            MIBObjectType ot = (MIBObjectType)o;
            if (ot.hasIndexPart()) {
                this.checkWhetherIndexIsPositive(ot);
            }
            if (!ot.isTable() && ot.getSyntax() != null && ot.getSyntax().getType() == 3) {
                this.checkRestrictedSyntax((Token)ot.userObject, ot.getName(), ot.getSyntax(), this.getTokenSYNTAX());
            }
            this.checkDefaultValue(ot);
            if (ot instanceof com.agentpp.mib.pib.PIBObjectType) {
                this.checkPibObjectTypeRefs((com.agentpp.mib.pib.PIBObjectType)ot);
            }
            if (ot.getSyntax() != null && (stringToken = ot.getSyntax().userObject) instanceof StringToken) {
                this.checkRanges(((StringToken)stringToken).token, ot.getSyntax());
            }
        } else if (o instanceof MIBAgentCaps) {
            this.checkAgentCaps((MIBAgentCaps)o);
        } else if (o instanceof MIBCompliance) {
            this.checkCompliance((MIBCompliance)o);
        } else if (o instanceof MIBTextualConvention) {
            Object stringToken;
            MIBTextualConvention tc = (MIBTextualConvention)o;
            this.checkDisplayHint(tc);
            if (tc.getSyntax() != null && (stringToken = tc.getSyntax().userObject) instanceof StringToken) {
                this.checkRanges(((StringToken)stringToken).token, tc.getSyntax());
            }
        }
    }

    private void checkRanges(Token token, MIBSyntax mibSyntax) throws SMIParseException {
        MIBTextualConvention base = this.smiRep.scope.rep.getEffectiveSyntax(mibSyntax);
        boolean isUsignedNumeric = SMI.isUnsignedNumeric(base.getSyntax().getSyntax());
        if (isUsignedNumeric && mibSyntax.hasRanges()) {
            Vector<MIBRange> ranges = mibSyntax.getRangesVector();
            for (MIBRange r : ranges) {
                if (r.getLowerValue() >= 0L) continue;
                List<String> params = Arrays.asList("boundary " + r.getLowerValue() + " is negative although SYNTAX '" + base.getSyntax().getSyntax() + "' is unsigned");
                this.throwLocalizedError(token, params, 4010, this.getTokenRANGE(), null);
            }
        }
    }

    private void checkPibObjectTypeRefs(com.agentpp.mib.pib.PIBObjectType ot) throws SMIParseException {
        Vector<String> v;
        MIBObject refObject;
        if (ot.getSyntax() != null && PIB_TAG_REFERENCE_ID.equals(ot.getSyntax().getSyntax()) && ot.getTag() != null) {
            refObject = this.rep.getObject(ot.getTag());
            v = new Vector<String>(2);
            v.add(ot.getName());
            v.add(ot.getTag());
            if (refObject == null) {
                this.throwLocalizedError((Token)ot.userObject, v, 1501, this.getTokenPIBTAG(), ot.getTag());
            } else if (!(refObject instanceof MIBObjectType) || ((MIBObjectType)refObject).getSyntax() == null || !PIB_TAG_ID.equals(((MIBObjectType)refObject).getSyntax().getSyntax())) {
                if (refObject instanceof MIBObjectType) {
                    this.throwLocalizedError(ot, new Vector<String>(Arrays.asList(ot.getPibReferences(), PIB_TAG_ID, ((MIBObjectType)refObject).getSyntax() != null ? ((MIBObjectType)refObject).getSyntax().getSyntax() : "''")), 1700, this.getTokenPIBTAG(), 0);
                } else {
                    this.throwLocalizedError(ot, new Vector<String>(Arrays.asList(ot.getPibReferences(), refObject.getTypeString())), 1602, this.getTokenPIBTAG(), 0);
                }
            }
        }
        if (ot.getSyntax() != null && PIB_REFERENCE_ID.equals(ot.getSyntax().getSyntax()) && ot.getPibReferences() != null) {
            refObject = this.rep.getObject(ot.getPibReferences());
            if (refObject == null) {
                refObject = this.smiRep.getKnownObject(ot.getPibReferences());
            }
            v = new Vector(2);
            v.add(ot.getName());
            v.add(ot.getPibReferences());
            if (refObject == null) {
                this.throwLocalizedError((Token)ot.userObject, v, 1501, this.getTokenPIBREFERENCES(), this.getTokenPIBREFERENCES());
            } else if (!(refObject instanceof MIBObjectType) || !((MIBObjectType)refObject).isTable()) {
                this.throwLocalizedError(ot, new Vector<String>(Arrays.asList(ot.getPibReferences(), "OBJECT-TYPE (Entry)", refObject.getTypeString())), 1700, this.getTokenPIBREFERENCES(), 0);
            }
        }
    }

    protected void checkCompliance(MIBCompliance mc) throws SMIParseException {
        if (mc.getModules() != null) {
            Iterator it = mc.getModules().iterator();
            while (it.hasNext()) {
                String srcModule;
                MIBObject ref;
                MIBModule m = this.rep.getModule(mc.getModuleID());
                MIBComplianceModule module = (MIBComplianceModule)it.next();
                if (module.getModuleName() != null && !module.getModuleName().equals(m.getModuleName())) {
                    m = this.smiRep.scope.rep.getModule(module.getModuleName());
                }
                MIBModule src = m;
                if (m == null) {
                    this.throwLocalizedError((Token)module.getUserObject(), new Vector<String>(Arrays.asList(module.getModuleName())), 1100, -1, 0);
                    continue;
                }
                if (module.hasMandatory()) {
                    for (String mandatory : module.getMandatoryVector()) {
                        ref = m.getObjectByName(mandatory);
                        if (ref == null) {
                            srcModule = this.currentModule.getImportSource(mandatory);
                            if (srcModule != null) {
                                src = this.smiRep.scope.rep.getModule(srcModule);
                                if (src != null) {
                                    ref = src.getObjectByName(mandatory);
                                }
                            } else {
                                this.throwLocalizedError((Token)mc.userObject, new Vector<String>(Arrays.asList(mandatory)), 1502, this.getTokenMANDATORYGROUPS(), mandatory);
                            }
                        }
                        if (ref instanceof MIBGroup) continue;
                        this.throwLocalizedError((Token)mc.userObject, new Vector<String>(Arrays.asList(mandatory, ref == null ? "unknown" : ref.getTypeString())), 1601, this.getTokenMANDATORYGROUPS(), mandatory);
                    }
                }
                src = m;
                if (!module.hasVariations()) continue;
                for (MIBVariation var : module.getVariationsVector()) {
                    if (var instanceof MIBCondGroup) {
                        ref = m.getObjectByName(var.getVariation());
                        if (ref == null) {
                            srcModule = this.currentModule.getImportSource(var.getVariation());
                            if (srcModule != null) {
                                src = this.smiRep.scope.rep.getModule(srcModule);
                                if (src != null) {
                                    ref = src.getObjectByName(var.getVariation());
                                }
                            } else {
                                this.throwLocalizedError((Token)var.getUserObject(), new Vector<String>(Arrays.asList(var.getVariation())), 1502, -1, 0);
                            }
                        }
                        if (!(ref instanceof MIBGroup)) {
                            this.throwLocalizedError((Token)var.getUserObject(), new Vector<String>(Arrays.asList(var.getVariation(), ref == null ? "unknown" : ref.getTypeString())), 1601, -1, 0);
                        }
                        if (!module.hasMandatory() || !module.getMandatoryVector().contains(var.getVariation())) continue;
                        this.throwLocalizedError((Token)var.getUserObject(), new Vector<String>(Arrays.asList(var.getVariation(), ref == null ? "unknown" : ref.getTypeString())), 1210, -1, 0);
                        continue;
                    }
                    ref = m.getObjectByName(var.getVariation());
                    if (ref == null) {
                        srcModule = this.currentModule.getImportSource(var.getVariation());
                        if (srcModule != null) {
                            src = this.smiRep.scope.rep.getModule(srcModule);
                            if (src != null) {
                                ref = src.getObjectByName(var.getVariation());
                            }
                        } else {
                            this.throwLocalizedError((Token)var.getUserObject(), new Vector<String>(Arrays.asList(var.getVariation())), 1502, -1, 0);
                        }
                    }
                    String moduleName = module.getModuleName();
                    MIBRepository r = this.rep;
                    if (src != this.currentModule) {
                        r = this.smiRep.scope.rep;
                    }
                    if (!r.isReferencedBy(var.getVariation(), src, module)) {
                        this.throwLocalizedError((Token)var.getUserObject(), new Vector<String>(Arrays.asList(var.getVariation())), 1211, -1, 0);
                    } else {
                        this.checkVariation(moduleName, var, (Token)var.getUserObject());
                    }
                    src = m;
                }
            }
        }
    }

    protected final int getTokenOBJECT() {
        return 88;
    }

    protected final int getTokenMANDATORYGROUPS() {
        return 85;
    }

    protected final int getTokenGROUP() {
        return 87;
    }

    protected final int getTokenPIBTAG() {
        return 110;
    }

    protected final int getTokenPIBINDEX() {
        return 105;
    }

    protected final int getTokenPIBREFERENCES() {
        return 109;
    }

    protected final int getTokenUNIQENESS() {
        return 112;
    }

    protected final int getTokenINSTALLERRORS() {
        return 108;
    }

    protected final int getTokenRANGE() {
        return 77;
    }

    protected void checkAccess() throws SMIParseException {
        if ((this.options & 8) > 0) {
            return;
        }
        Enumeration<? extends MIBObject> en = this.rep.objects();
        while (en.hasMoreElements()) {
            MIBNotifyType nt;
            MIBObject o = en.nextElement();
            if (o instanceof MIBObjectType) {
                MIBObjectType ot = (MIBObjectType)o;
                if (!ot.isTable() || o instanceof com.agentpp.mib.pib.PIBObjectType) continue;
                Vector<? extends MIBObjectType> v = this.rep.getColumnarObjectsOfTable(ot, false, true);
                boolean noReadWrite = false;
                String isReadWrite = null;
                for (int i = 0; i < v.size(); ++i) {
                    MIBObjectType c = v.get(i);
                    if (c.getAccess() == null && c instanceof com.agentpp.mib.pib.PIBObjectType) continue;
                    if (c.getAccess().equals(SMI.ACCESS[3])) {
                        noReadWrite = true;
                    } else if (c.getAccess().equals(SMI.ACCESS[2])) {
                        isReadWrite = c.getName();
                    }
                    if (!noReadWrite || isReadWrite == null) continue;
                    if (c.userObject != null && c.userObject instanceof Token) {
                        this.throwLocalizedError(ot, new Vector(), 1202, this.currentSMIVersion == 1 ? 59 : 58, 1);
                        continue;
                    }
                    this.error(new SMIParseException(isReadWrite, 1202));
                }
                continue;
            }
            if (!(o instanceof MIBNotifyType) || !(nt = (MIBNotifyType)o).hasVariables()) continue;
            Vector objectNames = nt.getVariablesVector();
            for (String objectName : objectNames) {
                MIBObject mo = this.rep.getObject(objectName);
                if (!(mo instanceof MIBObjectType) || !SMI.isNotAccessible(((MIBObjectType)mo).getAccess())) continue;
                Token t = (Token)o.userObject;
                StringToken objToken = this.objectLists.get(nt.getName() + " " + objectName);
                if (objToken != null) {
                    t = objToken.token;
                }
                SemanticError err = new SemanticError(5101, t.beginLine, t.beginColumn, t.endPos, t, t.image, nt.getName(), new String[]{objectName});
                this.error(new SMIParseException(err, 5101));
            }
        }
    }

    protected void checkSequence(MIBObjectType ot) throws SMIParseException {
        if (ot.isTable() && ot.getOid() != null && ot.getOid().isValid()) {
            Vector sequence = ot.getTableEntriesVector();
            Vector<? extends MIBObjectType> v = this.rep.getColumnarObjectsOfTable(ot, true, true);
            if (v == null) {
                v = this.smiRep.scope.rep.getColumnarObjectsOfTable(this.currentModule, ot, true, false);
                if (v == null) {
                    Token t = (Token)ot.userObject;
                    Vector<String> val = new Vector<String>(sequence.subList(0, 1));
                    val.insertElementAt(ot.getName(), 0);
                    this.error(new SMIParseException(new SemanticError(1800, t.beginLine, t.beginColumn, t.endPos, t, ot.getName(), t.image, new String[0]), 1800, val));
                    return;
                }
                v.addAll(this.rep.getColumnarObjectsOfTable(ot, false, true));
            }
            Collections.sort(v);
            for (int i = 0; i < v.size(); ++i) {
                v.set(i, (MIBObjectType)((Object)((MIBObject)v.get(i)).getName()));
            }
            int max = -1;
            for (int i = 0; i < sequence.size(); ++i) {
                int pos = v.indexOf(sequence.get(i));
                if (pos <= max) {
                    Token t;
                    Vector<String> val = new Vector<String>(2);
                    val.add(ot.getName());
                    val.add((String)sequence.get(i));
                    Vector tokens = (Vector)this.nameSequences.get(sequence);
                    if (tokens != null) {
                        t = ((StringToken)((Pair)tokens.get((int)i)).first).token;
                        this.throwLocalizedError(t, val, 1800, null);
                        continue;
                    }
                    t = (Token)ot.userObject;
                    this.error(new SMIParseException(new SemanticError(1800, t.beginLine, t.beginColumn, t.endPos, t, ot.getName(), t.image, new String[0]), 1800, val));
                    continue;
                }
                max = pos;
            }
        }
    }

    protected void checkNoDescendant(MIBObject o) throws SMIParseException {
        ObjectID id = o.getOid();
        if (id == null) {
            return;
        }
        if (o.getType() == 0 || o.getType() == 10 || o.getType() == 5) {
            return;
        }
        if (o instanceof MIBObjectType) {
            String[] exp;
            Token t;
            Vector<? extends MIBObject> v = this.rep.getDescendants(o);
            MIBObjectType ot = (MIBObjectType)o;
            MIBObjectType table = this.rep.getTableEntry(ot);
            if (table != null) {
                if (this.currentSMIVersion != 1 && table != ot) {
                    try {
                        MIBObjectType illegalObj;
                        if (!(ot.getOid().equals(table.getOid().trim()) && table.getOid().getLastSubID() == 1L || SMI.STATUS[3].equals((illegalObj = table).getStatus()))) {
                            Token token = (Token)illegalObj.userObject;
                            String[] exp2 = new String[]{o.getName(), illegalObj.getPrintableOid()};
                            this.error(new SMIParseException(new SemanticError(2010, token.beginLine, token.beginColumn, token.endPos, token, illegalObj.getName(), token.image, exp2), 2010));
                        }
                    }
                    catch (ObjectIDFormatException illegalObj) {
                        // empty catch block
                    }
                }
                this.checkSequence(table);
                if (table != ot) {
                    for (int i = 0; i < v.size(); ++i) {
                        MIBObject mIBObject = v.get(i);
                        if (table.equals(mIBObject) || mIBObject.getOid().size() == table.getOid().size() + 1 && mIBObject.getOid().trim().equals(table.getOid()) || SMI.STATUS[3].equals(mIBObject.getStatus())) continue;
                        t = (Token)mIBObject.userObject;
                        exp = new String[]{o.getName(), mIBObject.getPrintableOid()};
                        this.error(new SMIParseException(new SemanticError(2010, t.beginLine, t.beginColumn, t.endPos, t, mIBObject.getName(), t.image, exp), 2010));
                    }
                }
            }
            for (MIBObject mIBObject : v) {
                if (mIBObject instanceof MIBObjectType || SMI.ENTRY_TYPES[10].equals(mIBObject.getTypeString()) || SMI.STATUS[3].equals(mIBObject.getStatus())) continue;
                t = (Token)mIBObject.userObject;
                exp = new String[]{o.getName(), mIBObject.getPrintableOid()};
                this.error(new SMIParseException(new SemanticError(2010, t.beginLine, t.beginColumn, t.endPos, t, mIBObject.getName(), t.image, exp), 2010));
            }
            return;
        }
        MIBObject next = this.rep.getNextObject(id);
        if (next == null || next.getOid() == null) {
            return;
        }
        if (id.isRootOf(next.getOid()) && !SMI.STATUS[3].equals(next.getStatus())) {
            Vector<String> v = new Vector<String>();
            v.addElement(next.getName());
            v.addElement(o.getName());
            v.addElement(next.getPrintableOid());
            if (next.userObject != null && next.userObject instanceof Token) {
                Token t = (Token)next.userObject;
                String[] exp = new String[]{o.getName(), next.getPrintableOid()};
                this.error(new SMIParseException(new SemanticError(2010, t.beginLine, t.beginColumn, t.endPos, t, next.getName(), t.image, exp), 2010));
            } else {
                this.error(new SMIParseException("Illegal object registration", 2010, v));
            }
        }
    }

    protected void checkGroups(MIBObject o) throws SMIParseException {
        block15: {
            block12: {
                Vector v;
                MIBObjectType ot;
                block13: {
                    block14: {
                        this.checkNoDescendant(o);
                        if (!(o instanceof MIBObjectType)) break block12;
                        ot = (MIBObjectType)o;
                        if (ot.isTable() && ot.getOid() != null && ot.getOid().isValid() && (this.options & 2) == 0 && this.rep.getChildren(ot).size() != ot.getTableEntriesVector().size()) {
                            Token t = (Token)ot.userObject;
                            this.error(new SMIParseException(new SemanticError(1801, t.beginLine, t.beginColumn, t.endPos, t, ot.getName(), t.image, new String[0]), 1801));
                        }
                        if (ot.isTable() || ot.isTableSequence() || o instanceof com.agentpp.mib.pib.PIBObjectType || SMI.accessType(ot.getAccess()) == 0) break block13;
                        v = this.isPartOfGroup(ot.getName(), 6);
                        if (v.size() != 0 || (this.options & 1) != 0) break block14;
                        if (ot.userObject != null && ot.userObject instanceof Token) {
                            Token t = (Token)ot.userObject;
                            this.error(new SMIParseException(new SemanticError(5000, t.beginLine, t.beginColumn, t.endPos, t, ot.getName(), t.image, new String[0]), 5000));
                        } else {
                            this.error(new SMIParseException(ot.getName(), 5000));
                        }
                        break block15;
                    }
                    if ((this.options & 4) != 0) break block15;
                    Enumeration on = v.elements();
                    while (on.hasMoreElements()) {
                        this.checkStatus(ot, (MIBGroup)on.nextElement());
                    }
                    break block15;
                }
                if (o instanceof com.agentpp.mib.pib.PIBObjectType || (v = this.isPartOfGroup(ot.getName(), 6)).size() <= 0) break block15;
                MIBGroup g = (MIBGroup)v.firstElement();
                Token t = (Token)g.userObject;
                StringToken objToken = this.objectLists.get(g.getName() + " " + ot.getName());
                if (objToken != null) {
                    t = objToken.token;
                }
                v = new Vector(3);
                v.add(g.getName());
                v.add(ot.getName());
                this.error(new SMIParseException(new SemanticError(5100, t.beginLine, t.beginColumn, t.endPos, t, g.getName(), t.image, new String[0]), 5100, v));
                break block15;
            }
            if (o instanceof MIBNotifyType) {
                MIBNotifyType nt = (MIBNotifyType)o;
                Vector v = this.isPartOfGroup(nt.getName(), 7);
                if (v.size() == 0 && (this.options & 1) == 0) {
                    if (nt.userObject != null && nt.userObject instanceof Token) {
                        Token t = (Token)nt.userObject;
                        this.error(new SMIParseException(new SemanticError(5000, t.beginLine, t.beginColumn, t.endPos, t, nt.getName(), t.image, new String[0]), 5000));
                    } else {
                        this.error(new SMIParseException(nt.getName(), 5000));
                    }
                } else if ((this.options & 4) == 0) {
                    Enumeration on = v.elements();
                    while (on.hasMoreElements()) {
                        this.checkStatus(nt, (MIBGroup)on.nextElement());
                    }
                }
            }
        }
    }

    protected void checkStatus(MIBObject o, MIBGroup g) throws SMIParseException {
        if (SMI.statusType(o.getStatus()) < SMI.statusType(g.getStatus())) {
            if (o.userObject != null && o.userObject instanceof Token) {
                this.throwLocalizedError(o, new Vector<String>(Arrays.asList(o.getName(), g.getName())), 1201, 62, 1);
            } else {
                this.error(new SMIParseException(o.getName() + ":" + g.getName(), 1201));
            }
        }
    }

    private Vector isPartOfGroup(String name, int type) {
        Vector<MIBGroup> v = new Vector<MIBGroup>();
        Enumeration en = this.groups.elements();
        while (en.hasMoreElements()) {
            MIBGroup g = (MIBGroup)en.nextElement();
            if (g.getType() != type || !g.contains(name)) continue;
            v.addElement(g);
        }
        return v;
    }

    protected void checkUnresolvedNames() throws SMIParseException {
        HashSet<StringToken> undefined = new HashSet<StringToken>();
        Iterator en = this.smiRep.getUnresolvedNames();
        while (en.hasNext()) {
            List references = (List)en.next();
            for (Pair p : references) {
                StringToken[] st = (StringToken[])p.first;
                StringToken uname = null;
                block2: for (int i = 0; uname == null && i < st.length; ++i) {
                    String s = st[i].string;
                    for (int j = 0; j < s.length(); ++j) {
                        if (Character.isDigit(s.charAt(j))) continue;
                        uname = st[i];
                        continue block2;
                    }
                }
                if (uname == null || uname.string.length() <= 0 || undefined.contains(uname)) continue;
                if (uname.token == null && p.second instanceof StringToken) {
                    uname.token = ((StringToken)p.second).token;
                }
                undefined.add(uname);
                Token t = uname.token;
                if (t != null) {
                    this.throwLocalizedError(t, 1502);
                    continue;
                }
                this.error(new SMIParseException(uname.string, 1501));
            }
        }
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public void setErrors(List errors) {
        this.errors = errors;
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    public int getOptions() {
        return this.options;
    }

    public List getErrors() {
        return this.errors;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    protected Hashtable buildImportHash(MIBModule m) {
        Vector<MIBImport> v = m.getImportsVector();
        if (v == null) {
            return new Hashtable(1);
        }
        Hashtable<String, String> h = new Hashtable<String, String>(v.size() * 5 + 1);
        Enumeration<MIBImport> en = v.elements();
        while (en.hasMoreElements()) {
            MIBImport imp = en.nextElement();
            Vector<String> iv = imp.getImportsVector();
            if (iv == null) continue;
            for (int i = 0; i < iv.size(); ++i) {
                h.put(iv.elementAt(i).toString(), imp.getSource());
            }
        }
        return h;
    }

    public void checkImports(MIBModule m, MIBObject o, Hashtable imports) throws SMIParseException {
        MIBObject ot;
        String expectedSource;
        if (!o.getModuleID().equals(m.getModuleID())) {
            return;
        }
        int v = m.getSMIVersion();
        String ots = o.getTypeString();
        if (SMI.ENTRY_TYPES[5].equals(ots) && (o.getObjectID() == null || o.getObjectID().size() == 0) || SMI.ENTRY_TYPES[4].equals(ots) && (!((MIBTextualConvention)o).hasStatus() || SMI.statusType(((MIBTextualConvention)o).getStatus()) == 0)) {
            return;
        }
        int keywordType = SMI.getKeyWordType(v, ots);
        String source = (String)imports.get(ots);
        if (keywordType >= 0) {
            String string = expectedSource = v > 0 ? SMI.smiMIBs[v - 1][keywordType] : SMI.pibMIBs[v + 1][keywordType];
            if (!expectedSource.equals(m.getModuleName())) {
                this.checkImport(source, ots, o, true);
                this.checkImport(source, expectedSource, ots, o, true);
            }
        }
        String s = null;
        if (o instanceof MIBObjectType) {
            ot = (MIBObjectType)o;
            if (((MIBObjectType)ot).getSyntax() == null) {
                return;
            }
            s = ((MIBObjectType)ot).getSyntax().getSyntax();
        } else if (o instanceof MIBTextualConvention) {
            ot = (MIBTextualConvention)o;
            if (((MIBTextualConvention)ot).getSyntax() == null) {
                return;
            }
            s = ((MIBTextualConvention)ot).getSyntax().getSyntax();
        } else {
            return;
        }
        int t = SMI.getKeyWordType(v, s);
        if (t >= 0) {
            source = (String)imports.get(s);
            String string = expectedSource = v > 0 ? SMI.smiMIBs[v - 1][t] : SMI.pibMIBs[v + 1][t];
            if (!expectedSource.equals(m.getModuleName())) {
                this.checkImport(source, s, o, false);
                this.checkImport(source, expectedSource, s, o, false);
            }
        }
    }

    protected void checkImport(String source, String o, MIBObject mo, boolean checkForSmiObject) throws SMIParseException {
        if (source == null) {
            Vector<String> v = new Vector<String>(1);
            v.add(o);
            StringToken token = this.smiRep.getUnresolvedSyntax(o);
            if (token == null && mo != null && mo.userObject instanceof Token) {
                this.throwLocalizedError(mo, v, 1111, checkForSmiObject ? ((Token)mo.userObject).kind : this.getTokenSYNTAX(), checkForSmiObject && mo instanceof MIBTextualConvention ? 2 : 1, 0);
            } else if (token != null) {
                this.throwLocalizedError(token.token, 1111);
            } else if (mo != null) {
                this.error(new SMIParseException(mo.getName(), 1111, v));
            }
        }
    }

    protected void checkImport(String source, String expectedSource, String o, MIBObject ot, boolean checkForSmiObject) throws SMIParseException {
        if (!expectedSource.equals(source) && source != null) {
            Vector<String> v = new Vector<String>(3);
            v.add(o);
            v.add(source);
            v.add(expectedSource);
            this.throwLocalizedError(ot, v, 1110, checkForSmiObject ? ((Token)ot.userObject).kind : this.getTokenSYNTAX(), checkForSmiObject && ot instanceof MIBTextualConvention ? 2 : 1, 0);
        }
    }

    @Override
    public void error(SMIParseException parseException) throws SMIParseException {
        boolean added = SMIParseException.addUniqueException(this.errors, parseException);
        if (added && this.errors.size() >= this.maxErrors) {
            SMIParseException pex = (SMIParseException)this.errors.get(0);
            pex.setErrorList(this.errors);
            throw pex;
        }
    }
}

