/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import java.util.Arrays;
import java.util.StringTokenizer;

public class SMI {
    public static final String LINE_SEPARATOR = "\n";
    public static final String ALL_LINE_SEPARATORS = "\r\n";
    public static final int SUPPORTED_OBJECT_TYPES = 6;
    public static final int STANDARD = 1;
    public static final int HTML = 2;
    public static final int HTML_LINKED = 4;
    public static final int TO_SMI_V2 = 8;
    public static final int TO_SMI_V1 = 16;
    public static final int WITH_COMMENTS = 32;
    public static final int OMIT_OBJECTS = 64;
    public static final int PRESERVED_ORDER = 128;
    public static final int GROUPING_BY_TYPE = 256;
    public static final int NAVIGATION_LINKS = 512;
    public static final int INLINE_COMMENTS = 1024;
    public static final int ACC_NOACCESS = 0;
    public static final int ACC_READONLY = 1;
    public static final int ACC_READWRITE = 2;
    public static final int ACC_READCREATE = 3;
    public static final int ACC_WRITEONLY = 4;
    public static final int ACC_ACCESSIBLE_FOR_NOTIFY = 5;
    public static final int ACC_NOT_IMPLEMENTED = 6;
    public static final String[] ACCESS = new String[]{"not-accessible", "read-only", "read-write", "read-create", "write-only", "accessible-for-notify", "not-implemented"};
    public static final String[] PIB_ACCESS = new String[]{"install", "notify", "install-notify", "report-only"};
    public static final int[] SMIv1_ACCESS = new int[]{0, 1, 2, 4};
    public static final int STA_UNDEFINED = 0;
    public static final int STA_MANDATORY = 1;
    public static final int STA_OPTIONAL = 2;
    public static final int STA_OBSOLETE = 3;
    public static final int STA_DEPRECATED = 4;
    public static final int STA_CURRENT = 5;
    public static final int SYN_SIMPLE = 0;
    public static final int SYN_APPLICATION = 1;
    public static final int SYN_SEQUENCE = 2;
    public static final int SYN_CONVENTION = 3;
    public static final int OBJECT_IDENTITY = 0;
    public static final int OBJECT_TYPE = 1;
    public static final int TRAP_TYPE = 2;
    public static final int NOTIFICATION_TYPE = 3;
    public static final int TEXTUAL_CONVENTION = 4;
    public static final int MODULE_IDENTITY = 5;
    public static final int OBJECT_GROUP = 6;
    public static final int NOTIFICATION_GROUP = 7;
    public static final int MODULE_COMPLIANCE = 8;
    public static final int AGENT_CAPABILITIES = 9;
    public static final int OBJECT_NAME = 10;
    public static final int SEQUENCE = 11;
    public static final String[] smiv2MIBs = new String[]{"SNMPv2-SMI", "SNMPv2-TC", "SNMPv2-CONF"};
    public static final String[] smiv1MIBs = new String[]{"RFC1155-SMI", "RFC-1212", "RFC-1215"};
    public static final String[][] pibMIBs = new String[][]{{"COPS-PR-SPPI", "COPS-PR-SPPI-TC"}};
    public static final String[][] smiMIBs = new String[][]{smiv1MIBs, smiv2MIBs};
    public static final String[][] smiv2Constructs = new String[][]{{"MODULE-IDENTITY", "OBJECT-IDENTITY", "OBJECT-TYPE", "NOTIFICATION-TYPE", "Counter32", "Counter64", "Gauge32", "Integer32", "IpAddress", "Opaque", "TimeTicks", "Unsigned32"}, {"TEXTUAL-CONVENTION"}, {"OBJECT-GROUP", "NOTIFICATION-GROUP", "MODULE-COMPLIANCE", "AGENT-CAPABILITIES"}};
    public static final String[][][] pibConstructs = new String[][][]{{{"MODULE-IDENTITY", "OBJECT-IDENTITY", "OBJECT-TYPE", "NOTIFICATION-TYPE", "Integer32", "IpAddress", "Opaque", "TimeTicks", "Unsigned32", "Integer64", "Unsigned64", "TEXTUAL-CONVENTION", "OBJECT-GROUP", "MODULE-COMPLIANCE"}, {"InstanceId", "ReferenceId", "Prid", "TagId", "TagReferenceId"}}};
    public static final String[][] smiv1Constructs = new String[][]{{"OBJECT-IDENTITY", "Counter", "Gauge", "IpAddress", "Opaque", "TimeTicks", "NetworkAddress"}, {"OBJECT-TYPE"}, {"TRAP-TYPE"}};
    public static final String[][][] smiConstructs = new String[][][]{smiv1Constructs, smiv2Constructs};
    public static final String[] asn1Constructs = new String[]{"INTEGER", "OCTET STRING", "BITS"};
    public static final String[] STATUS = new String[]{"undefined", "mandatory", "optional", "obsolete", "deprecated", "current"};
    public static final String[][] rootOids = new String[][]{{"iso", "1"}, {"ccitt", "0"}, {"joint-iso-ccitt", "2"}, {"org", "1.3"}, {"dod", "1.3.6"}, {"internet", "1.3.6.1"}, {"mgmt", "1.3.6.1.2"}, {"mib-2", "1.3.6.1.2.1"}, {"mib", "1.3.6.1.2.1"}, {"experimental", "1.3.6.1.3"}, {"private", "1.3.6.1.4"}, {"enterprises", "1.3.6.1.4.1"}};
    public static final String[] ENTRY_TYPES = new String[]{"OBJECT-IDENTITY", "OBJECT-TYPE", "TRAP-TYPE", "NOTIFICATION-TYPE", "TEXTUAL-CONVENTION", "MODULE-IDENTITY", "OBJECT-GROUP", "NOTIFICATION-GROUP", "MODULE-COMPLIANCE", "AGENT-CAPABILITIES", "OBJECT IDENTIFIER"};
    public static final String[] SYNTAX_TYPES = new String[]{"simple", "application", "sequence", "textual convention"};
    public static final String[] BASIC_SYNTAX = new String[]{"Integer", "String", "Hex String", "Object ID", "Null", "IpAddress", "Counter", "Counter64", "Gauge", "TimeTicks", "Opaque"};
    public static final int SYN_NUMBER = 0;
    public static final int SYN_STRING = 1;
    public static final int SYN_HEXSTRING = 2;
    public static final int SYN_OBJECT = 3;
    public static final int SYN_EMPTY = 4;
    public static final int SYN_IPADDRESS = 5;
    public static final int SYN_COUNTER = 6;
    public static final int SYN_COUNTER64 = 7;
    public static final int SYN_GAUGE = 8;
    public static final int SYN_TIMETICKS = 9;
    public static final int SYN_OPAQUE = 10;
    public static final int SYN_NULL = 11;
    public static final int SYN_NETADDRESS = 12;
    public static final String[] SMI_SYNTAX = new String[]{"INTEGER", "OCTET STRING", "OBJECT IDENTIFIER", "Counter", "Gauge", "Counter32", "Counter64", "Gauge32", "Integer32", "IpAddress", "Opaque", "TimeTicks", "BITS", "Unsigned32", "NULL", "NetworkAddress"};
    public static final int SMI_INTEGER = 0;
    public static final int SMI_OCTETSTRING = 1;
    public static final int SMI_OID = 2;
    public static final int SMI_COUNTER = 3;
    public static final int SMI_GAUGE = 4;
    public static final int SMI_COUNTER32 = 5;
    public static final int SMI_COUNTER64 = 6;
    public static final int SMI_GAUGE32 = 7;
    public static final int SMI_INTEGER32 = 8;
    public static final int SMI_IPADDRESS = 9;
    public static final int SMI_OPAQUE = 10;
    public static final int SMI_TIMETICKS = 11;
    public static final int SMI_BITS = 12;
    public static final int SMI_UNSIGNED32 = 13;
    public static final int SMI_NULL = 14;
    public static final int SMI_NETWORKADDRESS = 15;
    public static final int[] SMIv1_SYNTAX = new int[]{0, 1, 2, 3, 4, 9, 10, 11, 14, 15};
    public static final int[] SMI_SYNTAX_MAPPING = new int[]{0, 1, 3, 6, 8, 6, 7, 8, 0, 5, 10, 9, 1, 8, 3, 5};
    private static final String[][] SMI_CONSTANTS = new String[][]{STATUS, ACCESS, SMI_SYNTAX};
    private static final String[] COMMON_SMI_IDENTIFIER = new String[SMI_CONSTANTS[0].length + SMI_CONSTANTS[1].length + SMI_CONSTANTS[2].length];

    public static int smiv2MIB(String mib) {
        for (int i = 0; i < smiv2MIBs.length; ++i) {
            if (!smiv2MIBs[i].equals(mib)) continue;
            return i;
        }
        return -1;
    }

    public static int smiv1MIB(String mib) {
        for (int i = 0; i < smiv1MIBs.length; ++i) {
            if (!smiv1MIBs[i].equals(mib)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isMacroDefMIB(String moduleName) {
        return SMI.smiv2MIB(moduleName) >= 0 || SMI.smiv1MIB(moduleName) >= 0;
    }

    public static int entryType(String entryType) {
        if (entryType == null) {
            return -1;
        }
        for (int i = 0; i < ENTRY_TYPES.length; ++i) {
            if (!entryType.equals(ENTRY_TYPES[i])) continue;
            return i;
        }
        return -1;
    }

    public static int accessType(String access) {
        if (access == null) {
            return -1;
        }
        for (int i = 0; i < ACCESS.length; ++i) {
            if (!access.equals(ACCESS[i])) continue;
            return i;
        }
        return -1;
    }

    public static final String getCommonIdentifier(String s) {
        if (s == null) {
            return null;
        }
        int pos = Arrays.binarySearch(COMMON_SMI_IDENTIFIER, s);
        if (pos >= 0) {
            return COMMON_SMI_IDENTIFIER[pos];
        }
        return s;
    }

    public static int getKeyWordType(int smiversion, String s) {
        String[][] keywords = smiversion == 1 ? smiv1Constructs : (smiversion < 0 ? pibConstructs[Math.abs(smiversion) - 1] : smiv2Constructs);
        for (int i = 0; i < keywords.length; ++i) {
            for (int j = 0; j < keywords[i].length; ++j) {
                if (!keywords[i][j].equals(s)) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean isASN1KeyWord(String s) {
        for (int i = 0; i < asn1Constructs.length; ++i) {
            if (!asn1Constructs[i].equals(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isKeyWord(String s) {
        return SMI.isASN1KeyWord(s) || SMI.getKeyWordType(2, s) >= 0 || SMI.getKeyWordType(1, s) >= 0 || SMI.getKeyWordType(-1, s) >= 0;
    }

    public static boolean isWritable(String access) {
        return SMI.accessType(access) >= 2;
    }

    public static boolean isAccessible(String access) {
        int a = SMI.accessType(access);
        return a > 0 && a < 4;
    }

    public static boolean isNotAccessible(String access) {
        return 0 == SMI.accessType(access);
    }

    public static int statusType(String status) {
        if (status == null) {
            return 0;
        }
        for (int i = 0; i < STATUS.length; ++i) {
            if (!status.equals(STATUS[i])) continue;
            return i;
        }
        return 0;
    }

    public static int basicSyntax(String syntax) {
        for (int i = 0; i < SMI_SYNTAX.length; ++i) {
            if (!syntax.equalsIgnoreCase(SMI_SYNTAX[i])) continue;
            return SMI_SYNTAX_MAPPING[i];
        }
        return -1;
    }

    public static int smiSyntax(String syntax) {
        if (syntax == null) {
            return -1;
        }
        for (int i = 0; i < SMI_SYNTAX.length; ++i) {
            if (!syntax.equalsIgnoreCase(SMI_SYNTAX[i])) continue;
            return i;
        }
        return -1;
    }

    public static boolean isNumeric(String syntax) {
        int s = SMI.basicSyntax(syntax);
        return s == 0 || s == 6 || s == 8 || s == 7 || s == 9;
    }

    public static boolean isOID(String syntax) {
        int s = SMI.basicSyntax(syntax);
        return s == 3;
    }

    public static boolean isCounter(String syntax) {
        int s = SMI.basicSyntax(syntax);
        return s == 6 || s == 7;
    }

    public static boolean isUnsignedNumeric(String syntax) {
        int s = SMI.basicSyntax(syntax);
        return s == 6 || s == 8 || s == 7 || s == 9;
    }

    public static boolean isSubTypable(String syntax) {
        int s = SMI.basicSyntax(syntax);
        return SMI.isString(syntax) || s == 0 || s == 8;
    }

    public static boolean isString(String syntax) {
        int s = SMI.basicSyntax(syntax);
        return s == 1 || s == 2 || s == 10;
    }

    public static long parseLongConstant(String value) throws NumberFormatException {
        if (value.endsWith("h") || value.endsWith("H")) {
            StringTokenizer st = new StringTokenizer(value, "'");
            if (!st.hasMoreTokens()) {
                throw new NumberFormatException("Hex string must be enclosed in '.");
            }
            return Long.parseLong(st.nextToken(), 16);
        }
        if (value.endsWith("o") || value.endsWith("O")) {
            StringTokenizer st = new StringTokenizer(value, "'");
            if (!st.hasMoreTokens()) {
                throw new NumberFormatException("Octal string must be enclosed in '.");
            }
            return Long.parseLong(st.nextToken(), 8);
        }
        if (value.endsWith("b") || value.endsWith("B")) {
            StringTokenizer st = new StringTokenizer(value, "'");
            if (!st.hasMoreTokens()) {
                throw new NumberFormatException("Binary string must be enclosed in '.");
            }
            return Long.parseLong(st.nextToken(), 2);
        }
        return Long.parseLong(value, 10);
    }

    public static byte[] stringConstantToByteArray(String value) throws NumberFormatException {
        int radix = 10;
        int step = 3;
        if (value.startsWith("\"") && value.endsWith("\"") && value.length() >= 2) {
            return value.substring(1, value.length() - 1).getBytes();
        }
        if (value.startsWith("'")) {
            if (value.endsWith("h") || value.endsWith("H")) {
                radix = 16;
                step = 2;
            } else if (value.endsWith("o") || value.endsWith("O")) {
                radix = 8;
                step = 4;
            } else if (value.endsWith("b") || value.endsWith("B")) {
                radix = 2;
                step = 8;
            }
            try {
                String s = value.substring(1, value.length() - 2);
                if (s.length() == 0) {
                    return new byte[0];
                }
                byte[] bytes = new byte[s.length() / step];
                for (int i = 0; i < s.length(); i += step) {
                    bytes[i / step] = (byte)Integer.parseInt(s.substring(i, i + step), radix);
                }
                return bytes;
            }
            catch (StringIndexOutOfBoundsException siobe) {
                return null;
            }
        }
        return null;
    }

    public static String parseStringConstant(String value) throws NumberFormatException {
        int radix = 10;
        int step = 3;
        if (value.startsWith("\"")) {
            StringTokenizer st = new StringTokenizer(value, "\"");
            if (!st.hasMoreTokens()) {
                return "";
            }
            return st.nextToken();
        }
        if (value.startsWith("'")) {
            StringTokenizer st;
            if (value.endsWith("h") || value.endsWith("H")) {
                radix = 16;
                step = 2;
            }
            if (value.endsWith("o") || value.endsWith("O")) {
                radix = 8;
                step = 4;
            }
            if (value.endsWith("b") || value.endsWith("B")) {
                radix = 2;
                step = 8;
            }
            if (!(st = new StringTokenizer(value, "'")).hasMoreTokens()) {
                throw new NumberFormatException("String must be enclosed in '.");
            }
            String s = st.nextToken();
            if (s.length() == 0) {
                return "";
            }
            try {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < s.length(); i += step) {
                    char c = (char)Integer.parseInt(s.substring(i, i + step), radix);
                    String hex = Integer.toHexString(c);
                    for (int n = 0; n < 2 - hex.length(); ++n) {
                        hex = "0" + hex;
                    }
                    buf.append("\\x" + hex);
                }
                return buf.toString();
            }
            catch (StringIndexOutOfBoundsException siobe) {
                return "";
            }
        }
        return value;
    }

    public static String convertStatusToSMIv2(String status) {
        if (status.equals(STATUS[1]) || status.equals(STATUS[2])) {
            return STATUS[5];
        }
        return status;
    }

    static {
        System.arraycopy(SMI_CONSTANTS[0], 0, COMMON_SMI_IDENTIFIER, 0, SMI_CONSTANTS[0].length);
        System.arraycopy(SMI_CONSTANTS[1], 0, COMMON_SMI_IDENTIFIER, SMI_CONSTANTS[0].length, SMI_CONSTANTS[1].length);
        System.arraycopy(SMI_CONSTANTS[2], 0, COMMON_SMI_IDENTIFIER, SMI_CONSTANTS[0].length + SMI_CONSTANTS[1].length, SMI_CONSTANTS[2].length);
        Arrays.sort(COMMON_SMI_IDENTIFIER);
    }
}

