/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.smi.IModuleInfo;
import com.objectspace.jgl.OrderedMap;
import java.io.File;
import java.util.Date;
import java.util.Enumeration;

public class ModuleInfo
implements IModuleInfo {
    public String moduleName;
    public File path = null;
    public OrderedMap imp = new OrderedMap();
    public Object userObject = null;
    private Date lastUpdated;

    public ModuleInfo(String moduleName) {
        this.moduleName = moduleName;
    }

    public ModuleInfo(String moduleName, String[] imports) {
        this.moduleName = moduleName;
        if (imports != null) {
            for (int i = 0; i < imports.length; ++i) {
                this.imp.put(imports[i], imports[i]);
            }
        }
    }

    public ModuleInfo(String moduleName, String[] imports, Date lastUpdated) {
        this(moduleName, imports);
        this.lastUpdated = lastUpdated;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    public void resetImports() {
        this.imp.clear();
    }

    @Override
    public String[] getImports() {
        String[] i = new String[this.imp.size()];
        int j = 0;
        Enumeration en = this.imp.elements();
        while (en.hasMoreElements()) {
            i[j] = (String)en.nextElement();
            ++j;
        }
        return i;
    }

    @Override
    public boolean hasImports() {
        return this.imp.size() > 0;
    }

    public boolean importsFrom(String sourceModule) {
        return this.imp.get(sourceModule) != null;
    }

    public Enumeration imports() {
        return this.imp.elements();
    }

    public void addImport(String source) {
        this.imp.put(source, source);
    }

    public String getImportList() {
        return ModuleInfo.getImportList(this.imports());
    }

    public void setLastUpdated(Date lastUpdate) {
        this.lastUpdated = lastUpdate;
    }

    static String getImportList(Enumeration i) {
        StringBuffer imports = new StringBuffer();
        boolean first = true;
        while (i.hasMoreElements()) {
            if (first) {
                first = false;
            } else {
                imports.append(", ");
            }
            imports.append((String)i.nextElement());
        }
        return imports.toString();
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public String toString() {
        return this.moduleName;
    }
}

