/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smi;

import com.agentpp.smi.IModule;
import com.agentpp.smi.IModuleInfo;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.ModuleInfoSorter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

public class IModuleInfoSorter {
    private ModuleInfoSorter sorter = null;

    public IModuleInfoSorter(IModuleInfo[] list) {
        ModuleInfo[] infos = new ModuleInfo[list.length];
        for (int i = 0; i < list.length; ++i) {
            infos[i] = new ModuleInfo(list[i].getModuleName(), list[i].getImports());
        }
        this.sorter = new ModuleInfoSorter(infos);
        this.sorter.resetPool();
    }

    public boolean sort() {
        return this.sorter.sort();
    }

    public IModuleInfo[] getSortedList() {
        return this.sorter.getSortedList();
    }

    public IModuleInfo[] getFailedList() {
        return this.sorter.getFailedList();
    }

    public String[] getMissingModules() {
        return this.sorter.getMissingModules();
    }

    public void setPool(IModuleInfo[] poolList) {
        this.sorter.setPool((ModuleInfo[])poolList);
    }

    public void resetPool() {
        this.sorter.resetPool();
    }

    public static <M extends IModule> Vector<M> sortModulesByImports(List<M> modules) {
        ModuleInfo[] moduleInfoArray;
        ModuleInfo[] sorted;
        Vector<IModule> result = new Vector<IModule>(modules.size() + 1);
        ModuleInfo[] list = new ModuleInfo[modules.size()];
        HashSet<String> h = new HashSet<String>();
        int n = 0;
        for (ModuleInfo[] m : modules) {
            ModuleInfo info = new ModuleInfo(m.getModuleName(), m.getImportSources());
            info.userObject = m;
            list[n++] = info;
            h.add(m.getModuleName());
        }
        ArrayList<ModuleInfo> pool = new ArrayList<ModuleInfo>();
        for (ModuleInfo moduleInfo : list) {
            String[] sources;
            for (String source : sources = moduleInfo.getImports()) {
                if (h.contains(source)) continue;
                pool.add(new ModuleInfo(source, new String[0]));
            }
        }
        ModuleInfoSorter sorter = new ModuleInfoSorter(list);
        ModuleInfo[] poolModules = new ModuleInfo[pool.size()];
        pool.toArray(poolModules);
        sorter.setPool(poolModules);
        sorter.sort();
        for (ModuleInfo info : sorted = sorter.getSortedList()) {
            result.add((IModule)info.userObject);
        }
        for (ModuleInfo moduleInfo : moduleInfoArray = sorter.getFailedList()) {
            result.add((IModule)moduleInfo.userObject);
        }
        return result;
    }
}

