/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.repository;

import com.agentpp.mib.LexicographicPredicate;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.repository.ProgressCallback;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.smi.IModule;
import com.agentpp.smi.IObject;
import com.agentpp.smi.event.ExtRepsitoryListener;
import com.agentpp.smi.event.ImportModuleEvent;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smi.event.RepositoryEvent;
import com.agentpp.smi.event.RepositoryListener;
import com.agentpp.smiparser.FileError;
import com.agentpp.smiparser.FindImportsVisitor;
import com.agentpp.smiparser.LenientSMI2Java;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.ParseException;
import com.agentpp.smiparser.SMI2Java;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParser;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.smiparser.SemanticError;
import com.agentpp.smiparser.TokenMgrError;
import com.objectspace.jgl.OrderedMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class DefaultRepositoryManager
implements RepositoryManager {
    public static final DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    protected static String resClassName = "com.agentpp.repository.DefaultRepositoryManagerRes";
    protected RepositoryManager rm = this;
    protected File path = null;
    protected static ResourceBundle res = null;
    public boolean verbose = false;
    protected int options = 4;
    private transient List<RepositoryListener> repositoryListeners;
    private boolean importTableDependencies = false;
    private int initialModuleID = 0;
    public static final int DEFAULT_MODE = 0;
    public static final int LENIENT_MODE = 1;
    public static final int LENIENT_MODE_MODULE_INFO = Integer.MAX_VALUE;
    protected int maxErrors = 20;
    private static final int COMPRESSION_FLAG = -1;
    private static final int COMPRESSION_MODE_GZIP = 1;
    private boolean useCompression;
    private int maxCacheEntries = 20;
    private static boolean forwardUnknownErrors;
    private final Map<String, RepositoryCacheEntry> repCache = Collections.synchronizedMap(new LinkedHashMap<String, RepositoryCacheEntry>(this.maxCacheEntries, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() >= DefaultRepositoryManager.this.maxCacheEntries;
        }
    });
    private boolean extendedParserInfoEnabled;

    public DefaultRepositoryManager() {
        try {
            this.initialModuleID = Integer.parseInt(System.getProperty("com.agentpp.smi.initialModuleID", "0"));
        }
        catch (NumberFormatException nfex) {
            nfex.printStackTrace();
        }
    }

    public static void setResourceClassName(String resourceClassName) {
        resClassName = resourceClassName;
    }

    public static String getResourceClassName() {
        return resClassName;
    }

    public void open(File directory) throws IOException {
        this.repCache.clear();
        this.path = directory;
        if (!this.path.exists() || !this.path.isDirectory()) {
            throw new IOException("Repository path is not a directory");
        }
    }

    public File getRepositoryDirectory() {
        return this.path;
    }

    public void close() throws IOException {
    }

    protected ModuleInfo[] updateRepository(SMIRepository rep, List parseErrors, boolean lenient, String path) throws SMIParseException {
        Iterator<MIBModule> it;
        SMI2Java visitor = lenient ? new LenientSMI2Java(rep, this.options) : new SMI2Java(rep, this.options);
        visitor.setErrors(parseErrors);
        visitor.setMaxErrors(this.maxErrors);
        Vector v = new Vector();
        try {
            rep.jjtAccept(visitor, v);
        }
        catch (Exception ex) {
            if (visitor.getErrors().size() > 0) {
                SMIParseException pex = (SMIParseException)visitor.getErrors().get(0);
                pex.setErrorList(visitor.getErrors());
                throw pex;
            }
            ex.printStackTrace();
            throw new SMIParseException(ex.getMessage(), 0);
        }
        if (!visitor.getErrors().isEmpty()) {
            SMIParseException pex = (SMIParseException)visitor.getErrors().get(0);
            pex.setErrorList(visitor.getErrors());
            throw pex;
        }
        MIBRepository r = visitor.getRepository();
        r.structureChanged();
        boolean storeFilename = Boolean.getBoolean("com.agentpp.smi.storeMIBFileName");
        if (lenient) {
            it = r.modulesIterator();
            while (it.hasNext()) {
                MIBModule m = it.next();
                m.setParseMode(Integer.MAX_VALUE);
                if (!storeFilename || path == null) continue;
                m.setFileName(new File(path).getName());
            }
        } else if (storeFilename && path != null) {
            it = r.modulesIterator();
            while (it.hasNext()) {
                MIBModule m = it.next();
                m.setFileName(new File(path).getName());
            }
        }
        try {
            this.saveModulesFromRepository(r);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new SMIParseException("Could not write to repository: " + ioe.getMessage(), 20);
        }
        ModuleInfo[] info = new ModuleInfo[v.size()];
        v.toArray(info);
        if (this.extendedParserInfoEnabled && !v.isEmpty()) {
            info[0].userObject = rep;
        }
        return info;
    }

    private SMI2Java createVisitor(SMIRepository rep, List parseErrors, boolean lenient) throws SMIParseException {
        SMI2Java visitor = lenient ? new LenientSMI2Java(rep, this.options) : new SMI2Java(rep, this.options);
        visitor.setErrors(parseErrors);
        visitor.setMaxErrors(this.maxErrors);
        return visitor;
    }

    protected MIBRepository createRepository(SMIRepository rep, List parseErrors, boolean lenient, boolean ignoreErrors) throws SMIParseException {
        SMI2Java visitor = this.createVisitor(rep, parseErrors, lenient);
        Vector v = new Vector();
        rep.jjtAccept(visitor, v);
        MIBRepository r = visitor.getRepository();
        r.freeUserObjects();
        r.structureChanged();
        if (!ignoreErrors && visitor.getErrors().size() > this.maxErrors) {
            SMIParseException pex = (SMIParseException)visitor.getErrors().get(0);
            pex.setErrorList(visitor.getErrors());
            throw pex;
        }
        if (lenient) {
            Iterator<MIBModule> it = r.modulesIterator();
            while (it.hasNext()) {
                MIBModule m = it.next();
                m.setParseMode(1);
            }
        }
        return r;
    }

    protected ModuleInfo[] getModuleInfo(SMIRepository rep) throws SMIParseException {
        FindImportsVisitor visitor = new FindImportsVisitor(rep);
        Vector v = new Vector();
        rep.jjtAccept(visitor, v);
        ModuleInfo[] info = new ModuleInfo[v.size()];
        v.toArray(info);
        if (this.extendedParserInfoEnabled && !v.isEmpty()) {
            info[0].userObject = rep;
        }
        return info;
    }

    @Override
    public synchronized void checkModules(InputStream file) throws SMIParseException {
        this.checkModules(file, false, false);
    }

    public synchronized ModuleInfo[] checkModules(InputStream file, boolean lenient, boolean ignoreErrorLimit) throws SMIParseException {
        SMI2Java visitor;
        SMIParser parser = new SMIParser(file);
        SMIRepository tree = null;
        if (lenient) {
            parser.setLenient(1);
        }
        if (!ignoreErrorLimit) {
            parser.setMaxErrors(this.maxErrors);
        }
        try {
            tree = parser.Input("");
            tree.setImporter(this);
            tree.createOids();
        }
        catch (ParseException ex) {
            if (this.verbose) {
                ex.printStackTrace();
            }
            try {
                file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            SMIParseException nex = new SMIParseException(ex.getMessage(), ex.getShortMessage(), ex.errorType, ex);
            nex.setErrorList(parser.getErrors());
            if (this.extendedParserInfoEnabled) {
                nex.setSmiRepository(tree);
            }
            throw nex;
        }
        catch (Throwable t) {
            if (this.verbose) {
                t.printStackTrace();
            }
            try {
                file.close();
            }
            catch (IOException nex) {
                // empty catch block
            }
            if (t instanceof TokenMgrError) {
                if (this.verbose) {
                    System.out.println("failed.");
                }
                TokenMgrError err = (TokenMgrError)t;
                throw new SMIParseException(err.getMessage(), null, 50, err);
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            throw new SMIParseException(t.getMessage(), 1000);
        }
        if (this.maxErrors > 0 && parser.getErrors().size() >= this.maxErrors) {
            if (this.verbose) {
                System.out.println("failed.");
            }
            SMIParseException pex = (SMIParseException)parser.getErrors().get(0);
            if (this.extendedParserInfoEnabled) {
                pex.setSmiRepository(tree);
            }
            pex.setErrorList(parser.getErrors());
            throw pex;
        }
        if (this.verbose) {
            System.out.print("parsed");
        }
        try {
            visitor = lenient ? new LenientSMI2Java(tree, this.options) : new SMI2Java(tree, this.options);
            visitor.setErrors(parser.getErrors());
            if (!ignoreErrorLimit) {
                visitor.setMaxErrors(this.maxErrors);
            }
            Vector v = new Vector();
            tree.jjtAccept(visitor, v);
        }
        catch (SMIParseException pex) {
            pex.setSmiRepository(tree);
            throw pex;
        }
        if (visitor.getErrors().size() > 0) {
            pex = (SMIParseException)visitor.getErrors().get(0);
            pex.setErrorList(parser.getErrors());
            pex.setSmiRepository(tree);
            throw pex;
        }
        return this.getModuleInfo(tree);
    }

    @Override
    public ModuleInfo[] getModuleInfo(File file) throws SMIParseException {
        FileInputStream fi = null;
        try {
            fi = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new SMIParseException(file.getPath(), 10);
        }
        if (this.verbose) {
            System.out.print("Loading IMPORTS from file [" + file.getPath() + "]...");
        }
        return this.getModuleInfo(fi, file.getPath());
    }

    @Override
    public ModuleInfo[] getModuleInfo(ZipFile file) throws SMIParseException {
        try {
            Vector<ModuleInfo> infos = new Vector<ModuleInfo>();
            Enumeration<? extends ZipEntry> en = file.entries();
            while (en.hasMoreElements()) {
                Object[] zipRef;
                ModuleInfo[] info;
                ZipEntry entry = en.nextElement();
                InputStream is = file.getInputStream(entry);
                if (this.verbose) {
                    System.out.print("Loading IMPORTS from file [" + entry.getName() + "]...");
                }
                try {
                    info = this.getModuleInfo(is, entry.getName());
                }
                catch (SMIParseException pex) {
                    info = new ModuleInfo[]{new ModuleInfo("invalid ")};
                    info[0].path = new File(entry.getName());
                    zipRef = new Object[]{file, entry};
                    info[0].userObject = zipRef;
                }
                for (int i = 0; i < info.length; ++i) {
                    zipRef = new Object[]{file, entry};
                    info[i].userObject = zipRef;
                }
                infos.addAll(Arrays.asList(info));
            }
            ModuleInfo[] i = new ModuleInfo[infos.size()];
            infos.toArray(i);
            return i;
        }
        catch (IOException iox) {
            throw new SMIParseException(iox.getMessage(), 20);
        }
    }

    public ModuleInfo[] getModuleInfo(ZipInputStream file) throws SMIParseException {
        try {
            ZipEntry entry;
            ArrayList<ModuleInfo> infos = new ArrayList<ModuleInfo>();
            while ((entry = file.getNextEntry()) != null) {
                Object[] zipRef;
                ModuleInfo[] info;
                ZipInputStream is = file;
                if (this.verbose) {
                    System.out.print("Loading IMPORTS from file [" + entry.getName() + "]...");
                }
                try {
                    info = this.getModuleInfo(is, entry.getName());
                }
                catch (SMIParseException pex) {
                    info = new ModuleInfo[]{new ModuleInfo("invalid ")};
                    info[0].path = new File(entry.getName());
                    zipRef = new Object[]{file, entry};
                    info[0].userObject = zipRef;
                }
                for (int i = 0; i < info.length; ++i) {
                    zipRef = new Object[]{file, entry};
                    info[i].userObject = zipRef;
                }
                infos.addAll(Arrays.asList(info));
            }
            ModuleInfo[] i = new ModuleInfo[infos.size()];
            infos.toArray(i);
            return i;
        }
        catch (IOException iox) {
            throw new SMIParseException(iox.getMessage(), 20);
        }
    }

    public ModuleInfo[] getModuleInfo(InputStream fi, String path) throws SMIParseException {
        ModuleInfo[] info = null;
        SMIParser parser = new SMIParser(fi);
        parser.setLenient(Integer.MAX_VALUE);
        SMIRepository tree = null;
        try {
            tree = parser.Input(path);
            tree.setImporter(this);
            tree.createOids();
        }
        catch (ParseException ex) {
            if (this.verbose) {
                ex.printStackTrace();
            }
            try {
                fi.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            throw new SMIParseException(ex.getMessage(), ex.errorType);
        }
        catch (Throwable t) {
            try {
                fi.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (t instanceof TokenMgrError) {
                if (this.verbose) {
                    System.out.println("failed.");
                }
                throw new SMIParseException(t.getMessage(), t.getMessage(), 50, (TokenMgrError)t);
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            throw new SMIParseException(t.getMessage(), 1000);
        }
        if (this.verbose) {
            System.out.print("parsed");
        }
        try {
            info = this.getModuleInfo(tree);
        }
        catch (SMIParseException pex) {
            if (this.verbose) {
                System.out.println(", failed.");
            }
            throw pex;
        }
        catch (Throwable th) {
            th.printStackTrace();
            throw new SMIParseException(th.getMessage(), 0);
        }
        if (this.verbose) {
            System.out.println(", done.");
        }
        try {
            fi.close();
        }
        catch (IOException th) {
            // empty catch block
        }
        for (int i = 0; i < info.length; ++i) {
            info[i].path = new File(path);
        }
        return info;
    }

    @Override
    public synchronized MIBRepository createRepository(InputStream fi, ImportModuleListener l) throws SMIParseException {
        return this.createRepository(fi, l, false);
    }

    public synchronized MIBRepository createRepository(InputStream fi, ImportModuleListener l, boolean ignoreErrors) throws SMIParseException {
        MIBRepository rep = null;
        SMIParser parser = new SMIParser(fi);
        parser.setMaxErrors(ignoreErrors ? Integer.MAX_VALUE : this.maxErrors);
        SMIRepository tree = null;
        try {
            tree = parser.Input(fi.toString());
            tree.setImporter(l);
            tree.createOids();
        }
        catch (ParseException ex) {
            if (this.verbose) {
                ex.printStackTrace();
            }
            try {
                fi.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            SMIParseException nex = new SMIParseException(ex.getMessage(), ex.getShortMessage(), ex.errorType, ex);
            nex.setErrorList(parser.getErrors());
            throw nex;
        }
        catch (Throwable t) {
            try {
                fi.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (t instanceof TokenMgrError) {
                if (this.verbose) {
                    System.out.println("failed.");
                }
                throw new SMIParseException(t.getMessage(), null, 50, (TokenMgrError)t);
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            throw new SMIParseException(t.getMessage(), 1000);
        }
        if (this.verbose) {
            System.out.print("parsed");
        }
        try {
            rep = this.createRepository(tree, parser.getErrors(), false, ignoreErrors);
        }
        catch (SMIParseException pex) {
            if (this.verbose) {
                System.out.println(", failed.");
            }
            throw pex;
        }
        catch (Throwable th) {
            th.printStackTrace();
            throw new SMIParseException(th.getMessage(), 0);
        }
        if (!ignoreErrors && parser.getErrors().size() >= this.maxErrors) {
            if (this.verbose) {
                System.out.println("failed.");
            }
            pex = (SMIParseException)parser.getErrors().get(0);
            pex.setErrorList(parser.getErrors());
            throw pex;
        }
        if (this.verbose) {
            System.out.println(", done.");
        }
        try {
            fi.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return rep;
    }

    @Override
    public ModuleInfo[] addModules(File file) throws SMIParseException {
        return this.addModules(file, this);
    }

    public synchronized ModuleInfo[] addModules(File file, ImportModuleListener importer) throws SMIParseException {
        try {
            return this.addModules(new FileInputStream(file), file.getPath(), importer);
        }
        catch (FileNotFoundException ex) {
            throw new SMIParseException(file.getPath(), 10);
        }
    }

    @Override
    public ModuleInfo[] addModules(InputStream fi, String path) throws SMIParseException {
        return this.addModules(fi, path, this);
    }

    public synchronized ModuleInfo[] addModules(InputStream fi, String path, ImportModuleListener importer) throws SMIParseException {
        return this.parse(fi, path, importer, false);
    }

    private ModuleInfo[] parse(InputStream fi, String path, ImportModuleListener importer, boolean lenient) throws SMIParseException {
        ModuleInfo[] info = null;
        if (this.verbose) {
            System.out.print("Loading MIB file [" + path + "]...");
        }
        SMIParser parser = new SMIParser(fi);
        if (lenient) {
            parser.setLenient(1);
        }
        parser.setMaxErrors(this.maxErrors);
        SMIRepository tree = null;
        try {
            tree = parser.Input(path);
            tree.setImporter(importer);
            tree.createOids();
        }
        catch (ParseException ex) {
            if (this.verbose) {
                ex.printStackTrace();
            }
            try {
                fi.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            SMIParseException nex = new SMIParseException(ex.getMessage(), ex.getShortMessage(), ex.errorType, ex);
            if (this.extendedParserInfoEnabled) {
                nex.setSmiRepository(tree);
            }
            nex.setErrorList(parser.getErrors());
            throw nex;
        }
        catch (Throwable t) {
            if (this.verbose) {
                t.printStackTrace();
            }
            try {
                fi.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (t instanceof TokenMgrError) {
                if (this.verbose) {
                    System.out.println("failed.");
                }
                throw new SMIParseException(t.getMessage(), null, 50, (TokenMgrError)t);
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            t.printStackTrace();
            throw new SMIParseException(t.getMessage(), 1000);
        }
        if (parser.getErrors().size() >= this.maxErrors) {
            if (this.verbose) {
                System.out.println("failed.");
            }
            SMIParseException pex = (SMIParseException)parser.getErrors().get(0);
            if (this.extendedParserInfoEnabled) {
                pex.setSmiRepository(tree);
            }
            pex.setErrorList(parser.getErrors());
            throw pex;
        }
        if (this.verbose) {
            System.out.print("parsed");
        }
        try {
            info = this.updateRepository(tree, parser.getErrors(), lenient, path);
        }
        catch (SMIParseException pex) {
            if (this.verbose) {
                System.out.println(", failed.");
            }
            if (this.extendedParserInfoEnabled) {
                pex.setSmiRepository(tree);
            }
            throw pex;
        }
        catch (Throwable th) {
            th.printStackTrace();
            throw new SMIParseException(th.getMessage(), 0);
        }
        if (this.verbose) {
            System.out.println(", done.");
        }
        try {
            fi.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return info;
    }

    @Override
    public synchronized ModuleInfo[] addModulesLeniently(InputStream fi, String path) throws SMIParseException {
        return this.parse(fi, path, this, true);
    }

    @Override
    public synchronized ModuleInfo[] addModulesLeniently(File file) throws SMIParseException {
        try {
            return this.parse(new FileInputStream(file), file.getPath(), this, true);
        }
        catch (FileNotFoundException ex) {
            throw new SMIParseException(file.getPath(), 10);
        }
    }

    @Override
    public void freeModuleID(Integer moduleID, String moduleName) {
        try {
            this.freeModuleID(moduleID);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean removeModule(String moduleName) throws IOException {
        block4: {
            try {
                MIBModule module = this.loadModuleFromFile(moduleName, true);
                if (module == null) break block4;
                RepositoryEvent event = new RepositoryEvent(this, moduleName);
                this.fireDeleteModule(event);
                if (!event.isModuleDeleted()) {
                    if (event.isUseDefaults()) {
                        this.freeModuleID(module.getModuleID(), moduleName);
                        break block4;
                    }
                    return false;
                }
                return true;
            }
            catch (Exception module) {
                // empty catch block
            }
        }
        File m = new File(this.path.getPath() + File.separatorChar + moduleName);
        return m.delete();
    }

    @Override
    public Integer createModuleID(String moduleName) {
        try {
            return this.createModuleID();
        }
        catch (IOException iox) {
            return null;
        }
    }

    public synchronized Integer createModuleID() throws IOException {
        Integer nextID;
        Integer mid = nextID = new Integer(this.initialModuleID);
        try {
            if (this.path != null) {
                Closeable file;
                File f = new File(this.path.getPath() + File.separatorChar + "MODULE.IDS");
                Vector freelist = new Vector();
                if (f.exists()) {
                    file = new FileInputStream(f);
                    ObjectInputStream input = new ObjectInputStream((InputStream)file);
                    mid = (Integer)input.readObject();
                    freelist = (Vector)input.readObject();
                    input.close();
                }
                if (freelist.size() > 0) {
                    nextID = (Integer)freelist.firstElement();
                    freelist.removeElementAt(0);
                } else {
                    if ((mid = new Integer(mid + 1)) < 0) {
                        mid = new Integer(this.initialModuleID);
                    }
                    nextID = mid;
                }
                file = new FileOutputStream(f);
                ObjectOutputStream output = new ObjectOutputStream((OutputStream)file);
                output.writeObject(mid);
                output.writeObject(freelist);
                output.flush();
                output.close();
            } else {
                nextID = new Integer(this.initialModuleID++);
            }
            return nextID;
        }
        catch (Exception ex) {
            throw new IOException("Could not create unique module id: " + ex.getMessage());
        }
    }

    public void freeModuleID(Integer freedID) throws IOException {
        if (freedID <= this.initialModuleID) {
            return;
        }
        try {
            if (this.path != null) {
                File f = new File(this.path.getPath() + File.separatorChar + "MODULE.IDS");
                Integer mid = new Integer(this.initialModuleID);
                Vector freelist = new Vector();
                if (f.exists()) {
                    FileInputStream file = new FileInputStream(f);
                    ObjectInputStream input = new ObjectInputStream(file);
                    mid = (Integer)input.readObject();
                    freelist = (Vector)input.readObject();
                    input.close();
                    freelist.addElement(freedID);
                    FileOutputStream fileOut = new FileOutputStream(f);
                    ObjectOutputStream output = new ObjectOutputStream(fileOut);
                    output.writeObject(mid);
                    output.writeObject(freelist);
                    output.flush();
                    output.close();
                }
            }
        }
        catch (Exception ex) {
            throw new IOException("Could not free module id: " + ex.getMessage());
        }
    }

    @Override
    public MIBObject[] getImportedObjects(Map<String, Integer> visitedModules, String moduleName) throws IOException {
        return this.getImportedObjects(visitedModules, moduleName, false, false);
    }

    @Override
    public MIBObject[] getImportedObjects(Map<String, Integer> visited, String moduleName, boolean includeModule, boolean includeImportedModules) throws IOException {
        try {
            MIBModule m = this.loadModuleFromFile(moduleName, true);
            visited.put(m.getModuleName(), m.getModuleID());
            ArrayList<MIBObject> objects = new ArrayList<MIBObject>();
            if (m.getImports() == null) {
                return new MIBObject[0];
            }
            if (includeModule) {
                objects.add(m);
            }
            for (int i = 0; i < m.getImports().length; ++i) {
                MIBObject[] imported;
                HashSet indexes = new HashSet();
                HashMap<String, String> imports = new HashMap<String, String>();
                for (int j = 0; j < m.getImports()[i].getImports().length; ++j) {
                    String importedObject = m.getImports()[i].getImports()[j];
                    imports.put(importedObject, importedObject);
                }
                MIBObject[] objs = this.getObjects(m.getImports()[i].getSource());
                if (includeImportedModules && objs != null && objs.length > 0) {
                    objects.add(objs[0]);
                }
                HashMap<String, MIBObject> objectDict = new HashMap<String, MIBObject>(objs.length + 10);
                for (MIBObject o : objs) {
                    MIBObjectType ot;
                    objectDict.put(o.getName(), o);
                    if (imports.get(o.getName()) == null && !(o instanceof MIBTextualConvention)) continue;
                    objects.add(o);
                    if (!this.isImportTableDependencies() || !(o instanceof MIBObjectType) || !(ot = (MIBObjectType)o).isTable()) continue;
                    String[] ind = ot.getIndexPart().getIndexPart();
                    Collections.addAll(indexes, ind);
                    ind = ot.getTableEntries();
                    Collections.addAll(indexes, ind);
                }
                for (String ind : indexes) {
                    MIBObject o = (MIBObject)objectDict.get(ind);
                    if (o == null) continue;
                    objects.add(o);
                }
                String source = m.getImports()[i].getSource();
                if (visited.get(source) != null) continue;
                for (MIBObject mibObject : imported = this.getImportedObjects(visited, source, includeImportedModules, includeImportedModules)) {
                    if (!(mibObject instanceof MIBTextualConvention) && !indexes.contains(mibObject.getName())) continue;
                    objects.add(mibObject);
                }
            }
            return objects.toArray(new MIBObject[0]);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Incompatible repository format: " + cnfe.getMessage());
        }
    }

    @Override
    public MIBObject[] getImportedObjects(String moduleName) throws IOException {
        return this.getImportedObjects(new HashMap<String, Integer>(), moduleName);
    }

    @Override
    public void saveModule(MIBModule m) throws IOException {
        m.setLastChange(new Date(System.currentTimeMillis()));
        MIBRepository r = new MIBRepository(m.getObjects());
        this.saveModulesFromRepository(r);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean saveModulesFromRepository(MIBRepository rep) throws IOException {
        boolean added = true;
        Iterator<MIBModule> modules = rep.modulesIterator();
        while (modules.hasNext()) {
            ObjectOutputStream output;
            MIBModule m = modules.next();
            RepositoryEvent event = new RepositoryEvent(this, m.getModuleName(), m);
            this.fireWriteModule(event);
            if (event.getOutputStream() == null) {
                if (!event.isUseDefaults()) return false;
                File f = new File(this.path.getPath(), m.getModuleName());
                if (f.exists()) {
                    added = false;
                }
                FileOutputStream file = new FileOutputStream(f.getPath());
                output = new ObjectOutputStream(file);
            } else {
                output = new ObjectOutputStream(event.getOutputStream());
            }
            if (this.useCompression) {
                output.writeInt(-1);
                GZIPOutputStream zos = new GZIPOutputStream(output);
                ObjectOutputStream zoos = new ObjectOutputStream(zos);
                DefaultRepositoryManager.writeObjects(rep, m, zoos);
                zoos.flush();
                zoos.close();
            } else {
                DefaultRepositoryManager.writeObjects(rep, m, output);
            }
            output.flush();
            output.close();
            this.repCache.put(m.getModuleName(), new RepositoryCacheEntry((MIBModule)m.getClone()));
        }
        return added;
    }

    private static void writeObjects(MIBRepository rep, MIBModule m, ObjectOutputStream output) throws IOException {
        int size = m.size();
        if (m.getName() != null && m.objectsByName().get(m.getName()) == null) {
            ++size;
        }
        output.writeInt(size);
        output.writeObject(m);
        Enumeration<MIBObject> objects = m.objects();
        while (objects.hasMoreElements()) {
            MIBObject o = objects.nextElement();
            if (o instanceof MIBModule) continue;
            try {
                output.writeObject(o);
            }
            catch (Exception ex) {
                System.err.println("Failed to serialize object: " + o.toSMI(1, m.getSMIVersion(), rep, "\n"));
                throw new RuntimeException(ex);
            }
        }
    }

    protected MIBModule loadModuleFromFile(String moduleName, boolean moduleOnly) throws IOException, ClassNotFoundException {
        MIBModule m;
        ObjectInputStream input;
        int sz;
        RepositoryEvent event = new RepositoryEvent(this, moduleName);
        this.fireReadModule(event);
        InputStream file = null;
        boolean cacheable = true;
        if (event.getInputStream() == null) {
            File f;
            if (event.isUseDefaults() && (f = new File(this.path.getPath(), moduleName)).exists()) {
                MIBModule m2 = this.getModuleFromCache(moduleName, f.lastModified());
                if (m2 != null) {
                    return m2;
                }
                file = Files.newInputStream(f.toPath(), new OpenOption[0]);
            }
            if (file == null) {
                cacheable = false;
                String resourceName = "modules/" + moduleName + ".cmib";
                file = IModule.class.getResourceAsStream(resourceName);
                if (file == null) {
                    throw new FileNotFoundException(moduleName);
                }
            }
        } else {
            file = event.getInputStream();
        }
        if ((sz = (input = this.createObjectInputStream(file)).readInt()) == -1) {
            GZIPInputStream zis = new GZIPInputStream(input);
            ObjectInputStream zois = new ObjectInputStream(zis);
            sz = zois.readInt();
            m = this.readObjects(moduleOnly, zois, sz);
        } else {
            m = this.readObjects(moduleOnly, input, sz);
        }
        try {
            input.close();
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        event = new RepositoryEvent(this, moduleName, m);
        this.fireAfterReadModule(event);
        if (!moduleOnly && cacheable) {
            this.repCache.put(moduleName, new RepositoryCacheEntry(m));
        }
        return m;
    }

    private ObjectInputStream createObjectInputStream(InputStream fis) throws IOException {
        int bytesRead;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[65535];
        while ((bytesRead = fis.read(buffer)) != -1) {
            bos.write(buffer, 0, bytesRead);
        }
        byte[] fileBytes = bos.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileBytes);
        return new ObjectInputStream(byteArrayInputStream);
    }

    @Override
    public String[] getBuiltinModuleNames() {
        String resourceName = "modules/builtin-modules.properties";
        InputStream file = IModule.class.getResourceAsStream(resourceName);
        if (file != null) {
            Properties props = new Properties();
            try {
                props.load(file);
                return props.values().toArray(new String[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new String[0];
    }

    private MIBModule readObjects(boolean moduleOnly, ObjectInputStream input, int sz) throws ClassNotFoundException, IOException {
        MIBModule m = (MIBModule)input.readObject();
        m.reinit();
        if (!moduleOnly) {
            for (int i = 0; i < sz - 1; ++i) {
                try {
                    MIBObject obj = (MIBObject)input.readObject();
                    m.add(obj);
                    continue;
                }
                catch (EOFException eof) {
                    if (i + 1 >= sz - 1) continue;
                    System.err.println("MIB module " + m.getModuleName() + " should have had " + sz + " MIB objects, but actually has only " + (i + 1));
                }
            }
        }
        return m;
    }

    @Override
    public void initialize() throws IOException {
        String[] files = this.path.list();
        if (files != null) {
            for (String file : files) {
                File f = new File(this.path.getPath() + File.separator + file);
                f.delete();
            }
        }
    }

    @Override
    public ModuleInfo[] getModuleInfos() throws IOException {
        return this.getModuleInfos(null);
    }

    public ModuleInfo[] getModuleInfos(ProgressCallback progress) throws IOException {
        MIBModule[] modules = this.getModules(true, progress);
        if (modules == null) {
            return null;
        }
        ModuleInfo[] infos = new ModuleInfo[modules.length];
        for (int i = 0; i < modules.length; ++i) {
            infos[i] = new ModuleInfo(modules[i].getModuleName(), modules[i].getImportSources());
            String lastUpdated = modules[i].getLastUpdated();
            if (lastUpdated == null) continue;
            try {
                infos[i].setLastUpdated(MIBModule.getDateFromUTC(MIBObject.getUnquotedString(lastUpdated)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return infos;
    }

    public MIBModule[] getModules(boolean withoutObjects, ProgressCallback progress) throws IOException {
        String[] files = null;
        if (this.repositoryListeners != null) {
            files = this.fireListModules();
        }
        if ((files == null || files.length == 0) && this.path != null) {
            files = this.getModuleNames();
        }
        OrderedMap v = new OrderedMap(LexicographicPredicate.instance);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    if (progress != null && progress.progressEvent(i, files.length, files[i])) {
                        return null;
                    }
                    MIBModule m = this.loadModuleFromFile(files[i], withoutObjects);
                    v.add(m.getModuleName(), m);
                    continue;
                }
                catch (ClassNotFoundException m) {
                    // empty catch block
                }
            }
        }
        MIBModule[] modules = new MIBModule[v.size()];
        int i = 0;
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            modules[i] = (MIBModule)en.nextElement();
            ++i;
        }
        return modules;
    }

    @Override
    public MIBModule[] getModules() throws IOException {
        return this.getModules(true, null);
    }

    @Override
    public MIBModule getModule(String moduleName) throws IOException {
        try {
            return this.loadModuleFromFile(moduleName, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public MIBModule getModule(String moduleName, boolean includingObjects) throws IOException {
        try {
            return this.loadModuleFromFile(moduleName, !includingObjects);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public MIBObject[] getObjects(String moduleName) throws IOException {
        try {
            MIBModule m = this.loadModuleFromFile(moduleName, false);
            MIBObject[] objs = new MIBObject[1 + m.size()];
            objs[0] = m;
            int i = 1;
            Iterator<MIBObject> it = m.objectsIterator();
            while (it.hasNext()) {
                objs[i] = it.next();
                ++i;
            }
            return objs;
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("File format error while loading objects from " + moduleName + ": " + cnfe.getMessage());
        }
    }

    @Override
    public String[] getModuleNames() throws IOException {
        if (this.repositoryListeners != null && !this.repositoryListeners.isEmpty()) {
            return this.fireListModules();
        }
        return this.getModuleNamesFromDirectory();
    }

    public String[] getModuleNamesFromDirectory() throws IOException {
        return this.path.list(new ModuleFileNameFilter());
    }

    public void setRepManForImports(RepositoryManager rm) {
        this.rm = rm;
    }

    private static String getErrorTextTemplate(int errorNr) {
        String format;
        switch (errorNr) {
            case 0: {
                if (DefaultRepositoryManager.isForwardUnknownErrors()) {
                    format = res.getString("errUnknownWithMessageText");
                    break;
                }
                format = res.getString("errUnknown");
                break;
            }
            case 1000: {
                format = res.getString("errParser");
                break;
            }
            case 1001: {
                format = res.getString("errParserDisplayHint");
                break;
            }
            case 1002: {
                format = res.getString("errParserUTCTime");
                break;
            }
            case 1100: {
                format = res.getString("errImportUnknown");
                break;
            }
            case 10: {
                format = res.getString("errFileOpenError");
                break;
            }
            case 1101: {
                format = res.getString("errImportCyclic");
                break;
            }
            case 1502: {
                format = res.getString("errUndefName");
                break;
            }
            case 1501: {
                format = res.getString("errUndefObject");
                break;
            }
            case 1500: {
                format = res.getString("errUndefSyntax");
                break;
            }
            case 1150: {
                format = res.getString("errModuleOrder");
                break;
            }
            case 1201: {
                format = res.getString("errInconsistentStatus");
                break;
            }
            case 1200: {
                format = res.getString("errInconsistentSyntax");
                break;
            }
            case 1202: {
                format = res.getString("errInconsistentAccess");
                break;
            }
            case 5000: {
                format = res.getString("errNotInGroup");
                break;
            }
            case 1700: {
                format = res.getString("errWrongType");
                break;
            }
            case 50: {
                format = res.getString("errLexical");
                break;
            }
            case 1810: {
                format = res.getString("errInvalidIndex");
                break;
            }
            case 1813: {
                format = res.getString("errInvalidImpliedLengthIndex");
                break;
            }
            case 6000: {
                format = res.getString("errPibIndexNotInstanceId");
                break;
            }
            case 1812: {
                format = res.getString("errInvalidIndexLength");
                break;
            }
            case 4010: {
                format = res.getString("errInvalidRange");
                break;
            }
            case 1850: {
                format = res.getString("errScalarIndex");
                break;
            }
            case 2000: {
                format = res.getString("errDuplicateRegistration");
                break;
            }
            case 2010: {
                format = res.getString("errIllegalRegistration");
                break;
            }
            case 1110: {
                format = res.getString("errWrongImport");
                break;
            }
            case 1111: {
                format = res.getString("errMissingImport");
                break;
            }
            case 1112: {
                format = res.getString("errInconsistentImport");
                break;
            }
            case 1113: {
                format = res.getString("errDuplicateImport");
                break;
            }
            case 1102: {
                format = res.getString("errDuplicateImportSource");
                break;
            }
            case 1114: {
                format = res.getString("errIllegalImport");
                break;
            }
            case 1820: {
                format = res.getString("errNegativeIndex");
                break;
            }
            case 1800: {
                format = res.getString("errInconsistentTable");
                break;
            }
            case 1801: {
                format = res.getString("errInconsistentTableDef");
                break;
            }
            case 5100: {
                format = res.getString("errNoAccessInGroup");
                break;
            }
            case 5101: {
                format = res.getString("errNoAccessInNotification");
                break;
            }
            case 3000: {
                format = res.getString("errDefaultValueOutOfRange");
                break;
            }
            case 3001: {
                format = res.getString("errDefaultValueSizeOutOfRange");
                break;
            }
            case 3002: {
                format = res.getString("errDefaultValueInvalid");
                break;
            }
            case 3003: {
                format = res.getString("errDefaultValueIllegal");
                break;
            }
            case 4000: {
                format = res.getString("errInvalidSyntaxRefinement");
                break;
            }
            case 1050: {
                format = res.getString("errIllegalClause");
                break;
            }
            case 1851: {
                format = res.getString("errScalarWithIndex");
                break;
            }
            case 1600: {
                format = res.getString("errRefIsNotATable");
                break;
            }
            case 1210: {
                format = res.getString("errCondGroupIsAlsoManadatory");
                break;
            }
            case 1601: {
                format = res.getString("errRefIsNotAGroup");
                break;
            }
            case 1602: {
                format = res.getString("errRefIsNotObjectType");
                break;
            }
            case 1211: {
                format = res.getString("errVariationNotInGroup");
                break;
            }
            case 1212: {
                format = res.getString("errIllegalAccessForNotifyVariation");
                break;
            }
            case 1220: {
                format = res.getString("errCreationRequiresNotAllowed");
                break;
            }
            case 1221: {
                format = res.getString("errCreationRequiresReadCreateCols");
                break;
            }
            case 1010: {
                format = res.getString("errIdentifierTooLong");
                break;
            }
            case 1020: {
                format = res.getString("errDuplicateIdentifier");
                break;
            }
            case 1811: {
                format = res.getString("errMissingIndex");
                break;
            }
            case 4100: {
                format = res.getString("errInvalidSyntax4DisplayHint");
                break;
            }
            case 4101: {
                format = res.getString("errDisplayHintWrongType");
                break;
            }
            case 6003: {
                format = res.getString("errMissingPibTag");
                break;
            }
            case 6004: {
                format = res.getString("errMissingPibReference");
                break;
            }
            case 6001: {
                format = res.getString("errInvalidPibTag");
                break;
            }
            case 6002: {
                format = res.getString("errInvalidPibReference");
                break;
            }
            case 6005: {
                format = res.getString("errUniquenessContainsPibIndex");
                break;
            }
            case 6006: {
                format = res.getString("errUniquenessDuplicateAttribute");
                break;
            }
            case 6007: {
                format = res.getString("errInstallErrorNumberOutofRange");
                break;
            }
            default: {
                format = res.getString("errUnknown");
            }
        }
        return format;
    }

    public static String getErrorText(SMIParseException pex) {
        return DefaultRepositoryManager.getErrorText(pex, true, true);
    }

    public static String getErrorText(SMIParseException pex, boolean showErrorNumber) {
        return DefaultRepositoryManager.getErrorText(pex, showErrorNumber, true);
    }

    public static String getErrorText(SMIParseException pex, boolean showErrorNumber, boolean showLocation) {
        return DefaultRepositoryManager.getErrorText(pex, showErrorNumber, showLocation, 0);
    }

    public static String getErrorText(SMIParseException pex, boolean showErrorNumber, boolean showLocation, int lineOffset) {
        FileError err;
        Object[] o;
        String message;
        if (res == null) {
            Locale locale = Locale.getDefault();
            res = ResourceBundle.getBundle(resClassName, new Locale(locale.getLanguage(), locale.getCountry(), locale.getVariant()));
        }
        String string = message = showLocation ? pex.getMessage() : pex.getShortMessage();
        if (message == null) {
            message = "";
        }
        String format = DefaultRepositoryManager.getErrorTextTemplate(pex.errorType);
        String formatLocation = res.getString("txtLocation");
        if (pex.objects == null) {
            o = new Object[]{message};
            if (pex.fileError instanceof SemanticError) {
                err = pex.fileError;
                o = new Object[1 + err.getExpected().length];
                o[0] = showLocation ? MessageFormat.format(formatLocation, err.getFound(), err.getLine() + lineOffset, err.getColumn()) : err.getFound();
                for (int i = 0; i < err.getExpected().length; ++i) {
                    o[i + 1] = err.getExpected()[i];
                }
            }
        } else {
            o = new Object[pex.objects.size()];
            pex.objects.toArray(o);
            if (pex.fileError instanceof SemanticError) {
                err = pex.fileError;
                if (o.length < 1) {
                    o = new Object[]{showLocation ? MessageFormat.format(formatLocation, err.getFound(), err.getLine() + lineOffset, err.getColumn()) : err.getFound()};
                }
            }
        }
        String errorNr = new DecimalFormat("0000").format(pex.errorType);
        String r = "";
        if (showErrorNumber) {
            String formatErrNum = res.getString("txtErrNum");
            r = r + MessageFormat.format(formatErrNum, errorNr);
        }
        r = r + MessageFormat.format(format, o);
        return r;
    }

    public void setOptions(int newOptions) {
        this.options = newOptions;
    }

    public int getOptions() {
        return this.options;
    }

    @Override
    public void importModule(ImportModuleEvent e) {
        try {
            IObject[] objs = this.getObjects(e.getModuleName());
            e.setObjects(objs);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isModuleAvailable(String moduleName) {
        File f = new File(this.path, moduleName);
        return f.exists() && f.isFile();
    }

    public synchronized void removeRepositoryListener(RepositoryListener l) {
        if (this.repositoryListeners != null && this.repositoryListeners.contains(l)) {
            ArrayList<RepositoryListener> v = new ArrayList<RepositoryListener>(this.repositoryListeners);
            v.remove(l);
            this.repositoryListeners = v;
        }
    }

    public synchronized void addRepositoryListener(RepositoryListener l) {
        ArrayList<RepositoryListener> v;
        ArrayList<RepositoryListener> arrayList = v = this.repositoryListeners == null ? new ArrayList<RepositoryListener>(1) : new ArrayList<RepositoryListener>(this.repositoryListeners);
        if (!v.contains(l)) {
            v.add(l);
            this.repositoryListeners = v;
        }
    }

    protected void fireWriteModule(RepositoryEvent e) {
        if (this.repositoryListeners != null) {
            List<RepositoryListener> listeners = this.repositoryListeners;
            for (RepositoryListener listener : listeners) {
                listener.writeModule(e);
            }
        }
    }

    protected void fireReadModule(RepositoryEvent e) {
        if (this.repositoryListeners != null) {
            List<RepositoryListener> listeners = this.repositoryListeners;
            for (RepositoryListener listener : listeners) {
                listener.readModule(e);
            }
        }
    }

    protected void fireAfterReadModule(RepositoryEvent e) {
        if (this.repositoryListeners != null) {
            List<RepositoryListener> listeners = this.repositoryListeners;
            for (RepositoryListener listener : listeners) {
                if (!(listener instanceof ExtRepsitoryListener)) continue;
                ((ExtRepsitoryListener)listener).afterReadModule(e);
            }
        }
    }

    protected void fireDeleteModule(RepositoryEvent e) {
        if (this.repositoryListeners != null) {
            List<RepositoryListener> listeners = this.repositoryListeners;
            for (RepositoryListener listener : listeners) {
                listener.deleteModule(e);
            }
        }
    }

    protected String[] fireListModules() {
        HashSet<String> modules = new HashSet<String>();
        if (this.repositoryListeners != null) {
            List<RepositoryListener> listeners = this.repositoryListeners;
            for (RepositoryListener listener : listeners) {
                String[] m = listener.listModuleNames();
                if (m == null) continue;
                modules.addAll(Arrays.asList(m));
            }
        }
        return modules.toArray(new String[0]);
    }

    public void setImportTableDependencies(boolean importTableDependencies) {
        this.importTableDependencies = importTableDependencies;
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    @Override
    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public static void setForwardUnknownErrors(boolean forwardUnknownErrors) {
        DefaultRepositoryManager.forwardUnknownErrors = forwardUnknownErrors;
    }

    public boolean isImportTableDependencies() {
        return this.importTableDependencies;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    @Override
    public boolean isUseCompression() {
        return this.useCompression;
    }

    public static boolean isForwardUnknownErrors() {
        return forwardUnknownErrors;
    }

    public static void main(String[] args) {
        DefaultRepositoryManager repMan = new DefaultRepositoryManager();
        try {
            repMan.open(new File(args[0]));
            if (args.length == 1) {
                String[] failed = repMan.verifyRepository(null);
                if (failed.length == 0) {
                    System.out.println("Repository '" + args[0] + "' is OK.");
                } else {
                    for (String s : failed) {
                        System.out.println("File '" + s + "' is invalid.");
                    }
                    System.exit(1);
                }
            } else if (args.length >= 3) {
                String moduleName = args[1];
                String outfile = args[2];
                long count = 0L;
                long position = 0L;
                InputStream file = null;
                File f = new File(repMan.path, moduleName);
                if (f.exists()) {
                    file = Files.newInputStream(f.toPath(), new OpenOption[0]);
                }
                ObjectInputStream input = new ObjectInputStream(file);
                int sz = input.readInt();
                Object m = null;
                if (sz == -1) {
                    file = new GZIPInputStream(input);
                }
                FileOutputStream outputFile = new FileOutputStream(outfile);
                ReadableByteChannel byteChannel = Channels.newChannel(file);
                while ((count = outputFile.getChannel().transferFrom(byteChannel, position, 0x400000L)) > 0L) {
                    position += count;
                }
                outputFile.flush();
                outputFile.close();
                file.close();
                System.out.println("Written " + position + " bytes to " + outfile);
            }
        }
        catch (IOException ex) {
            System.err.println("Failed to open repository: " + ex.getMessage());
            System.exit(2);
        }
    }

    @Override
    public MIBObject parseObject(String object, String objectName, MIBModule module, boolean parseModuleIdentity, int parseLevel) throws SMIParseException {
        boolean lenient;
        StringReader reader = new StringReader(object);
        SMIParser parser = new SMIParser(reader);
        boolean bl = lenient = parseLevel == 2;
        if (lenient) {
            parser.setLenient(1);
        }
        parser.setMaxErrors(this.maxErrors);
        SMIRepository tree = null;
        try {
            int parseMode;
            HashSet<String> objectNames = new HashSet<String>(module.size());
            MIBObject oldObject = null;
            Iterator<MIBObject> it = module.objectsIterator();
            while (it.hasNext()) {
                MIBObject o = it.next();
                String name = o.getName();
                if (objectName.equals(name)) {
                    oldObject = o;
                    continue;
                }
                objectNames.add(name);
            }
            int n = module.getSMIVersion() == 1 ? 1 : (parseMode = module.getSMIVersion() == -1 ? 16 : 2);
            if (parseModuleIdentity) {
                parseMode |= 4;
            }
            if (oldObject instanceof MIBObjectType && ((MIBObjectType)oldObject).isTable()) {
                parseMode |= 8;
            }
            tree = parser.InputObject(parseMode, objectNames);
            tree.addScope(module.getName());
            tree.setImporter(this);
            tree.createOids();
        }
        catch (ParseException ex) {
            if (this.verbose) {
                ex.printStackTrace();
            }
            SMIParseException nex = new SMIParseException(ex.getMessage(), ex.getShortMessage(), ex.errorType, ex);
            if (this.extendedParserInfoEnabled) {
                nex.setSmiRepository(tree);
            }
            nex.setErrorList(parser.getErrors());
            throw nex;
        }
        catch (Throwable t) {
            if (this.verbose) {
                t.printStackTrace();
            }
            if (t instanceof TokenMgrError) {
                throw new SMIParseException(t.getMessage(), null, 50, (TokenMgrError)t);
            }
            throw new SMIParseException(t.getMessage(), 1000);
        }
        if (parser.getErrors().size() >= this.maxErrors) {
            SMIParseException pex = (SMIParseException)parser.getErrors().get(0);
            if (this.extendedParserInfoEnabled) {
                pex.setSmiRepository(tree);
            }
            pex.setErrorList(parser.getErrors());
            throw pex;
        }
        try {
            SMI2Java visitor = lenient ? new LenientSMI2Java(tree, this.options) : new SMI2Java(tree, this.options){

                @Override
                public void checkModule() {
                    this.smiRep.resolveSyntaxes();
                }
            };
            visitor.setErrors(parser.getErrors());
            visitor.setMaxErrors(this.maxErrors);
            tree.setErrorHandler(visitor);
            HashSet<String> exceptions = new HashSet<String>(1);
            exceptions.add(objectName);
            visitor.setParseContext(module, exceptions);
            Vector v = new Vector();
            tree.jjtAccept(visitor, v);
            visitor.checkModule();
            if (visitor.getErrors().size() > 0) {
                SMIParseException pex = (SMIParseException)visitor.getErrors().get(0);
                pex.setErrorList(parser.getErrors());
                throw pex;
            }
            visitor.getRepository().structureChanged();
            MIBObject currentObject = visitor.getCurrentObject();
            if (currentObject != null) {
                visitor.recheckObject(currentObject);
            }
            if (visitor.getErrors().size() > 0) {
                SMIParseException pex = (SMIParseException)visitor.getErrors().get(0);
                pex.setErrorList(parser.getErrors());
                throw pex;
            }
            if (this.extendedParserInfoEnabled && currentObject != null) {
                currentObject.userObject = tree;
            }
            return currentObject;
        }
        catch (SMIParseException pex) {
            if (this.extendedParserInfoEnabled) {
                pex.setSmiRepository(tree);
            }
            throw pex;
        }
        catch (Throwable th) {
            th.printStackTrace();
            throw new SMIParseException(th.getMessage(), 0);
        }
    }

    public String[] verifyRepository(ProgressCallback progress) {
        LinkedList<String> failed = new LinkedList<String>();
        File f = new File(this.path.getPath() + File.separatorChar + "MODULE.IDS");
        Integer mid = this.initialModuleID;
        Vector freelist = new Vector();
        try {
            if (f.exists()) {
                FileInputStream file = new FileInputStream(f);
                ObjectInputStream input = new ObjectInputStream(file);
                mid = (Integer)input.readObject();
                freelist = (Vector)input.readObject();
                input.close();
            }
        }
        catch (Exception ex) {
            failed.add(f.getPath());
        }
        boolean adjustFreeList = false;
        try {
            String[] files = this.getModuleNames();
            HashSet<Integer> usedlist = new HashSet<Integer>(files.length);
            for (int i = 0; i < files.length; ++i) {
                block21: {
                    try {
                        if (progress != null && progress.progressEvent(i, files.length, files[i])) {
                            return null;
                        }
                        MIBModule m = this.loadModuleFromFile(files[i], false);
                        if (m.getModuleID() > mid) {
                            if (progress == null) {
                                System.out.println("Warning: Module ID " + m.getModuleID() + " of MIB file " + files[i] + " is greater than next module ID " + mid + " (will be corrected)");
                            }
                            mid = m.getModuleID();
                            adjustFreeList = true;
                        }
                        if (freelist.contains(m.getModuleID())) {
                            freelist.remove(m.getModuleID());
                            adjustFreeList = true;
                            if (progress == null) {
                                System.out.println("Verification of " + files[i] + " with ID " + m.getModuleID() + " OK, but using using free ID (will be corrected)");
                            }
                        } else if (usedlist.contains(m.getModuleID())) {
                            failed.add(files[i]);
                            if (progress == null) {
                                System.out.println("Verification of " + files[i] + " failed, because its module ID " + m.getModuleID() + " is alread used by another MIB module (rebuild of the MIB repository is needed)");
                            }
                        } else {
                            usedlist.add(m.getModuleID());
                            if (progress == null) {
                                System.out.println("Verified " + files[i] + " with ID " + m.getModuleID());
                            }
                        }
                    }
                    catch (Exception e) {
                        failed.add(files[i]);
                        if (progress != null) break block21;
                        System.out.println("Verification of " + files[i] + " failed: " + e.getMessage());
                    }
                }
                if (!adjustFreeList) continue;
                try {
                    FileOutputStream file = new FileOutputStream(f);
                    ObjectOutputStream output = new ObjectOutputStream(file);
                    output.writeObject(mid);
                    output.writeObject(freelist);
                    output.flush();
                    output.close();
                    continue;
                }
                catch (Exception ex) {
                    if (progress != null) continue;
                    System.err.println("Failed to adjust free module ID list: " + ex.getMessage());
                }
            }
        }
        catch (IOException ex) {
            if (progress == null) {
                System.err.println("Failed to verify repository: " + ex.getMessage());
            }
            return null;
        }
        return failed.toArray(new String[0]);
    }

    @Override
    public boolean refresh(MIBRepository rep, List<String> updated, List<String> removed, boolean simulateOnly) {
        Vector<String> modules = rep.getModuleNames();
        for (String name : modules) {
            MIBModule m = rep.getModule(name);
            if (m == null) continue;
            Date lastUpdated = m.getLastChange();
            MIBModule counterPart = null;
            try {
                counterPart = this.loadModuleFromFile(name, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (counterPart == null) {
                if (removed == null) continue;
                removed.add(name);
                if (simulateOnly) continue;
                rep.remove(m);
                continue;
            }
            if (!lastUpdated.before(counterPart.getLastChange())) continue;
            updated.add(name);
            if (simulateOnly) continue;
            rep.remove(m);
            try {
                counterPart = null;
                counterPart = this.loadModuleFromFile(name, false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (counterPart == null) continue;
            rep.addObject(counterPart);
            rep.addAllObjects(counterPart.getObjects());
        }
        if (!simulateOnly && !updated.isEmpty()) {
            rep.structureChanged();
        }
        return !updated.isEmpty() || removed != null && !removed.isEmpty();
    }

    private MIBModule getModuleFromCache(String moduleName, long lastModifiedOnDisk) {
        RepositoryCacheEntry e = this.repCache.get(moduleName);
        if (e != null) {
            if (e.lastUpdate >= lastModifiedOnDisk) {
                return (MIBModule)e.module.getClone();
            }
            if (this.verbose) {
                System.out.println("MIB module '" + moduleName + "' changed on disk");
            }
            this.repCache.remove(moduleName);
        }
        return null;
    }

    public void setExtendedParserInfoEnabled(boolean extendedParserInfoEnabled) {
        this.extendedParserInfoEnabled = extendedParserInfoEnabled;
    }

    public boolean isExtendedParserInfoEnabled() {
        return this.extendedParserInfoEnabled;
    }

    static class RepositoryCacheEntry {
        private final long lastUpdate;
        private final MIBModule module;

        public RepositoryCacheEntry(MIBModule module) {
            this.module = module;
            this.lastUpdate = System.currentTimeMillis();
        }
    }

    static class ModuleFileNameFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File path, String name) {
            return name.indexOf(46) < 0;
        }
    }
}

