/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.smi.ISyntax;
import com.agentpp.smi.IVariation;
import com.agentpp.smi.ext.SMISyntax;
import com.agentpp.smi.ext.SMIVariation;
import com.agentpp.smiparser.SMI;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public class MIBVariation
implements Serializable,
SMIVariation {
    public static final long serialVersionUID = 1000L;
    private MIBSyntax syntax = null;
    private MIBSyntax writeSyntax = null;
    private String variation = null;
    private String access = null;
    private Vector<String> creationRequires = new Vector();
    private String defval = null;
    private String description = null;
    private transient Object userObject = null;

    public MIBVariation() {
    }

    public MIBVariation(String variation, String descr) {
        this.variation = variation;
        this.description = descr;
    }

    public MIBVariation(MIBVariation other) {
        this.variation = other.variation;
        if (other.hasSyntax()) {
            this.syntax = new MIBSyntax(other.syntax);
        }
        if (other.hasWriteSyntax()) {
            this.writeSyntax = new MIBSyntax(other.writeSyntax);
        }
        this.access = other.access;
        this.defval = other.defval;
        if (other.hasCreationRequires()) {
            Enumeration<String> en = other.creationRequires.elements();
            while (en.hasMoreElements()) {
                this.creationRequires.addElement(en.nextElement());
            }
        }
        this.description = other.description;
    }

    public MIBVariation(IVariation other) {
        String[] creationRequiresList;
        this.variation = other.getVariation();
        if (other.hasSyntax()) {
            this.syntax = new MIBSyntax(other.getSyntaxDef());
        }
        if (other.hasWriteSyntax()) {
            this.writeSyntax = new MIBSyntax(other.getWriteSyntaxDef());
        }
        if (other.hasAccess()) {
            this.access = other.getAccess();
        }
        if (other.hasDefaultValue()) {
            this.defval = other.getDefval();
        }
        if ((creationRequiresList = other.getCreationRequires()) != null) {
            Collections.addAll(this.creationRequires, other.getCreationRequires());
        }
        this.description = other.getDescription();
    }

    public MIBSyntax getSyntax() {
        return this.syntax;
    }

    @Override
    public ISyntax getSyntaxDef() {
        return this.syntax;
    }

    @Override
    public ISyntax getWriteSyntaxDef() {
        return this.writeSyntax;
    }

    @Override
    public boolean hasSyntax() {
        return this.syntax != null;
    }

    @Override
    public boolean hasWriteSyntax() {
        return this.writeSyntax != null;
    }

    @Override
    public boolean hasAccess() {
        return this.access != null;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.defval != null;
    }

    @Override
    public void setSyntaxDef(SMISyntax newSyntax) {
        this.syntax = (MIBSyntax)newSyntax;
    }

    public void setSyntax(MIBSyntax newSyntax) {
        this.syntax = newSyntax;
    }

    public void setWriteSyntax(MIBSyntax newWriteSyntax) {
        this.writeSyntax = newWriteSyntax;
    }

    @Override
    public void setWriteSyntaxDef(SMISyntax newWriteSyntax) {
        this.writeSyntax = (MIBSyntax)newWriteSyntax;
    }

    public MIBSyntax getWriteSyntax() {
        return this.writeSyntax;
    }

    @Override
    public void setVariation(String newVariation) {
        this.variation = newVariation;
    }

    @Override
    public String getVariation() {
        return this.variation;
    }

    @Override
    public void setAccess(String newAccess) {
        this.access = newAccess;
    }

    @Override
    public String getAccess() {
        return this.access;
    }

    public boolean hasCreationRequires() {
        return this.creationRequires != null && this.creationRequires.size() > 0;
    }

    @Override
    public void setCreationRequires(String[] newCreationRequires) {
        this.creationRequires = new Vector<String>(Arrays.asList(newCreationRequires));
    }

    public void setCreationRequires(Vector<String> newCreationRequires) {
        this.creationRequires = newCreationRequires;
    }

    public Vector getCreationRequiresVector() {
        return this.creationRequires;
    }

    @Override
    public String[] getCreationRequires() {
        Object[] s = new String[this.creationRequires.size()];
        this.creationRequires.copyInto(s);
        return s;
    }

    @Override
    public void setDefval(String newDefval) {
        this.defval = newDefval;
    }

    @Override
    public String getDefval() {
        return this.defval;
    }

    @Override
    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toSMI(int mode, MIBRepository rep, MIBVariation c, String lineSeparator) {
        Object cs;
        StringBuffer buf = new StringBuffer(lineSeparator + "\t");
        MIBObject.addKeyWord(mode, buf, "VARIATION ");
        MIBObject.addString(mode, buf, this.variation, c == null ? null : c.variation);
        if (this.syntax != null) {
            buf.append(lineSeparator);
            buf.append("\t  ");
            MIBObject.addKeyWord(mode, buf, "SYNTAX   ");
            cs = null;
            if (c != null) {
                cs = c.syntax != null ? c.syntax : new MIBSyntax();
            }
            buf.append(this.syntax.toSMI(mode, rep, (MIBSyntax)cs, lineSeparator));
        }
        if (this.writeSyntax != null) {
            buf.append(lineSeparator);
            buf.append("\t  ");
            MIBObject.addKeyWord(mode, buf, "WRITE-SYNTAX ");
            cs = null;
            if (c != null) {
                cs = c.writeSyntax != null ? c.writeSyntax : new MIBSyntax();
            }
            buf.append(this.writeSyntax.toSMI(mode, rep, (MIBSyntax)cs, lineSeparator));
        }
        if (this.access != null) {
            buf.append(lineSeparator);
            buf.append("\t  ");
            MIBObject.addKeyWord(mode, buf, "ACCESS ");
            cs = null;
            if (c != null) {
                cs = c.access != null ? c.access : "";
            }
            MIBObject.addString(mode, buf, this.access, (String)cs);
            buf.append(lineSeparator);
        }
        if (this.creationRequires != null && this.creationRequires.size() > 0) {
            buf.append(lineSeparator);
            buf.append("\t  ");
            MIBObject.addKeyWord(mode, buf, "CREATION-REQUIRES");
            buf.append(" {");
            buf.append(lineSeparator);
            cs = null;
            if (c != null) {
                cs = c.creationRequires != null && c.creationRequires.size() > 0 ? MIBObject.formatObjectRefs(mode, "\t\t\t", c.creationRequires.iterator(), lineSeparator) : "";
            }
            MIBObject.addString(mode, buf, MIBObject.formatObjectRefs(mode, "\t\t\t", this.creationRequires.iterator(), lineSeparator), (String)cs);
            buf.append(" }");
        }
        if (this.defval != null) {
            buf.append(lineSeparator);
            buf.append("\t  ");
            MIBObject.addKeyWord(mode, buf, "DEFVAL");
            buf.append(" { ");
            cs = null;
            if (c != null) {
                cs = c.defval != null ? c.defval : "";
            }
            MIBObject.addString(mode, buf, this.defval, (String)cs);
            buf.append(" }");
        }
        buf.append(lineSeparator);
        buf.append("\t  ");
        MIBObject.addKeyWord(mode, buf, "DESCRIPTION");
        if (this.description != null) {
            buf.append(lineSeparator);
            cs = null;
            if (c != null) {
                cs = c.description != null && c.description.length() > 0 ? MIBObject.formatLines("\t\t", c.description) : "";
            }
            MIBObject.addText(lineSeparator, mode, buf, MIBObject.formatLines("\t\t", this.description), (String)cs);
        } else {
            MIBObject.addText(lineSeparator, mode, buf, "\"\"");
        }
        return buf.toString();
    }

    public String toString() {
        return this.variation;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public boolean equals(Object o) {
        if (o instanceof MIBVariation) {
            MIBVariation other = (MIBVariation)o;
            return MIBObject.saveCompare(this.syntax, other.syntax) && MIBObject.saveCompare(this.writeSyntax, other.writeSyntax) && MIBObject.saveCompare(this.variation, other.variation) && MIBObject.saveCompare(this.access, other.access) && MIBObject.saveCompare(this.creationRequires, other.creationRequires) && MIBObject.saveCompare(this.defval, other.defval) && MIBObject.saveCompare(this.description, other.description);
        }
        return false;
    }

    public void freeUserObjects() {
        this.userObject = null;
        if (this.hasSyntax()) {
            this.syntax.userObject = null;
        }
        if (this.hasWriteSyntax()) {
            this.writeSyntax.userObject = null;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.access = SMI.getCommonIdentifier(this.access);
    }
}

