/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.LexicographicPredicate;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBCondGroup;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.ObjectIDPredicate;
import com.agentpp.mib.util.EnumerationIterator;
import com.agentpp.smi.INotificationType;
import com.agentpp.smi.IObject;
import com.agentpp.smi.ISyntax;
import com.agentpp.smiparser.SMI;
import com.objectspace.jgl.OrderedMap;
import com.objectspace.jgl.OrderedMapIterator;
import com.objectspace.jgl.Pair;
import com.objectspace.jgl.Range;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class MIBRepository
implements Serializable {
    public static final long serialVersionUID = 100L;
    private transient ConcurrentHashMap<String, MIBModule> modules = null;
    private transient ConcurrentHashMap<Integer, MIBModule> moduleIDs = null;
    private transient ConcurrentHashMap<Integer, String> importedModuleIDs = null;
    private transient OrderedMap onames = null;
    private transient OrderedMap oids = null;
    private transient Vector listenerList;

    public MIBRepository() {
        this.init(false);
    }

    public MIBRepository(boolean addIETFObjects) {
        this.init(addIETFObjects);
    }

    public MIBRepository(MIBObject[] objects) {
        this.init(false);
        this.addAllObjects(objects);
    }

    public Object clone() {
        MIBRepository r = new MIBRepository();
        r.oids = (OrderedMap)this.oids.clone();
        r.onames = (OrderedMap)this.onames.clone();
        r.modules = new ConcurrentHashMap<String, MIBModule>(this.modules);
        r.moduleIDs = new ConcurrentHashMap<Integer, MIBModule>(this.moduleIDs);
        r.importedModuleIDs = new ConcurrentHashMap<Integer, String>(this.importedModuleIDs);
        return r;
    }

    private void init(boolean withIETF) {
        this.listenerList = new Vector(5);
        this.oids = new OrderedMap(ObjectIDPredicate.instance, true);
        this.onames = new OrderedMap(LexicographicPredicate.instance, true);
        this.modules = new ConcurrentHashMap(150);
        this.moduleIDs = new ConcurrentHashMap(150);
        this.importedModuleIDs = new ConcurrentHashMap(100);
        if (withIETF) {
            this.addIETFObjectIDs();
        }
        this.structureChanged();
    }

    public void clear() {
        this.oids.clear();
        this.onames.clear();
        this.modules.clear();
        this.moduleIDs.clear();
        this.importedModuleIDs.clear();
        this.addIETFObjectIDs();
        this.structureChanged();
    }

    public int size() {
        return this.oids.size();
    }

    public int moduleCount() {
        return this.modules.size();
    }

    protected void addIETFObjectIDs() {
        for (int i = 0; i < SMI.rootOids.length; ++i) {
            MIBObject o = new MIBObject(new ObjectID(SMI.rootOids[i][1]), SMI.rootOids[i][0]);
            this.oids.add(o.getOid(), o);
            this.onames.add(o.getName(), o);
        }
    }

    private void addModule(MIBModule o) {
        this.modules.put(o.getModuleName(), o);
        this.moduleIDs.put(o.getModuleID(), o);
    }

    public synchronized void addObject(MIBObject o) {
        this.removeObject(o.getModuleID(), o);
        if (!o.getOid().isEmpty()) {
            this.oids.add(o.getOid(), o);
        }
        this.onames.add(o.getName(), o);
        if (o instanceof MIBModule) {
            this.addModule((MIBModule)o);
            ((MIBModule)o).add(o);
        } else {
            MIBModule m = this.moduleIDs.get(o.getModuleID());
            if (m != null) {
                m.add(o);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObject(MIBObject o, MIBModule module, boolean removeExisting) {
        MIBRepository mIBRepository = this;
        synchronized (mIBRepository) {
            MIBObject existing;
            if (removeExisting) {
                this.removeObject(o.getModuleID(), o);
            }
            if (!(o.getOid() == null || o.getOid().isEmpty() || (existing = (MIBObject)this.oids.get(o.getOid())) != null && existing.equals(o))) {
                this.oids.add(o.getOid(), o);
            }
            if ((existing = (MIBObject)this.onames.get(o.getName())) == null || !existing.equals(o)) {
                this.onames.add(o.getName(), o);
            }
        }
        if (o instanceof MIBModule) {
            this.addModule((MIBModule)o);
            ((MIBModule)o).add(o);
        } else {
            MIBModule m = module;
            if (m == null) {
                m = this.moduleIDs.get(o.getModuleID());
            }
            if (m != null) {
                m.add(o);
            }
        }
    }

    public synchronized void addObject(MIBObject o, boolean addModuleObjects) {
        this.addObject(o);
        if (o instanceof MIBModule) {
            MIBModule m = (MIBModule)o;
            for (MIBObject obj : m.objects.values()) {
                this.addObject(obj);
            }
        }
    }

    public void addAllObjects(MIBObject[] objects, MIBModule module, boolean removeExisting, Map<String, Integer> importedModules) {
        for (MIBObject o : objects) {
            this.addObject(o, module, removeExisting);
            if (module != null || !(o instanceof MIBModule)) continue;
            importedModules.put(o.getName(), o.getModuleID());
        }
        for (MIBObject o : objects) {
            if (!(o instanceof MIBObjectType)) continue;
            this.initColumnarObjectInfoOnTable((MIBObjectType)o);
        }
    }

    public void addAllObjects(MIBObject[] objects) {
        for (MIBObject object : objects) {
            this.addObject(object);
        }
        this.structureChanged();
    }

    public String getObjectName(ObjectID oid) {
        MIBObject o = (MIBObject)this.oids.get(oid);
        if (o != null) {
            return o.getName();
        }
        return null;
    }

    public String getUniqueObjectName(MIBObject o) {
        MIBObject[] objs = this.getObjectsByName(o.getName());
        if (objs == null || objs.length <= 1) {
            return o.getName();
        }
        String m = this.getModuleName(o.getModuleID());
        if (m == null) {
            return o.getName();
        }
        return m + "." + o.getName();
    }

    public ObjectID getObjectID(String name) {
        MIBObject o = (MIBObject)this.onames.get(name);
        if (o != null) {
            return o.getOid();
        }
        return null;
    }

    public ObjectID getObjectID(String moduleName, String name) {
        MIBModule m = this.getModule(moduleName);
        if (m == null) {
            return null;
        }
        MIBObject o = m.getObjectByName(name);
        if (o != null) {
            return o.getOid();
        }
        return null;
    }

    public MIBObject getObject(String moduleName, String name) {
        MIBModule m = this.getModule(moduleName);
        if (m == null) {
            MIBObject[] o;
            for (MIBObject mibObject : o = this.getObjectsByName(name)) {
                if (!moduleName.equals(this.getModuleName(mibObject.getModuleID()))) continue;
                return mibObject;
            }
            return null;
        }
        return m.getObjectByName(name);
    }

    public MIBObject getScopedObject(String moduleName, String name) {
        if (name.isEmpty()) {
            return null;
        }
        if (Character.isUpperCase(name.charAt(0)) && name.indexOf(46) > 0) {
            return this.getObject(name);
        }
        MIBModule m = this.getModule(moduleName);
        if (m == null) {
            MIBObject[] o;
            for (MIBObject mibObject : o = this.getObjectsByName(name)) {
                if (!moduleName.equals(this.getModuleName(mibObject.getModuleID()))) continue;
                return mibObject;
            }
            return null;
        }
        String source = m.getImportSource(name);
        if (source != null) {
            return this.getObject(source, name);
        }
        return m.getObjectByName(name);
    }

    public Vector<? extends MIBObject> getChildren(String objectName) {
        MIBObject o = (MIBObject)this.onames.get(objectName);
        if (o == null) {
            return null;
        }
        return this.getChildren(o);
    }

    public Vector<? extends MIBObject> getChildren(ObjectID oid) {
        return this.getChildren(oid, true);
    }

    public Vector<? extends MIBObject> getChildren(ObjectID oid, boolean uniqueOIDs) {
        Vector<MIBObject> retval = new Vector<MIBObject>();
        OrderedMapIterator it = this.oids.find(oid);
        if (it.atEnd()) {
            return retval;
        }
        MIBObject parent = (MIBObject)((Pair)it.get()).second;
        if (!parent.getOid().equals(oid)) {
            return retval;
        }
        it.advance();
        while (!it.atEnd()) {
            block7: {
                MIBObject child;
                block9: {
                    MIBObject o;
                    block8: {
                        child = (MIBObject)((Pair)it.get()).second;
                        if (child.getOid().equals(oid) || uniqueOIDs && !retval.isEmpty() && child.getOid().equals(((MIBObject)retval.lastElement()).getOid())) break block7;
                        if (!child.getOid().isChildOf(oid)) break block8;
                        retval.add(child);
                        break block9;
                    }
                    if (!oid.isRootOf(child.getOid())) break block9;
                    if (!retval.isEmpty() && (o = (MIBObject)retval.lastElement()).getOid().isRootOf(child.getOid())) break block7;
                    retval.addElement(child);
                }
                if (!oid.isRootOf(child.getOid())) {
                    return retval;
                }
            }
            it.advance();
        }
        return retval;
    }

    public Vector<? extends MIBObject> getChildren(MIBObject o) {
        return this.getChildren(o.getOid());
    }

    public void removeChildren(MIBObject o) {
        Vector<? extends MIBObject> v = this.getChildren(o);
        if (v == null) {
            return;
        }
        Enumeration<? extends MIBObject> en = v.elements();
        while (en.hasMoreElements()) {
            MIBObject obj = en.nextElement();
            this.removeObject(obj);
        }
    }

    public Vector<? extends MIBObject> getDescendants(MIBObject o) {
        Vector<MIBObject> v = new Vector<MIBObject>(10, 10);
        Vector<? extends MIBObject> childs = this.getChildren(o);
        if (childs == null) {
            return v;
        }
        Enumeration<? extends MIBObject> e = childs.elements();
        while (e.hasMoreElements()) {
            MIBObject current = e.nextElement();
            v.add(current);
            Vector<? extends MIBObject> desc = this.getDescendants(current);
            Enumeration<? extends MIBObject> d = desc.elements();
            while (d.hasMoreElements()) {
                v.add(d.nextElement());
            }
        }
        return v;
    }

    public boolean hasDescendants(MIBObject o) {
        if (o.getOid() == null) {
            return false;
        }
        ObjectID oid = o.getOid();
        OrderedMapIterator it = this.oids.find(oid);
        if (it.atEnd()) {
            return false;
        }
        MIBObject parent = (MIBObject)((Pair)it.get()).second;
        if (!parent.getOid().equals(oid)) {
            return false;
        }
        it.advance();
        while (!it.atEnd()) {
            MIBObject child = (MIBObject)((Pair)it.get()).second;
            if (!child.getOid().equals(oid)) {
                if (child.getOid().isChildOf(oid)) {
                    return true;
                }
                if (oid.isRootOf(child.getOid())) {
                    return true;
                }
                if (!oid.isRootOf(child.getOid())) {
                    return false;
                }
            }
            it.advance();
        }
        return false;
    }

    public MIBObject getParent(String objectName) {
        MIBObject o = (MIBObject)this.onames.get(objectName);
        if (o == null) {
            return null;
        }
        return this.getParent(o);
    }

    public MIBObject getNextParent(ObjectID oid) {
        if (oid.size() <= 1 || this.oids.find(oid) == null) {
            return null;
        }
        MIBObject ro = null;
        ObjectID id = ObjectID.trim(oid);
        while (ro == null && !id.isEmpty()) {
            ro = (MIBObject)this.oids.get(id);
            id = ObjectID.trim(id);
            id = ObjectID.trim(id);
        }
        return ro;
    }

    public MIBObject getParent(MIBObject o) {
        if (this.oids.find(o.getOid()) == null || o.getOid().isEmpty()) {
            return null;
        }
        ObjectID id = ObjectID.trim(o.getOid());
        MIBObject ro = null;
        while (ro == null && !id.isEmpty()) {
            ro = (MIBObject)this.oids.get(id);
            id = ObjectID.trim(id);
        }
        return ro;
    }

    public MIBObject getParentInSameModule(MIBObject o) {
        if (this.oids.find(o.getOid()) == null || o.getOid().isEmpty()) {
            return null;
        }
        ObjectID id = ObjectID.trim(o.getOid());
        MIBObject ro = null;
        while (!id.isEmpty()) {
            MIBObject[] pList;
            for (MIBObject mibObject : pList = this.getObjectsByOid(id)) {
                if (!mibObject.getModuleID().equals(o.getModuleID())) continue;
                ro = mibObject;
                break;
            }
            id = ObjectID.trim(id);
        }
        return ro;
    }

    public Pair getSplittedObjectID(ObjectID oid) throws ObjectIDFormatException {
        Pair pair = new Pair();
        OrderedMapIterator it = this.oids.lowerBound(oid);
        if (it.atEnd()) {
            return new Pair(oid, new ObjectID());
        }
        if (((Pair)it.get()).first.equals(oid)) {
            pair.first = oid;
            pair.second = new ObjectID();
            return pair;
        }
        it.retreat();
        if (it.atBegin() || it.get() == null) {
            return new Pair(oid, new ObjectID());
        }
        MIBObject parent = (MIBObject)((Pair)it.get()).second;
        if (!parent.getOid().isRootOf(oid)) {
            pair.first = oid;
            pair.second = new ObjectID();
            return pair;
        }
        pair.first = parent.getOid();
        pair.second = oid.getSuffix(oid.size() - parent.getOid().size());
        return pair;
    }

    public ObjectID[] getIndexObjectIDs(ObjectID oid) {
        try {
            Pair p = this.getSplittedObjectID(oid);
            ObjectID entry = ObjectID.trim((ObjectID)p.first);
            ObjectID index = (ObjectID)p.second;
            MIBObjectType ot = (MIBObjectType)this.getObject(entry);
            if (ot == null || !ot.hasIndexPart()) {
                return null;
            }
            IndexStruct[] is = ot.getIndexPart().getIndexStruct(this);
            return this.getIndexObjectIDs(index, is);
        }
        catch (ObjectIDFormatException oife) {
            return null;
        }
    }

    public ObjectID[] getIndexObjectIDs(ObjectID index, IndexStruct[] is) {
        try {
            ObjectID[] r = new ObjectID[is.length];
            for (int i = 0; i < is.length; ++i) {
                if (is[i].impliedLength) {
                    r[i] = index;
                    break;
                }
                r[i] = !is[i].impliedLength && is[i].minLength != is[i].maxLength ? index.getPrefix((int)index.getSubIDAsLong(0) + 1) : index.getPrefix(is[i].maxLength);
                index = index.getSuffix(index.size() - r[i].size());
            }
            return r;
        }
        catch (ObjectIDFormatException | ArrayIndexOutOfBoundsException oife) {
            return null;
        }
    }

    public MIBObject[] getObjectsByName(String name) {
        MIBObject[] objs = new MIBObject[this.onames.count(name)];
        if (objs.length == 0) {
            return objs;
        }
        OrderedMapIterator it = this.onames.lowerBound(name);
        for (int i = 0; !it.atEnd() && i < objs.length; ++i) {
            objs[i] = (MIBObject)((Pair)it.get()).second;
            it.advance();
        }
        return objs;
    }

    public MIBObject[] getObjectsByNamePrefix(String namePrefix, int maxCount) {
        MIBObject o;
        ArrayList<MIBObject> objs = new ArrayList<MIBObject>();
        OrderedMapIterator it = this.onames.lowerBound(namePrefix);
        for (int i = 0; !it.atEnd() && (maxCount > 0 || i < maxCount) && (o = (MIBObject)((Pair)it.get()).second).getName().startsWith(namePrefix); ++i) {
            objs.add(o);
            it.advance();
        }
        return objs.toArray(new MIBObject[0]);
    }

    public MIBObject[] getObjectsByOid(ObjectID oid) {
        MIBObject[] objs = new MIBObject[this.oids.count(oid)];
        if (objs.length == 0) {
            return objs;
        }
        OrderedMapIterator it = this.oids.lowerBound(oid);
        for (int i = 0; !it.atEnd() && i < objs.length; ++i) {
            objs[i] = (MIBObject)((Pair)it.get()).second;
            it.advance();
        }
        return objs;
    }

    public synchronized void remove(MIBModule m) {
        MIBObject o;
        this.modules.remove(m.getModuleName());
        this.moduleIDs.remove(m.getModuleID());
        OrderedMapIterator it = this.oids.begin();
        while (!it.atEnd()) {
            o = (MIBObject)((Pair)it.get()).second;
            if (o != null && o.getModuleID().equals(m.getModuleID())) {
                this.oids.remove(it);
                it = this.oids.lowerBound(o.getOid());
                continue;
            }
            it.advance();
        }
        it = this.onames.begin();
        while (!it.atEnd()) {
            o = (MIBObject)((Pair)it.get()).second;
            if (o != null && o.getModuleID().equals(m.getModuleID())) {
                this.onames.remove(it);
                it = this.onames.lowerBound(o.getName());
                continue;
            }
            it.advance();
        }
    }

    public Map<String, String> getImportDependencies(Collection<String> importingModules, String importedModuleFilter) {
        HashMap<String, String> importMap = new HashMap<String, String>();
        for (String moduleName : importingModules) {
            MIBModule mibModule = this.getModule(moduleName);
            if (mibModule == null) continue;
            if (importedModuleFilter != null) {
                MIBImport mibImport = mibModule.getImports(importedModuleFilter);
                if (mibImport == null) continue;
                for (String importedObject : mibImport.getImportsVector()) {
                    importMap.put(importedObject, moduleName);
                }
                continue;
            }
            if (mibModule.getImportsVector() == null) continue;
            for (MIBImport mibImport : mibModule.getImportsVector()) {
                if (mibImport == null) continue;
                for (String importedObject : mibImport.getImportsVector()) {
                    importMap.put(importedObject, moduleName);
                }
            }
        }
        return importMap;
    }

    public synchronized int remove(MIBModule moduleToRemove, Collection<String> modulesToRetain) {
        MIBObject o;
        int numRemoved = 0;
        this.modules.remove(moduleToRemove.getModuleName());
        this.moduleIDs.remove(moduleToRemove.getModuleID());
        Map<String, String> retainMap = this.getImportDependencies(modulesToRetain, null);
        OrderedMapIterator it = this.oids.begin();
        while (!it.atEnd()) {
            o = (MIBObject)((Pair)it.get()).second;
            if (o != null && !retainMap.containsKey(o.getName())) {
                if (o.getModuleID().equals(moduleToRemove.getModuleID()) || moduleToRemove.imports(o.getName()) && !retainMap.containsKey(o.getName())) {
                    this.oids.remove(it);
                    it = this.oids.lowerBound(o.getOid());
                    continue;
                }
                it.advance();
                continue;
            }
            it.advance();
        }
        it = this.onames.begin();
        while (!it.atEnd()) {
            o = (MIBObject)((Pair)it.get()).second;
            if (o != null && !retainMap.containsKey(o.getName())) {
                if (o.getModuleID().equals(moduleToRemove.getModuleID()) || moduleToRemove.imports(o.getName())) {
                    if (this.onames.remove(it) != null) {
                        ++numRemoved;
                    }
                    it = this.onames.lowerBound(o.getName());
                    continue;
                }
                it.advance();
                continue;
            }
            it.advance();
        }
        return numRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(Integer moduleID, MIBObject o) {
        MIBObject obj;
        MIBObject match;
        MIBRepository mIBRepository;
        MIBModule m;
        if (moduleID != null && (m = this.moduleIDs.get(moduleID)) != null) {
            m.remove(o);
        }
        if (o.getOid() != null && !o.getOid().isEmpty()) {
            mIBRepository = this;
            synchronized (mIBRepository) {
                match = (MIBObject)this.oids.get(o.getOid());
                if (match != null) {
                    OrderedMapIterator it = this.oids.lowerBound(o.getOid());
                    while (!it.atEnd() && (obj = (MIBObject)((Pair)it.get()).second).getOid().equals(o.getOid())) {
                        if (obj.getModuleID().equals(moduleID) && obj.getName().equals(o.getName())) {
                            this.oids.remove(it);
                            break;
                        }
                        it.advance();
                    }
                }
            }
        }
        mIBRepository = this;
        synchronized (mIBRepository) {
            match = (MIBObject)this.onames.get(o.getName());
            if (match != null) {
                OrderedMapIterator nit = this.onames.lowerBound(o.getName());
                while (!nit.atEnd() && (obj = (MIBObject)((Pair)nit.get()).second).getName().equals(o.getName())) {
                    if (obj.getModuleID().equals(moduleID) && (o.getOid() == null && obj.getOid() == null || o.getOid() != null && o.getOid().equals(obj.getOid()))) {
                        this.onames.remove(nit);
                        break;
                    }
                    nit.advance();
                }
            }
        }
        if (o instanceof MIBModule) {
            this.modules.remove(((MIBModule)o).getModuleName());
            this.moduleIDs.remove(o.getModuleID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(MIBObject o) {
        if (o.getModuleID() != null) {
            this.removeObject(o.getModuleID(), o);
        } else {
            MIBRepository mIBRepository = this;
            synchronized (mIBRepository) {
                this.oids.remove(o.getOid());
                this.onames.remove(o.getName());
            }
        }
    }

    public synchronized boolean removeModule(String moduleName) {
        MIBModule o = this.modules.get(moduleName);
        if (o != null) {
            this.remove(o);
            return true;
        }
        return false;
    }

    public MIBModule getModule(String moduleName) {
        return this.modules.get(moduleName);
    }

    public MIBModule getModule(Integer moduleID) {
        return this.moduleIDs.get(moduleID);
    }

    public MIBObject getObject(String name) {
        String[] names = MIBRepository.splitObjectName(name);
        if (names[0] != null) {
            return this.getObject(names[0], names[1]);
        }
        return (MIBObject)this.onames.get(names[1]);
    }

    private static String[] splitObjectName(String name) {
        if (name != null && name.length() > 2 && Character.isUpperCase(name.charAt(0)) && name.indexOf(46) > 0) {
            String moduleName = name.substring(0, name.indexOf(46));
            String objectName = name.substring(name.indexOf(46) + 1);
            return new String[]{moduleName, objectName};
        }
        return new String[]{null, name};
    }

    public MIBObject getObject(ObjectID oid) {
        return (MIBObject)this.oids.get(oid);
    }

    public Enumeration<MIBModule> modules() {
        return new EnumerationIterator<MIBModule>(this.modules.values().iterator());
    }

    public Iterator<MIBModule> modulesIterator() {
        return this.modules.values().iterator();
    }

    public Enumeration<? extends MIBModule> getModulesSortedByName() {
        OrderedMap map = new OrderedMap(LexicographicPredicate.instance);
        Enumeration<MIBModule> e = this.modules();
        while (e.hasMoreElements()) {
            MIBModule module = e.nextElement();
            map.put(module.getModuleName(), module);
        }
        return map.elements();
    }

    public Vector<String> getModuleNames() {
        Vector<String> v = new Vector<String>(this.modules.size() + 1);
        for (MIBModule m : this.modules.values()) {
            v.add(m.getModuleName());
        }
        return v;
    }

    public Enumeration<? extends MIBObject> objects() {
        return this.oids.elements();
    }

    public Enumeration<? extends MIBObject> objectsByName() {
        return this.onames.elements();
    }

    public OrderedMapIterator find(ObjectID oid) {
        return this.oids.find(oid);
    }

    public OrderedMapIterator firstOID() {
        return this.oids.begin();
    }

    private void addToModule(MIBObject o) throws ObjectIDFormatException {
        MIBModule m = this.moduleIDs.get(o.getModuleID());
        if (m != null) {
            m.add(o);
        }
        if (o instanceof MIBObjectType) {
            this.initColumnarObjectInfoOnTable((MIBObjectType)o);
        }
    }

    private void initColumnarObjectInfoOnTable(MIBObjectType ot) {
        if (ot.isTable()) {
            Object[] cols = ot.getTableEntries();
            Arrays.sort(cols);
            Vector<? extends MIBObject> children = this.getChildren(ot);
            for (MIBObject mIBObject : children) {
                MIBObjectType c;
                if (!(mIBObject instanceof MIBObjectType)) continue;
                c.setColumnarObject(Arrays.binarySearch(cols, (c = (MIBObjectType)mIBObject).getName()) >= 0);
            }
        }
    }

    public synchronized void structureChanged() {
        Enumeration e = this.oids.elements();
        while (e.hasMoreElements()) {
            MIBObject o = (MIBObject)e.nextElement();
            try {
                this.addToModule(o);
            }
            catch (ObjectIDFormatException ofe) {
                System.out.println("Repository: could not add object " + o.getName() + " because of invalid oid " + o.getOid().toString() + ".");
            }
        }
        MIBObject dummy = new MIBObject();
        Enumeration e2 = this.onames.elements();
        while (e2.hasMoreElements()) {
            MIBObject o = (MIBObject)e2.nextElement();
            if (!(o instanceof MIBTextualConvention) && !o.getClass().equals(dummy.getClass())) continue;
            try {
                this.addToModule(o);
            }
            catch (ObjectIDFormatException ofe) {
                System.out.println("Repository: could not add object " + o.getName() + " because of invalid oid " + o.getOid().toString() + ".");
            }
        }
    }

    public String getPath(ObjectID oid, boolean withID) {
        StringBuilder oidbuf = new StringBuilder();
        StringBuilder namebuf = new StringBuilder();
        if (oid == null) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(oid.toString(), ".", false);
        int length = st.countTokens();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                oidbuf.append(".");
                namebuf.append(".");
            }
            String subid = st.nextToken();
            oidbuf.append(subid);
            String oidStr = oidbuf.toString();
            String name = this.getObjectName(new ObjectID(oidStr));
            if (name == null && "1".equals(oidStr)) {
                name = "iso";
            }
            if (name == null) {
                namebuf.append(subid);
                continue;
            }
            if (withID) {
                namebuf.append(name);
                namebuf.append('(');
                namebuf.append(subid);
                namebuf.append(')');
                continue;
            }
            namebuf.append(name);
        }
        return namebuf.toString();
    }

    public String getPath(ObjectID oid) {
        return this.getPath(oid, false);
    }

    public String getPathSuffix(ObjectID oid) {
        return this.getPathSuffix(oid, false);
    }

    public String getPathSuffix(ObjectID oid, boolean unique) {
        String m;
        MIBObject[] objs;
        MIBObject o;
        StringBuilder oidbuf = new StringBuilder();
        StringBuilder namebuf = new StringBuilder();
        if (oid == null) {
            return "";
        }
        ObjectID lastObjectID = null;
        StringTokenizer st = new StringTokenizer(oid.toString(), ".", false);
        int length = st.countTokens();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                oidbuf.append(".");
                namebuf.append(".");
            }
            String subid = st.nextToken();
            oidbuf.append(subid);
            ObjectID subOID = new ObjectID(oidbuf.toString());
            String name = this.getObjectName(subOID);
            if (name == null) {
                namebuf.append(subid);
                continue;
            }
            namebuf = new StringBuilder(name);
            lastObjectID = subOID;
        }
        if (unique && lastObjectID != null && (o = this.getObject(lastObjectID)) != null && (objs = this.getObjectsByName(o.getName())) != null && objs.length > 1 && (m = this.getModuleName(o.getModuleID())) != null) {
            namebuf = new StringBuilder(m + "." + namebuf.toString());
        }
        return namebuf.toString();
    }

    public static MIBRepository loadFromFile(File path) {
        MIBRepository rep = null;
        try {
            FileInputStream file = new FileInputStream(path);
            ObjectInputStream input = new ObjectInputStream(file);
            rep = new MIBRepository();
            int sz = input.readInt();
            for (int i = 0; i < sz; ++i) {
                MIBObject obj = (MIBObject)input.readObject();
                if (obj instanceof MIBModule) {
                    ((MIBModule)obj).reinit();
                }
                rep.addObject(obj);
            }
            input.close();
            rep.structureChanged();
        }
        catch (FileNotFoundException ex) {
            System.out.println("MIB repository " + path + " not found.");
        }
        catch (StreamCorruptedException sce) {
            System.out.println("MIB repository " + path + " corrupted.");
        }
        catch (IOException ioe) {
            System.out.println("IO error while reading MIB repository " + path + ".");
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("Class not found (" + cnfe.getMessage() + ") while reading MIB repository " + path + ".");
        }
        return rep;
    }

    public static boolean saveToFile(MIBRepository rep, File path) {
        try {
            FileOutputStream file = new FileOutputStream(path);
            ObjectOutputStream output = new ObjectOutputStream(file);
            Vector<? extends MIBTextualConvention> v = rep.getTextualConventions();
            output.writeInt(rep.oids.size() + v.size());
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                output.writeObject(e.nextElement());
            }
            e = rep.oids.elements();
            while (e.hasMoreElements()) {
                output.writeObject(e.nextElement());
            }
            output.flush();
            output.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return false;
        }
        return true;
    }

    public Vector<? extends MIBTextualConvention> getTextualConventions() {
        return this.getNonOidObjects(true);
    }

    public Vector<? extends MIBObject> getNonOidObjects(boolean textualConventionsOnly) {
        Vector<MIBObject> v = new Vector<MIBObject>(this.onames.size() / 50, 50);
        Enumeration e = this.onames.elements();
        while (e.hasMoreElements()) {
            MIBObject o = (MIBObject)e.nextElement();
            if ((textualConventionsOnly || !o.getOid().isEmpty()) && !(o instanceof MIBTextualConvention)) continue;
            v.add(o);
        }
        return v;
    }

    public MIBSyntax resolveTC(String name) {
        MIBObject o;
        MIBSyntax syn = null;
        while ((o = (MIBObject)this.onames.get(name)) != null) {
            if (o instanceof MIBTextualConvention) {
                MIBTextualConvention tc = (MIBTextualConvention)o;
                if (tc.getSyntax().getType() == 3) {
                    syn = tc.getSyntax();
                    name = tc.getSyntax().getSyntax();
                    continue;
                }
                return tc.getSyntax();
            }
            return syn;
        }
        return syn;
    }

    public ObjectID resolveOID(ObjectID oid) {
        String name = oid.getFirstUnresolvedSubId();
        if (name == null) {
            return oid;
        }
        ObjectID id = this.getObjectID(name);
        if (id != null) {
            int start = oid.toString().indexOf(name) + name.length();
            String r = id.toString();
            if (start >= 0 && start < oid.toString().length()) {
                r = r + oid.toString().substring(start);
            }
            return new ObjectID(r);
        }
        return null;
    }

    public MIBSyntax getBaseSyntax(MIBSyntax syntax) {
        MIBSyntax s = syntax;
        if (s.getType() == 3) {
            try {
                MIBTextualConvention tc = (MIBTextualConvention)this.getObject(s.getSyntax());
                if (tc != null) {
                    s = tc.getSyntax();
                }
            }
            catch (ClassCastException cce) {
                return s;
            }
        }
        return s;
    }

    private MIBObject getBestObject(String syntax) {
        Range r = this.onames.equalRange(syntax);
        if (r == null || r.begin.atEnd()) {
            return null;
        }
        MIBObject best = null;
        MIBObject second = null;
        while (r.begin.hasMoreElements()) {
            if (((Pair)r.begin.get()).first.equals(syntax)) {
                MIBObject o = (MIBObject)((Pair)r.begin.get()).second;
                MIBModule m = this.getModule(o.getModuleID());
                if (m != null && m.getSMIVersion() > 1) {
                    best = o;
                    break;
                }
                second = o;
            }
            r.begin.advance();
        }
        return best != null ? best : second;
    }

    public MIBTextualConvention getEffectiveSyntax(MIBSyntax syntax) {
        return this.getEffectiveSyntax((ISyntax)syntax);
    }

    public MIBTextualConvention getEffectiveSyntax(ISyntax syntax) {
        MIBObject o;
        MIBSyntax effectiveSyntax = new MIBSyntax();
        ISyntax syn = syntax;
        MIBTextualConvention eTC = new MIBTextualConvention();
        if (syntax.hasEnums()) {
            effectiveSyntax.setEnums((MIBEnum[])syn.getEnums());
        }
        if (syntax.hasRanges()) {
            effectiveSyntax.setRanges((MIBRange[])syn.getRanges());
        }
        eTC.setSyntax(effectiveSyntax);
        while ((o = this.getBestObject(syn.getSyntax())) != null) {
            if (o instanceof MIBTextualConvention) {
                Enumeration<Serializable> en;
                MIBTextualConvention tc = (MIBTextualConvention)o;
                if (eTC.getName() == null) {
                    eTC.setName(tc.getName());
                }
                if (tc.hasDisplayHint()) {
                    eTC.setDisplayHint(tc.getDisplayHint());
                }
                if (tc.getSyntax().hasEnums()) {
                    en = tc.getSyntax().getEnumsVector().elements();
                    while (en.hasMoreElements()) {
                        MIBEnum e = en.nextElement();
                        if (!effectiveSyntax.hasEnums()) {
                            effectiveSyntax.addEnum(new MIBEnum(e));
                            continue;
                        }
                        effectiveSyntax.getEnumsVector().removeElement(e);
                        effectiveSyntax.addEnum(new MIBEnum(e));
                    }
                } else if (tc.getSyntax().hasRanges()) {
                    en = tc.getSyntax().getRangesVector().elements();
                    while (en.hasMoreElements()) {
                        MIBRange r = (MIBRange)en.nextElement();
                        if (effectiveSyntax.containsRange(r) || !effectiveSyntax.isRestrictiveRange(r)) continue;
                        effectiveSyntax.addRange(r);
                    }
                }
                if (tc.getSyntax().getType() == 3) {
                    syn = tc.getSyntax();
                    continue;
                }
                effectiveSyntax.setSyntax(tc.getSyntax().getSyntax());
                effectiveSyntax.setType(tc.getSyntax().getType());
                return eTC;
            }
            return eTC;
        }
        effectiveSyntax.setSyntax(syn.getSyntax());
        effectiveSyntax.setType(syn.getType());
        return eTC;
    }

    public boolean isReferencedBy(String objectName, MIBModule module, MIBComplianceModule complianceModule) {
        MIBGroup group;
        IObject o;
        String[] names = MIBRepository.splitObjectName(objectName);
        String moduleName = names[0];
        String oname = names[1];
        if (moduleName != null && (module.getModuleName() != null ? !moduleName.equals(module.getModuleName()) : !moduleName.equals(module.getModuleName()))) {
            return false;
        }
        MIBModule m = module;
        if (complianceModule.hasMandatory()) {
            for (String groupName : complianceModule.getMandatoryVector()) {
                o = m.getObject(groupName);
                if (!(o instanceof MIBGroup) || !(group = (MIBGroup)o).contains(oname)) continue;
                return true;
            }
        }
        if (complianceModule.hasVariations()) {
            for (MIBVariation v : complianceModule.getVariationsVector()) {
                if (!(v instanceof MIBCondGroup) || !((o = m.getObject(v.getVariation())) instanceof MIBGroup) || !(group = (MIBGroup)o).contains(oname)) continue;
                return true;
            }
        }
        return false;
    }

    public String printModule(String moduleName) {
        MIBModule m = this.getModule(moduleName);
        if (m == null) {
            return "";
        }
        return m.toSMI(1, this, MIBObject.getLineSeparator());
    }

    public static <T> Vector<T> buildVector(T[] objects) {
        if (objects == null) {
            return null;
        }
        Vector<T> v = new Vector<T>(objects.length > 0 ? objects.length : 1);
        v.addAll(Arrays.asList(objects));
        return v;
    }

    public static String buildStringEnumeration(Enumeration en, String prefix) {
        StringBuilder buf = new StringBuilder();
        while (en.hasMoreElements()) {
            buf.append(prefix).append(en.nextElement().toString());
            if (!en.hasMoreElements()) continue;
            buf.append(",\n");
        }
        return buf.toString();
    }

    public static String buildStringEnumeration(Iterator it, String prefix) {
        StringBuilder buf = new StringBuilder();
        while (it.hasNext()) {
            buf.append(prefix + it.next().toString());
            if (!it.hasNext()) continue;
            buf.append(",\n");
        }
        return buf.toString();
    }

    public static String buildStringEnumeration(Enumeration en) {
        StringBuilder buf = new StringBuilder();
        while (en.hasMoreElements()) {
            buf.append((String)en.nextElement());
            if (!en.hasMoreElements()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public void renameModule(MIBModule oldModule, String newModuleName) {
        this.modules.remove(oldModule.getModuleName());
        oldModule.setModuleName(newModuleName);
        this.modules.put(newModuleName, oldModule);
    }

    public void renameObject(MIBObject oldObject, ObjectID newObjectID, String newObjectName) {
        if (!oldObject.getName().equals(newObjectName)) {
            if (oldObject.getModuleID() != null) {
                MIBModule m = this.moduleIDs.get(oldObject.getModuleID());
                if (m != null) {
                    m.remove(oldObject);
                    if (!oldObject.getName().equals(newObjectName)) {
                        m.changeObjectReferences(oldObject.getName(), newObjectName);
                    }
                }
                OrderedMapIterator it = this.onames.begin();
                while (it.hasMoreElements()) {
                    MIBObject o = (MIBObject)((Pair)it.get()).second;
                    if (o.equals(oldObject)) {
                        this.onames.remove(it);
                        break;
                    }
                    it.advance();
                }
            }
            oldObject.setName(newObjectName);
            this.onames.add(newObjectName, oldObject);
        }
        if (!oldObject.getOid().equals(newObjectID)) {
            OrderedMapIterator it = this.oids.begin();
            while (it.hasMoreElements()) {
                MIBObject o = (MIBObject)((Pair)it.get()).second;
                if (o == oldObject) {
                    this.oids.remove(it);
                    break;
                }
                it.advance();
            }
            oldObject.setOid(newObjectID);
            this.oids.add(newObjectID, oldObject);
        }
    }

    public Vector<MIBObjectType> getColumnarObjectsOfTable(MIBModule m, MIBObjectType ot, boolean includeIndex, boolean includeColumns) {
        Object o;
        if (ot == null || !ot.isTable()) {
            return null;
        }
        Vector<MIBObjectType> v = new Vector<MIBObjectType>();
        if (m == null) {
            return null;
        }
        if (includeIndex) {
            MIBObjectType iot = ot;
            if (ot.getIndexPart().isAugment()) {
                int i;
                o = this.getObjectsByName(ot.getIndexPart().getIndexPart()[0]);
                Object found = null;
                for (i = 0; i < ((MIBObject[])o).length; ++i) {
                    if (!((MIBObject)o[i]).getModuleID().equals(ot.getModuleID())) continue;
                    found = o[i];
                    break;
                }
                if (found == null) {
                    for (i = 0; i < ((Object)o).length; ++i) {
                        String mi = this.getModuleName(((MIBObject)o[i]).getModuleID());
                        if (mi == null || !m.imports(((MIBObject)o[i]).getName(), mi)) continue;
                        found = o[i];
                        break;
                    }
                } else if (((Object)o).length == 1) {
                    found = o[0];
                }
                iot = (MIBObjectType)found;
            }
            if (iot != null && iot.hasIndexPart()) {
                Enumeration en = iot.getIndexPart().getIndexPartVector().elements();
                while (en.hasMoreElements()) {
                    MIBObject[] o2 = this.getObjectsByName((String)en.nextElement());
                    MIBObject found = null;
                    if (o2.length > 1) {
                        for (MIBObject mibObject : o2) {
                            if (!mibObject.getModuleID().equals(ot.getModuleID()) || !(mibObject instanceof MIBObjectType)) continue;
                            found = mibObject;
                            break;
                        }
                        if (found == null) {
                            for (MIBObject mibObject : o2) {
                                MIBModule mi = this.getModule(mibObject.getModuleID());
                                if (mi == null || !m.imports(mibObject.getName(), mi.getModuleName()) || !(mibObject instanceof MIBObjectType)) continue;
                                found = mibObject;
                                break;
                            }
                        }
                    } else if (o2.length == 1) {
                        found = o2[0];
                    }
                    if (found == null) continue;
                    v.add((MIBObjectType)found);
                }
            } else {
                return null;
            }
        }
        if (includeColumns) {
            Enumeration en = ot.getTableEntriesVector().elements();
            while (en.hasMoreElements()) {
                o = (MIBObjectType)this.getObject(m.getModuleName(), (String)en.nextElement());
                if (o == null || SMI.accessType(((MIBObjectType)o).getAccess()) == 0) continue;
                v.add((MIBObjectType)o);
            }
        }
        return v;
    }

    public Vector<? extends MIBObjectType> getColumnarObjectsOfTable(MIBObjectType ot, boolean includeIndex, boolean includeColumns) {
        MIBModule m = this.getModule(ot.getModuleID());
        return this.getColumnarObjectsOfTable(m, ot, includeIndex, includeColumns);
    }

    public List<MIBObject> getNotificationObjects(INotificationType nt) {
        MIBModule m = this.getModule(nt.getModuleID());
        return this.getNotificationObjects(m, nt);
    }

    public List<MIBObject> getNotificationObjects(MIBModule module, INotificationType nt) {
        ArrayList<MIBObject> result = new ArrayList<MIBObject>();
        if (nt.getVariablesVector() == null) {
            return result;
        }
        for (String object : nt.getVariablesVector()) {
            MIBObject[] o = this.getObjectsByName(object);
            MIBObject found = null;
            if (o.length > 1) {
                for (int i = 0; i < o.length; ++i) {
                    if (!o[i].getModuleID().equals(nt.getModuleID())) continue;
                    found = o[i];
                    break;
                }
                if (found == null) {
                    for (MIBObject mibObject : o) {
                        MIBModule mi = this.getModule(mibObject.getModuleID());
                        if (mi == null || !module.imports(mibObject.getName(), mi.getModuleName())) continue;
                        found = mibObject;
                        break;
                    }
                }
            } else if (o.length == 1) {
                found = o[0];
            }
            if (found != null) {
                result.add(found);
                continue;
            }
            result.add(null);
        }
        return result;
    }

    public Vector<? extends MIBObjectType> getAugmentingTables(MIBObjectType table) {
        MIBModule module = this.getModule(table.getModuleID());
        Vector<MIBObjectType> v = new Vector<MIBObjectType>();
        Enumeration<? extends MIBObject> en = this.objects();
        while (en.hasMoreElements()) {
            MIBObjectType ot;
            MIBObject o = en.nextElement();
            if (!(o instanceof MIBObjectType) || !(ot = (MIBObjectType)o).isTable() || !ot.hasIndexPart() || !ot.getIndexPart().isAugment() || !ot.getIndexPart().getIndexPart()[0].equals(table.getName())) continue;
            this.getParentTables(table, module, v, ot);
        }
        return v;
    }

    public boolean isExpandingIndex(MIBIndexPart parent, MIBIndexPart expansion) {
        if (parent == null || expansion == null) {
            return false;
        }
        Vector parentIndex = parent.getIndexPartVector();
        Vector expansionIndex = expansion.getIndexPartVector();
        if (expansionIndex.size() < parentIndex.size()) {
            return false;
        }
        for (int i = 0; i < parentIndex.size(); ++i) {
            if (parentIndex.elementAt(i).equals(expansionIndex.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public Vector<? extends MIBObjectType> getParentTables(MIBObjectType table) {
        MIBModule module = this.getModule(table.getModuleID());
        Vector<MIBObjectType> v = new Vector<MIBObjectType>();
        Enumeration<? extends MIBObject> en = this.objects();
        while (en.hasMoreElements()) {
            MIBObject o = en.nextElement();
            if (!(o instanceof MIBObjectType)) continue;
            MIBObjectType ot = (MIBObjectType)o;
            if (ot.isTable() && ot.hasIndexPart() && ot.getIndexPart().isAugment() && ot.getIndexPart().getIndexPart()[0].equals(table.getName())) {
                this.getParentTables(table, module, v, ot);
                continue;
            }
            if (!ot.isTable() || !ot.hasIndexPart() || ot.getName().equals(table.getName()) || !this.isExpandingIndex(ot.getIndexPart(), table.getIndexPart())) continue;
            v.addElement(ot);
        }
        return v;
    }

    private void getParentTables(MIBObjectType table, MIBModule module, Vector<MIBObjectType> parentTableObjectTypes, MIBObjectType parentTableObjectType) {
        MIBModule m = this.getModule(parentTableObjectType.getModuleID());
        if (module != null && m != null) {
            if (m.getModuleID().equals(module.getModuleID()) || m.imports(table.getName(), module.getModuleName())) {
                parentTableObjectTypes.addElement(parentTableObjectType);
            }
        } else {
            parentTableObjectTypes.addElement(parentTableObjectType);
        }
    }

    public MIBObjectType getObjectType(ObjectID instanceID) {
        try {
            Pair p = this.getSplittedObjectID(instanceID);
            if (p == null) {
                return null;
            }
            ObjectID oid = (ObjectID)p.first;
            MIBObject o = this.getObject(oid);
            if (o instanceof MIBObjectType) {
                return (MIBObjectType)o;
            }
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            // empty catch block
        }
        return null;
    }

    public MIBObjectType getTableEntry(MIBObject o) {
        if (o instanceof MIBObjectType) {
            MIBObjectType ot = (MIBObjectType)o;
            if (ot.isTable()) {
                return ot;
            }
            Vector<? extends MIBObject> v = this.getChildren(ot);
            if (v.size() == 0) {
                return null;
            }
            MIBObject entry = v.firstElement();
            if (entry instanceof MIBObjectType && ((MIBObjectType)entry).isTable()) {
                return (MIBObjectType)entry;
            }
        }
        return null;
    }

    public MIBObject getNextObject(ObjectID oid) {
        OrderedMapIterator it = this.oids.lowerBound(oid);
        while (!it.atEnd()) {
            MIBObject obj = (MIBObject)((Pair)it.get()).second;
            if (!obj.getOid().equals(oid)) {
                return obj;
            }
            it.advance();
        }
        return null;
    }

    public MIBObject getPrevObject(ObjectID oid) {
        MIBObject obj;
        OrderedMapIterator it = this.oids.upperBound(oid);
        while (!(it.atBegin() || it.get() != null && (obj = (MIBObject)((Pair)it.get()).second).getOid().equals(oid))) {
            it.retreat();
        }
        while (!it.atEnd() && !it.atBegin()) {
            obj = (MIBObject)((Pair)it.get()).second;
            if (!obj.getOid().equals(oid)) {
                return obj;
            }
            it.retreat();
        }
        return null;
    }

    public MIBObject getNextSiblingObject(ObjectID oid) {
        OrderedMapIterator it = this.oids.lowerBound(oid);
        while (!it.atEnd()) {
            MIBObject obj = (MIBObject)((Pair)it.get()).second;
            if (!obj.getOid().equals(oid) && obj.getOid().isPeerOf(oid)) {
                return obj;
            }
            it.advance();
        }
        return null;
    }

    public MIBObject getPrevSibblingObject(ObjectID oid) {
        MIBObject obj;
        OrderedMapIterator it = this.oids.upperBound(oid);
        if (!it.atBegin() && it.atEnd()) {
            it.retreat();
        }
        while (!it.atBegin() && !(obj = (MIBObject)((Pair)it.get()).second).getOid().equals(oid)) {
            it.retreat();
        }
        while (!it.atBegin()) {
            obj = (MIBObject)((Pair)it.get()).second;
            if (!obj.getOid().equals(oid) && obj.getOid().isPeerOf(oid)) {
                return obj;
            }
            it.retreat();
        }
        return null;
    }

    private static <K, V> Map<V, K> invertMap(Map<K, V> map) {
        HashMap<V, K> invertedMap = new HashMap<V, K>(map.size());
        for (K key : map.keySet()) {
            V value = map.get(key);
            invertedMap.put(value, key);
        }
        return invertedMap;
    }

    public Map<Integer, String> getImportedModuleIDs() {
        return this.importedModuleIDs;
    }

    public Map<Integer, String> addImportedModuleIDsInverted(Map<String, Integer> moduleIDs) {
        Map<Integer, String> h = MIBRepository.invertMap(moduleIDs);
        this.addImportedModuleIDs(h);
        return h;
    }

    public void removeImportedModuleID(Integer moduleID) {
        this.importedModuleIDs.remove(moduleID);
    }

    public void addImportedModuleIDs(Map<Integer, String> moduleIDs) {
        this.importedModuleIDs.putAll(moduleIDs);
    }

    public String getModuleName(Integer moduleID) {
        MIBModule o = this.moduleIDs.get(moduleID);
        if (o != null) {
            return o.getModuleName();
        }
        return this.importedModuleIDs.get(moduleID);
    }

    public void freeUserObjects() {
        Enumeration<? extends MIBObject> it = this.objectsByName();
        while (it.hasMoreElements()) {
            MIBObject o = it.nextElement();
            o.freeUserObjects();
        }
    }
}

