/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.smi.ext.SMIRange;
import com.agentpp.smiparser.SMI;
import java.io.Serializable;
import java.util.Collections;
import java.util.Vector;

public class MIBRange
implements Serializable,
SMIRange,
Comparable {
    public static final long serialVersionUID = 1000L;
    protected Long lower = null;
    protected Long upper = null;

    public MIBRange() {
    }

    public MIBRange(long lower, long upper) {
        this.lower = new Long(lower);
        this.upper = new Long(upper);
    }

    public MIBRange(String lower, String upper) {
        this.lower = new Long(SMI.parseLongConstant(lower));
        this.upper = new Long(SMI.parseLongConstant(upper));
    }

    @Override
    public Long getLower() {
        return this.lower;
    }

    @Override
    public Long getUpper() {
        return this.upper;
    }

    public void setLower(long l) {
        this.lower = new Long(l);
    }

    public void setUpper(long u) {
        this.upper = new Long(u);
    }

    @Override
    public void setLowerValue(long l) {
        this.lower = new Long(l);
    }

    @Override
    public void setUpperValue(long u) {
        this.upper = new Long(u);
    }

    @Override
    public long getLowerValue() {
        return this.lower;
    }

    @Override
    public long getUpperValue() {
        return this.upper;
    }

    public String toSMI(int mode) {
        StringBuffer buf = new StringBuffer();
        if (this.lower.equals(this.upper)) {
            MIBObject.addNum(mode, buf, this.upper);
        } else {
            MIBObject.addNum(mode, buf, this.lower);
            buf.append("..");
            MIBObject.addNum(mode, buf, this.upper);
        }
        return buf.toString();
    }

    public String toString() {
        return this.toSMI(1);
    }

    public boolean equals(Object o) {
        if (o instanceof MIBRange) {
            return this.lower.equals(((MIBRange)o).lower) && this.upper.equals(((MIBRange)o).upper);
        }
        return false;
    }

    public static boolean normalizeRanges(Vector in, Vector normalized) {
        boolean isAlreadyNormalized = true;
        for (MIBRange r : in) {
            boolean add = true;
            for (MIBRange nr : normalized) {
                if (nr.getLowerValue() > r.getLowerValue() || nr.getUpperValue() < r.getUpperValue()) {
                    if (nr.getUpperValue() < r.getLowerValue() || nr.getLowerValue() > r.getUpperValue()) continue;
                    nr.setLowerValue(Math.min(nr.getLowerValue(), r.getLowerValue()));
                    nr.setUpperValue(Math.min(nr.getUpperValue(), r.getUpperValue()));
                    add = false;
                    continue;
                }
                add = false;
            }
            if (add) {
                normalized.add(new MIBRange(r.getLowerValue(), r.getUpperValue()));
                continue;
            }
            isAlreadyNormalized = false;
        }
        return isAlreadyNormalized;
    }

    public static int compareRanges(Vector a, Vector b) {
        if (a.size() == 0 && b.size() > 0) {
            return 1;
        }
        if (a.size() > 0 && b.size() == 0) {
            return -1;
        }
        Collections.sort(a);
        Collections.sort(b);
        for (int i = 0; i < Math.min(a.size(), b.size()); ++i) {
            MIBRange ra = (MIBRange)a.get(i);
            MIBRange rb = (MIBRange)b.get(i);
            if (ra.getLowerValue() > rb.getLowerValue()) {
                return -1;
            }
            if (ra.getLowerValue() < rb.getLowerValue()) {
                return 1;
            }
            if (ra.getUpperValue() > rb.getUpperValue()) {
                return 1;
            }
            if (ra.getLowerValue() >= rb.getLowerValue()) continue;
            return -1;
        }
        return a.size() - b.size();
    }

    public int compareTo(Object o) {
        MIBRange other = (MIBRange)o;
        if (this.getLowerValue() == other.getLowerValue()) {
            return 0;
        }
        if (this.getLowerValue() > other.getLowerValue()) {
            return 1;
        }
        return -1;
    }
}

