/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.ObjectID;
import com.agentpp.smi.IIndexPart;
import com.agentpp.smi.ISyntax;
import com.agentpp.smi.ext.SMIIndexPart;
import com.agentpp.smi.ext.SMIObjectType;
import com.agentpp.smi.ext.SMISyntax;
import com.agentpp.smiparser.SMI;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class MIBObjectType
extends MIBObject
implements Serializable,
SMIObjectType {
    public static final long serialVersionUID = 1000L;
    protected String access = null;
    protected String defValue = null;
    protected MIBSyntax syntax = null;
    protected String units = null;
    protected MIBIndexPart indexPart = null;
    protected Vector entries = null;
    protected boolean columnarObject = false;

    public MIBObjectType() {
        this.columnarObject = false;
    }

    public MIBObjectType(ObjectID oid, String name, Integer moduleID) {
        super(oid, name, moduleID);
        this.columnarObject = false;
    }

    public MIBObjectType(MIBObjectType other) {
        super(other);
        this.access = other.access;
        if (other.hasDefaultValue()) {
            this.defValue = other.defValue;
        }
        MIBSyntax mIBSyntax = this.syntax = other.getSyntax() == null ? null : new MIBSyntax(other.getSyntax());
        if (other.hasUnits()) {
            this.units = other.units;
        }
        if (other.hasIndexPart()) {
            this.indexPart = new MIBIndexPart(other.indexPart);
        }
        if (other.isTable()) {
            this.setTableEntries(other.getTableEntries());
        }
        this.columnarObject = other.columnarObject;
    }

    @Override
    public MIBObject getClone() {
        return new MIBObjectType(this);
    }

    @Override
    public final String getTypeString() {
        return SMI.ENTRY_TYPES[1];
    }

    @Override
    public final int getType() {
        return 1;
    }

    public final String getSubTypeString() {
        if (this.isScalar()) {
            return "Scalar";
        }
        if (this.isTable()) {
            return "TableEntry";
        }
        if (this.isColumnarObject()) {
            return "Column";
        }
        if (this.getSyntax() != null && this.getSyntax().getType() == 2) {
            return "Table";
        }
        return "Scalar";
    }

    @Override
    public final void setAccess(String access) {
        this.access = access;
    }

    @Override
    public final String getAccess() {
        return this.access;
    }

    public final void setSyntax(MIBSyntax syntax) {
        this.syntax = syntax;
    }

    @Override
    public final void setSyntax(SMISyntax syntax) {
        this.syntax = (MIBSyntax)syntax;
    }

    public final MIBSyntax getSyntax() {
        return this.syntax;
    }

    @Override
    public ISyntax getSyntaxDef() {
        return this.syntax;
    }

    @Override
    public final boolean hasDefaultValue() {
        return this.defValue != null;
    }

    @Override
    public final String getDefaultValue() {
        return this.defValue;
    }

    public Object getDefaultValueAsObject(MIBRepository rep) {
        try {
            if (!this.hasDefaultValue()) {
                return null;
            }
            MIBSyntax syn = rep.getEffectiveSyntax(this.syntax).getSyntax();
            if (syn.hasEnums()) {
                String en = syn.getEnum(this.getDefaultValue());
                if (en == null) {
                    return null;
                }
                if (!syn.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    return new Long(SMI.parseLongConstant(en));
                }
                return en;
            }
            if (syn.getSyntax().equals("INTEGER") || syn.getSyntax().equals("Integer32") || syn.getSyntax().equals("Counter") || syn.getSyntax().equals("Counter32") || syn.getSyntax().equals("UInteger32") || syn.getSyntax().equals("Unsigned32") || syn.getSyntax().equals("Gauge") || syn.getSyntax().equals("Gauge32") || syn.getSyntax().equals("Counter64") || syn.getSyntax().equals("TimeTicks")) {
                return new Long(SMI.parseLongConstant(this.defValue));
            }
            if (syn.getSyntax().equals("IpAddress")) {
                byte[] bytes = SMI.stringConstantToByteArray(this.defValue);
                if (bytes == null) {
                    return "0.0.0.0";
                }
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < 4 && i < bytes.length; ++i) {
                    buf.append(bytes[i]);
                    if (i >= 3) continue;
                    buf.append(".");
                }
                return buf.toString();
            }
            if (syn.getSyntax().equals("NetworkAddress") || syn.getSyntax().equals("Opaque") || syn.getSyntax().startsWith("OCTET STRING")) {
                return SMI.parseStringConstant(this.defValue);
            }
            if (syn.getSyntax().equals("OBJECT-IDENTITY") || syn.getSyntax().equals("OBJECT IDENTIFIER")) {
                if (this.defValue.indexOf(123) >= 0) {
                    StringTokenizer st = new StringTokenizer("{ }");
                    StringBuffer buf = new StringBuffer();
                    while (st.hasMoreTokens()) {
                        buf.append(st.nextToken());
                        if (!st.hasMoreTokens()) continue;
                        buf.append('.');
                    }
                    return new ObjectID(buf.toString());
                }
                ObjectID id = rep.getObjectID(this.defValue);
                if (id != null) {
                    return id;
                }
                return new ObjectID();
            }
            return this.defValue;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static Object getDefaultValue(MIBRepository rep, MIBSyntax syntax, String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        try {
            MIBSyntax syn = rep.getEffectiveSyntax(syntax).getSyntax();
            if (syn.hasEnums()) {
                if (syn.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    return syn.getBitsEnum(defaultValue);
                }
                String en = syn.getEnum(defaultValue);
                if (en == null) {
                    return null;
                }
                return new Long(SMI.parseLongConstant(en));
            }
            if (syn.getSyntax().equals("INTEGER") || syn.getSyntax().equals("Integer32") || syn.getSyntax().equals("Counter") || syn.getSyntax().equals("Counter32") || syn.getSyntax().equals("UInteger32") || syn.getSyntax().equals("Unsigned32") || syn.getSyntax().equals("Gauge") || syn.getSyntax().equals("Gauge32") || syn.getSyntax().equals("Counter64") || syn.getSyntax().equals("TimeTicks")) {
                return new Long(SMI.parseLongConstant(defaultValue));
            }
            if (syn.getSyntax().equals("IpAddress") || syn.getSyntax().equals("NetworkAddress") || syn.getSyntax().equals("Opaque") || syn.getSyntax().startsWith("OCTET STRING")) {
                return SMI.stringConstantToByteArray(defaultValue);
            }
            if (syn.getSyntax().equals("OBJECT-IDENTITY") || syn.getSyntax().equals("OBJECT IDENTIFIER")) {
                if (defaultValue.indexOf(123) >= 0) {
                    StringTokenizer st = new StringTokenizer("{ }");
                    StringBuffer buf = new StringBuffer();
                    while (st.hasMoreTokens()) {
                        buf.append(st.nextToken());
                        if (!st.hasMoreTokens()) continue;
                        buf.append('.');
                    }
                    return new ObjectID(buf.toString());
                }
                ObjectID id = rep.getObjectID(defaultValue);
                return id;
            }
            return null;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public Object getDefaultValue(MIBRepository rep) {
        return MIBObjectType.getDefaultValue(rep, this.getSyntax(), this.getDefaultValue());
    }

    @Override
    public final void setDefaultValue(String value) {
        this.defValue = value;
    }

    @Override
    public final boolean hasIndexPart() {
        return this.indexPart != null;
    }

    public final MIBIndexPart getIndexPart() {
        return this.indexPart;
    }

    @Override
    public IIndexPart getIndex() {
        return this.getIndexPart();
    }

    public final void setIndexPart(MIBIndexPart indexPart) {
        this.indexPart = indexPart;
    }

    @Override
    public final void setIndexPart(SMIIndexPart indexPart) {
        this.indexPart = (MIBIndexPart)indexPart;
    }

    @Override
    public final boolean isTable() {
        return this.entries != null && this.entries.size() > 0;
    }

    public final boolean isTableSequence() {
        return this.syntax != null && this.syntax.getType() == 2;
    }

    public void addTableEntry(String entry) {
        if (this.entries == null) {
            new Vector(5);
        }
        this.entries.addElement(entry);
    }

    public final void setTableEntriesVector(Vector entries) {
        this.entries = entries;
    }

    @Override
    public final void setTableEntries(String[] entries) {
        this.entries = MIBRepository.buildVector(entries);
    }

    public final Vector getTableEntriesVector() {
        return this.entries;
    }

    @Override
    public String[] getTableEntries() {
        if (this.entries == null) {
            return null;
        }
        Object[] dest = new String[this.entries.size()];
        this.entries.copyInto(dest);
        return dest;
    }

    public boolean renameTableEntry(String oldName, String newName) {
        String name;
        int index = this.getTableEntriesVector().indexOf(oldName);
        if (index < 0) {
            return false;
        }
        this.getTableEntriesVector().set(index, newName);
        index = this.getIndexPart().getIndexPartVector().indexOf(oldName);
        if (index >= 0) {
            this.getIndexPart().getIndexPartVector().set(index, newName);
        }
        if ((name = this.getName()).length() > 0) {
            this.getSyntax().setSyntax(name.substring(0, 1).toUpperCase() + name.substring(1));
        }
        return true;
    }

    public final String getTableEntry(int i) {
        return (String)this.entries.elementAt(i);
    }

    public final int getTableLength() {
        return this.entries.size();
    }

    @Override
    public final void setColumnarObject(boolean co) {
        this.columnarObject = co;
    }

    @Override
    public final boolean isColumnarObject() {
        return this.columnarObject;
    }

    @Override
    public final void setUnits(String units) {
        this.units = units;
    }

    @Override
    public final String getUnits() {
        return this.units;
    }

    @Override
    public final boolean hasUnits() {
        return this.units != null;
    }

    @Override
    public String toSMI(int mode, int smiversion, MIBRepository rep, String lineSeparator) {
        MIBObjectType c = (MIBObjectType)this.comparable(mode);
        StringBuffer buf = new StringBuffer();
        MIBObjectType.addNavigationLinks(this, mode, buf, rep, lineSeparator);
        if (this.hasComment()) {
            MIBObjectType.addComment(mode, buf, this.asn1Comment, lineSeparator);
            buf.append(lineSeparator);
        }
        MIBObjectType.addObjectRef(null, mode, buf, this.name, c == null ? null : c.name);
        MIBObjectType.addKeyWord(mode, buf, " OBJECT-TYPE");
        buf.append(lineSeparator);
        buf.append("\t");
        MIBObjectType.addKeyWord(mode, buf, "SYNTAX  ");
        if (this.syntax != null) {
            buf.append(this.syntax.toSMI(mode, rep, c == null ? null : c.syntax, lineSeparator));
        }
        if (mode != 16 && this.hasUnits()) {
            buf.append('\t');
            MIBObjectType.addKeyWord(mode, buf, "UNITS");
            boolean multilineUnits = false;
            if (this.units.contains(lineSeparator)) {
                buf.append(lineSeparator);
                multilineUnits = true;
            } else {
                buf.append("\t");
            }
            String cs = null;
            if (c != null) {
                cs = c.hasUnits() ? c.units : "";
            }
            String prefix = multilineUnits ? "\t\t" : "";
            MIBObjectType.addText(lineSeparator, mode, buf, MIBObjectType.formatLines(prefix, this.units), cs == null ? null : MIBObjectType.formatLines(prefix, cs));
            buf.append(lineSeparator);
        }
        this.toSmiAccess(mode, smiversion, lineSeparator, c, buf);
        buf.append(this.getSMIDefBegin(mode, lineSeparator));
        this.toSMIIndexPart(mode, lineSeparator, c, buf);
        if (((mode & 1) > 0 || (mode & 2) > 0) && this.defValue != null) {
            buf.append('\t');
            MIBObjectType.addKeyWord(mode, buf, "DEFVAL ");
            buf.append("{ ");
            String cs = null;
            if (c != null) {
                cs = c.hasDefaultValue() ? c.getDefaultValue() : "";
            }
            MIBObjectType.addString(mode, buf, this.defValue, cs);
            buf.append(" }");
            buf.append(lineSeparator);
        }
        buf.append(this.getSMIDefEnd(mode, rep, this.asn1CommentInline, lineSeparator));
        buf.append(lineSeparator);
        if (rep != null && this.entries != null) {
            buf.append(lineSeparator);
            buf.append(this.syntax.getSyntax());
            buf.append(" ::= ");
            MIBObjectType.addKeyWord(mode, buf, "SEQUENCE");
            buf.append(" {");
            buf.append(lineSeparator);
            int max = MIBObjectType.getMaxLength(this.entries.iterator());
            Enumeration cen = null;
            if (c != null) {
                cen = c.isTable() ? c.entries.elements() : new Vector().elements();
            }
            if (this.entries.size() == 0) {
                buf.append(" }");
            }
            buf.append(lineSeparator);
            Enumeration en = this.entries.elements();
            while (en.hasMoreElements()) {
                String s = (String)en.nextElement();
                String cs = null;
                if (cen != null) {
                    cs = cen.hasMoreElements() ? (String)cen.nextElement() : "";
                }
                buf.append("\t");
                MIBObjectType.addObjectLink(mode, buf, s, cs);
                buf.append(MIBObjectType.space(max - s.length() + 1));
                MIBObjectType o = (MIBObjectType)rep.getObject(s);
                if (o == null) {
                    buf.append("?");
                    if (en.hasMoreElements()) {
                        buf.append(",");
                        buf.append(lineSeparator);
                        continue;
                    }
                    buf.append(" }");
                    buf.append(lineSeparator);
                    continue;
                }
                if (o.getSyntax() != null) {
                    buf.append(o.getSyntax().getSyntax());
                }
                if (en.hasMoreElements()) {
                    buf.append(",");
                    buf.append(lineSeparator);
                    continue;
                }
                buf.append(" }");
                buf.append(lineSeparator);
            }
            buf.append(lineSeparator);
        }
        return buf.toString();
    }

    protected void toSMIIndexPart(int mode, String lineSeparator, MIBObjectType c, StringBuffer buf) {
        if (this.indexPart != null) {
            buf.append('\t');
            String cs = null;
            if (c != null) {
                cs = c.hasIndexPart() ? c.getIndexPart().toSMI(mode, lineSeparator) : "";
            }
            MIBObject.addString(mode, buf, this.indexPart.toSMI(mode, lineSeparator), cs);
        }
    }

    protected void toSmiAccess(int mode, int smiversion, String lineSeparator, MIBObjectType c, StringBuffer buf) {
        if (smiversion == 1) {
            buf.append('\t');
            MIBObjectType.addKeyWord(mode, buf, "ACCESS  ");
            MIBObjectType.addString(mode, buf, this.access, c == null ? null : c.access);
            buf.append(lineSeparator);
        } else if (this.getAccess() != null) {
            buf.append('\t');
            MIBObjectType.addKeyWord(mode, buf, "MAX-ACCESS ");
            MIBObjectType.addString(mode, buf, this.access, c == null ? null : c.access);
            buf.append(lineSeparator);
        }
    }

    @Override
    public boolean isScalar() {
        return !this.isTable() && !this.isColumnarObject() && SMI.isAccessible(this.getAccess());
    }

    @Override
    public boolean isStructural() {
        return !this.isTable() && !this.isColumnarObject() && !this.isScalar();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MIBObjectType && super.equals(o)) {
            MIBObjectType other = (MIBObjectType)o;
            return MIBObjectType.saveCompare(this.syntax, other.syntax) && MIBObjectType.saveCompare(this.access, other.access) && MIBObjectType.saveCompare(this.defValue, other.defValue) && MIBObjectType.saveCompare(this.entries, other.entries) && MIBObjectType.saveCompare(this.indexPart, other.indexPart);
        }
        return false;
    }

    @Override
    public void freeUserObjects() {
        super.freeUserObjects();
        if (this.syntax != null) {
            this.syntax.userObject = null;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.access = SMI.getCommonIdentifier(this.access);
    }
}

