/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.smi.ext.SMINotificationType;
import com.agentpp.smiparser.SMI;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class MIBNotifyType
extends MIBObject
implements Serializable,
SMINotificationType {
    public static final long serialVersionUID = 1000L;
    protected String enterprise;
    protected Vector variables = null;
    public static final int ID = 3;
    protected int trapType = 3;

    public MIBNotifyType() {
        this(3);
    }

    public MIBNotifyType(int type) {
        this.trapType = type == 2 ? 2 : 3;
        this.enterprise = null;
    }

    public MIBNotifyType(ObjectID oid, String name, Integer moduleID, int type) {
        super(oid, name, moduleID);
        this.trapType = type == 2 ? 2 : 3;
    }

    public MIBNotifyType(MIBNotifyType other) {
        super(other);
        this.enterprise = other.enterprise;
        if (other.hasVariables()) {
            Enumeration en = other.variables.elements();
            while (en.hasMoreElements()) {
                this.addVariable((String)en.nextElement());
            }
        }
        this.trapType = other.trapType;
    }

    @Override
    public MIBObject getClone() {
        return new MIBNotifyType(this);
    }

    @Override
    public final String getTypeString() {
        return SMI.ENTRY_TYPES[this.trapType];
    }

    @Override
    public final int getType() {
        return this.trapType;
    }

    @Override
    public final boolean isV1Trap() {
        return this.trapType == 2;
    }

    public final int getTrapType() {
        return this.trapType;
    }

    @Override
    public final void setTrapType(int trapType) {
        this.trapType = trapType;
    }

    @Override
    public boolean hasVariables() {
        return this.variables != null && this.variables.size() > 0;
    }

    @Override
    public void setVariables(String[] objects) {
        this.variables = MIBRepository.buildVector(objects);
    }

    public void addVariable(String variable) {
        if (this.variables == null) {
            this.variables = new Vector(2);
        }
        this.variables.addElement(variable);
    }

    @Override
    public String[] getVariables() {
        if (this.variables == null) {
            return null;
        }
        Object[] s = new String[this.variables.size()];
        this.variables.copyInto(s);
        return s;
    }

    public final void setVariablesVector(Vector v) {
        this.variables = v;
    }

    public final Vector getVariablesVector() {
        return this.variables;
    }

    @Override
    public final String getEnterprise() {
        return this.enterprise;
    }

    @Override
    public final void setEnterprise(String enterprise) {
        this.enterprise = enterprise;
    }

    public String getVariableList() {
        if (!this.hasVariables()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        Enumeration en = this.variables.elements();
        while (en.hasMoreElements()) {
            buf.append(en.nextElement().toString());
            if (!en.hasMoreElements()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    @Override
    public String toSMI(int mode, int smiversion, MIBRepository rep, String lineSeparator) {
        MIBNotifyType c = (MIBNotifyType)this.comparable(mode);
        StringBuffer buf = new StringBuffer(lineSeparator);
        MIBNotifyType.addNavigationLinks(this, mode, buf, rep, lineSeparator);
        if (this.hasComment()) {
            MIBNotifyType.addComment(mode, buf, this.asn1Comment, lineSeparator);
            buf.append(lineSeparator);
        }
        MIBNotifyType.addObjectRef(null, mode, buf, this.name, c == null ? null : c.name);
        if (this.isV1Trap() && mode != 8 || mode == 16) {
            String cs;
            MIBNotifyType.addKeyWord(mode, buf, " TRAP-TYPE");
            buf.append(lineSeparator + "\t");
            MIBNotifyType.addKeyWord(mode, buf, "ENTERPRISE ");
            MIBObject.addString(mode, buf, this.enterprise, c == null ? null : c.enterprise);
            buf.append(lineSeparator);
            if (this.hasVariables()) {
                buf.append('\t');
                MIBNotifyType.addKeyWord(mode, buf, "VARIABLES");
                buf.append(" {" + lineSeparator);
                cs = null;
                if (c != null) {
                    cs = c.hasVariables() ? MIBObject.formatObjectRefs(mode, "\t\t", c.getVariablesVector().iterator(), lineSeparator) : "";
                }
                MIBObject.addString(mode, buf, MIBObject.formatObjectRefs(mode, "\t\t", this.getVariablesVector().iterator(), lineSeparator), cs);
                buf.append("}");
                buf.append(lineSeparator);
            }
            if (this.descr != null) {
                buf.append('\t');
                MIBNotifyType.addKeyWord(mode, buf, "DESCRIPTION ");
                buf.append(lineSeparator);
                cs = null;
                if (c != null) {
                    cs = c.descr != null ? MIBObject.formatLines("\t\t", c.descr) : "";
                }
                MIBNotifyType.addText(lineSeparator, mode, buf, MIBObject.formatLines("\t\t", this.descr), cs);
                buf.append(lineSeparator);
            }
        } else {
            MIBNotifyType.addKeyWord(mode, buf, " NOTIFICATION-TYPE");
            buf.append(lineSeparator);
            if (this.hasVariables()) {
                buf.append('\t');
                MIBNotifyType.addKeyWord(mode, buf, "OBJECTS");
                buf.append(" {");
                buf.append(lineSeparator);
                String cs = null;
                if (c != null) {
                    cs = c.hasVariables() ? MIBObject.formatObjectRefs(mode, "\t\t", c.getVariablesVector().iterator(), lineSeparator) : "";
                }
                MIBObject.addString(mode, buf, MIBObject.formatObjectRefs(mode, "\t\t", this.getVariablesVector().iterator(), lineSeparator), cs);
                buf.append("}");
                buf.append(lineSeparator);
            }
            buf.append(this.getSMIDefBegin(mode, lineSeparator));
        }
        if (this.isV1Trap() && mode != 8 || mode == 16) {
            try {
                buf.append(" ::= ");
                buf.append(this.oid.getLastSubID());
                buf.append(lineSeparator);
            }
            catch (ObjectIDFormatException objectIDFormatException) {}
        } else {
            buf.append(this.getSMIDefEnd(mode, rep, this.asn1CommentInline, lineSeparator));
        }
        return buf.toString();
    }

    @Override
    public boolean isStructural() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MIBNotifyType && super.equals(o)) {
            MIBNotifyType other = (MIBNotifyType)o;
            return MIBNotifyType.saveCompare(this.variables, other.variables) && MIBNotifyType.saveCompare(this.enterprise, other.enterprise) && this.trapType == other.trapType;
        }
        return false;
    }
}

