/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.smi.ext.SMIEnum;
import com.agentpp.smiparser.SMI;
import java.io.Serializable;

public class MIBEnum
implements Serializable,
SMIEnum {
    public static final long serialVersionUID = 1000L;
    protected String label = null;
    protected String value = null;
    protected String comment = null;

    public MIBEnum() {
        this.label = null;
        this.value = null;
    }

    public MIBEnum(String label, String value) {
        this.label = label;
        this.value = value;
    }

    public MIBEnum(String label, String value, String comment) {
        this.label = label;
        this.value = value;
        this.comment = comment;
    }

    public MIBEnum(SMIEnum other) {
        this.label = other.getLabel();
        this.value = other.getValue();
        this.comment = other.getComment();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public String getLabelWithoutHyphen() {
        return this.label.replace('-', '_');
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public long getLongValue() {
        try {
            return SMI.parseLongConstant(this.value);
        }
        catch (Exception ex) {
            return Long.MIN_VALUE;
        }
    }

    public boolean hasValidValue() {
        try {
            SMI.parseLongConstant(this.value);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public String toSMI(int mode) {
        StringBuffer buf = new StringBuffer(this.label);
        if (this.value != null) {
            buf.append('(');
            MIBObject.addNum(mode, buf, this.value);
            buf.append(')');
        }
        return buf.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof MIBEnum) {
            return this.getLongValue() == ((MIBEnum)other).getLongValue();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getLongValue();
    }

    public String toString() {
        return this.label + "(" + this.value + ")";
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }
}

