/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.ObjectID;
import com.agentpp.smi.IImplementationSpec;
import com.agentpp.smi.ext.SMIAgentCapabilities;
import com.agentpp.smi.ext.SMIImplementationSpec;
import com.agentpp.smiparser.SMI;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MIBAgentCaps
extends MIBObject
implements Serializable,
SMIAgentCapabilities {
    public static final long serialVersionUID = 1000L;
    protected String productRelease = null;
    protected Vector<MIBSupportedModule> modules = new Vector();

    public MIBAgentCaps() {
    }

    public MIBAgentCaps(ObjectID oid, String name, Integer moduleID) {
        super(oid, name, moduleID);
    }

    public MIBAgentCaps(MIBAgentCaps other) {
        super(other);
        this.productRelease = other.productRelease;
        Enumeration<MIBSupportedModule> en = other.modules.elements();
        while (en.hasMoreElements()) {
            this.modules.addElement(new MIBSupportedModule(en.nextElement()));
        }
    }

    @Override
    public MIBObject getClone() {
        return new MIBAgentCaps(this);
    }

    @Override
    public final String getTypeString() {
        return SMI.ENTRY_TYPES[9];
    }

    @Override
    public final int getType() {
        return 9;
    }

    @Override
    public final void setProductRelease(String newProductRelease) {
        this.productRelease = newProductRelease;
    }

    @Override
    public final String getProductRelease() {
        return this.productRelease;
    }

    @Override
    public final void setModules(SMIImplementationSpec[] supportedModules) {
        this.modules = Arrays.stream(supportedModules).map(new Function<SMIImplementationSpec, MIBSupportedModule>(){

            @Override
            public MIBSupportedModule apply(SMIImplementationSpec smiImplementationSpec) {
                return new MIBSupportedModule(smiImplementationSpec);
            }
        }).collect(Collectors.toCollection(Vector::new));
    }

    public final void setModules(Vector<MIBSupportedModule> newModules) {
        this.modules = newModules;
    }

    public final Vector<MIBSupportedModule> getModules() {
        return this.modules;
    }

    @Override
    public final IImplementationSpec[] getImplementationSpecs() {
        Object[] m = new MIBSupportedModule[this.modules.size()];
        this.modules.copyInto(m);
        return m;
    }

    @Override
    public String toSMI(int mode, int smiversion, MIBRepository rep, String lineSeparator) {
        MIBAgentCaps c = (MIBAgentCaps)this.comparable(mode);
        if (smiversion > 1) {
            StringBuffer buf = new StringBuffer(lineSeparator);
            MIBAgentCaps.addNavigationLinks(this, mode, buf, rep, lineSeparator);
            if (this.hasComment()) {
                MIBAgentCaps.addComment(mode, buf, this.asn1Comment, lineSeparator);
                buf.append(lineSeparator);
            }
            MIBAgentCaps.addObjectRef(null, mode, buf, this.name, c == null ? null : c.name);
            MIBAgentCaps.addKeyWord(mode, buf, " AGENT-CAPABILITIES");
            buf.append(lineSeparator);
            buf.append(lineSeparator);
            buf.append("\t");
            MIBAgentCaps.addKeyWord(mode, buf, "PRODUCT-RELEASE");
            buf.append(lineSeparator);
            MIBAgentCaps.addText(lineSeparator, mode, buf, MIBAgentCaps.formatLines("\t\t", this.productRelease), c == null ? null : MIBAgentCaps.formatLines("\t\t", c.productRelease));
            buf.append(lineSeparator);
            buf.append(this.getSMIDefBegin(mode, lineSeparator));
            Enumeration<MIBSupportedModule> cen = null;
            if (c != null && c.modules != null) {
                cen = c.modules.elements();
            }
            Enumeration<MIBSupportedModule> en = this.modules.elements();
            while (en.hasMoreElements()) {
                MIBSupportedModule cs = null;
                if (cen != null) {
                    cs = cen.hasMoreElements() ? cen.nextElement() : new MIBSupportedModule();
                }
                buf.append(en.nextElement().toSMI(mode, rep, cs, lineSeparator));
            }
            buf.append(lineSeparator);
            buf.append(this.getSMIDefEnd(mode, rep, this.asn1CommentInline, lineSeparator));
            return buf.toString();
        }
        return "";
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MIBAgentCaps && super.equals(o)) {
            MIBAgentCaps other = (MIBAgentCaps)o;
            return MIBAgentCaps.saveCompare(this.productRelease, other.productRelease) && MIBAgentCaps.saveCompare(this.modules, other.modules);
        }
        return false;
    }

    @Override
    public void freeUserObjects() {
        super.freeUserObjects();
        for (MIBSupportedModule m : this.modules) {
            m.freeUserObjects();
        }
    }
}

