/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.Serializable;
import java.util.Hashtable;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.UsmTimeEntry;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class UsmTimeTable
implements Serializable {
    private static final long serialVersionUID = -1538321547688349797L;
    private static final LogAdapter logger = LogFactory.getLogger(UsmTimeTable.class);
    static final long TIME_PRECISION = 1000000000L;
    public static final int USM_MAX_TIME_DIFFERENCE_HUNDREDS = 150;
    private final Hashtable<Variable, UsmTimeEntry> table = new Hashtable(10);
    private long lastLocalTimeChange = System.nanoTime();
    private UsmTimeEntry localTime;

    public UsmTimeTable(OctetString localEngineID, int engineBoots) {
        this.setLocalTime(new UsmTimeEntry(localEngineID, engineBoots, 0));
    }

    public void addEntry(UsmTimeEntry entry) {
        this.table.put(entry.getEngineID(), entry);
    }

    public UsmTimeEntry getEntry(OctetString engineID) {
        return this.table.get(engineID);
    }

    public UsmTimeEntry getLocalTime() {
        UsmTimeEntry entry = new UsmTimeEntry(this.localTime.getEngineID(), this.localTime.getEngineBoots(), this.getEngineTime());
        entry.setTimeDiff(entry.getTimeDiff() * -1 + this.localTime.getTimeDiff());
        return entry;
    }

    public void setLocalTime(UsmTimeEntry localTime) {
        this.localTime = localTime;
        this.lastLocalTimeChange = System.nanoTime();
    }

    public void setEngineBoots(int engineBoots) {
        this.localTime.setEngineBoots(engineBoots);
    }

    public int getEngineTime() {
        return (int)(((System.nanoTime() - this.lastLocalTimeChange) / 1000000000L + (long)this.localTime.getLatestReceivedTime()) % 0x80000000L);
    }

    public int getEngineBoots() {
        return this.localTime.getEngineBoots();
    }

    public synchronized UsmTimeEntry getTime(OctetString engineID) {
        if (this.localTime.getEngineID().equals(engineID)) {
            return this.getLocalTime();
        }
        UsmTimeEntry found = this.table.get(engineID);
        if (found == null) {
            return null;
        }
        return new UsmTimeEntry(engineID, found.getEngineBoots(), found.getTimeDiff() + (int)(System.nanoTime() / 1000000000L));
    }

    public void removeEntry(OctetString engineID) {
        this.table.remove(engineID);
    }

    public synchronized int checkEngineID(OctetString engineID, boolean discoveryAllowed, int engineBoots, int engineTime) {
        if (this.table.get(engineID) != null) {
            return 0;
        }
        if (discoveryAllowed) {
            this.addEntry(new UsmTimeEntry(engineID, engineBoots, engineTime));
            return 0;
        }
        return 1410;
    }

    public synchronized int checkTime(UsmTimeEntry entry) {
        int now = (int)(System.nanoTime() / 1000000000L);
        if (this.localTime.getEngineID().equals(entry.getEngineID())) {
            if (this.localTime.getEngineBoots() == Integer.MAX_VALUE || this.localTime.getEngineBoots() != entry.getEngineBoots() || Math.abs(now + this.localTime.getTimeDiff() - entry.getLatestReceivedTime()) > 150) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("CheckTime: received message outside time window (authoritative):" + (this.localTime.getEngineBoots() != entry.getEngineBoots() ? "engineBoots differ " + this.localTime.getEngineBoots() + "!=" + entry.getEngineBoots() : Math.abs(now + this.localTime.getTimeDiff() - entry.getLatestReceivedTime()) + " > 150"))));
                }
                return 1411;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)"CheckTime: time ok (authoritative)"));
            }
            return 0;
        }
        UsmTimeEntry time = this.table.get(entry.getEngineID());
        if (time == null) {
            return 1410;
        }
        if (entry.getEngineBoots() > time.getEngineBoots() || entry.getEngineBoots() == time.getEngineBoots() && entry.getLatestReceivedTime() > time.getLatestReceivedTime()) {
            time.setEngineBoots(entry.getEngineBoots());
            time.setLatestReceivedTime(entry.getLatestReceivedTime());
            time.setTimeDiff(entry.getLatestReceivedTime() - now);
        }
        if (entry.getEngineBoots() < time.getEngineBoots() || entry.getEngineBoots() == time.getEngineBoots() && time.getLatestReceivedTime() > entry.getLatestReceivedTime() + 150 || time.getEngineBoots() == Integer.MAX_VALUE) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)"CheckTime: received message outside time window (non authoritative)"));
            }
            return 1411;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)"CheckTime: time ok (non authoritative)"));
        }
        return 0;
    }

    public void reset() {
    }
}

