/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.AuthHMAC128SHA224;
import org.snmp4j.security.AuthHMAC192SHA256;
import org.snmp4j.security.AuthHMAC256SHA384;
import org.snmp4j.security.AuthHMAC384SHA512;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecurityProtocol;
import org.snmp4j.security.nonstandard.NonStandardSecurityProtocol;
import org.snmp4j.security.nonstandard.PrivAES192With3DESKeyExtension;
import org.snmp4j.security.nonstandard.PrivAES256With3DESKeyExtension;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class SecurityProtocols
implements Serializable {
    private static final long serialVersionUID = 3800474900139635836L;
    private final Hashtable<OID, AuthenticationProtocol> authProtocols = new Hashtable(5);
    private final Hashtable<OID, PrivacyProtocol> privProtocols = new Hashtable(5);
    public static final String SECURITY_PROTOCOLS_PROPERTIES = "org.snmp4j.securityProtocols";
    private static final String SECURITY_PROTOCOLS_PROPERTIES_DEFAULT = "SecurityProtocols.properties";
    private static final LogAdapter logger = LogFactory.getLogger(SecurityProtocols.class);
    private static SecurityProtocols instance = null;
    private int maxAuthDigestLength = 0;
    private int maxPrivDecryptParamsLength = 0;

    protected SecurityProtocols() {
    }

    public SecurityProtocols(SecurityProtocolSet initialSecurityProtocolSet) {
        this();
        this.addPredefinedProtocolSet(initialSecurityProtocolSet);
    }

    public void removeAll() {
        this.authProtocols.clear();
        this.privProtocols.clear();
    }

    public void addPredefinedProtocolSet(SecurityProtocolSet initialSecurityProtocolSet) {
        switch (initialSecurityProtocolSet.ordinal()) {
            case 4: {
                this.addPrivacyProtocol(new PrivAES192With3DESKeyExtension());
                this.addPrivacyProtocol(new PrivAES256With3DESKeyExtension());
            }
            case 3: {
                this.addAuthenticationProtocol(new AuthMD5());
                this.addAuthenticationProtocol(new AuthSHA());
            }
            case 2: {
                this.addAuthenticationProtocol(new AuthHMAC128SHA224());
                this.addAuthenticationProtocol(new AuthHMAC192SHA256());
                this.addAuthenticationProtocol(new AuthHMAC256SHA384());
                this.addPrivacyProtocol(new PrivDES());
                this.addPrivacyProtocol(new PrivAES128());
                this.addPrivacyProtocol(new PrivAES192());
            }
            case 1: {
                this.addAuthenticationProtocol(new AuthHMAC384SHA512());
                this.addPrivacyProtocol(new PrivAES256());
            }
        }
    }

    public static SecurityProtocols getInstance() {
        if (instance == null) {
            instance = new SecurityProtocols();
        }
        return instance;
    }

    public static void setSecurityProtocols(SecurityProtocols securityProtocols) {
        instance = securityProtocols;
    }

    public SecurityProtocol getSecurityProtocol(OID protocolID) {
        SecurityProtocol protocol = this.getAuthenticationProtocol(protocolID);
        if (protocol == null) {
            protocol = this.getPrivacyProtocol(protocolID);
        }
        return protocol;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized SecurityProtocols addDefaultProtocols() {
        if (SNMP4JSettings.isExtensibilityEnabled()) {
            String secProtocols = System.getProperty(SECURITY_PROTOCOLS_PROPERTIES, SECURITY_PROTOCOLS_PROPERTIES_DEFAULT);
            InputStream is = SecurityProtocols.class.getResourceAsStream(secProtocols);
            if (is == null) {
                throw new InternalError("Could not read '" + secProtocols + "' from classpath!");
            }
            Properties props = new Properties();
            try {
                props.load(is);
                for (String className : props.stringPropertyNames()) {
                    String customOidString = props.getProperty(className);
                    OID customOID = null;
                    if (customOidString != null && customOidString.trim().length() > 0) {
                        customOID = new OID(customOidString);
                    }
                    try {
                        Class<?> c = Class.forName(className);
                        Object proto = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        if (proto instanceof NonStandardSecurityProtocol && customOID != null && customOID.size() > 0) {
                            if (logger.isInfoEnabled()) {
                                logger.info("Assigning custom ID '" + String.valueOf(customOID) + "' to security protocol " + className);
                            }
                            ((NonStandardSecurityProtocol)proto).setID(customOID);
                        }
                        if (proto instanceof AuthenticationProtocol) {
                            this.addAuthenticationProtocol((AuthenticationProtocol)proto);
                            continue;
                        }
                        if (proto instanceof PrivacyProtocol) {
                            this.addPrivacyProtocol((PrivacyProtocol)proto);
                            continue;
                        }
                        logger.error((Serializable)((Object)("Failed to register security protocol because it does not implement required interfaces: " + className)));
                    }
                    catch (Exception cnfe) {
                        logger.error(cnfe);
                        throw new InternalError(cnfe.toString());
                        return this;
                    }
                }
            }
            catch (IOException iox) {
                String txt = "Could not read '" + secProtocols + "': " + iox.getMessage();
                logger.error((Serializable)((Object)txt));
                throw new InternalError(txt);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    logger.warn(ex);
                }
            }
        }
        this.addAuthenticationProtocol(new AuthHMAC128SHA224());
        this.addAuthenticationProtocol(new AuthHMAC192SHA256());
        this.addAuthenticationProtocol(new AuthHMAC256SHA384());
        this.addAuthenticationProtocol(new AuthHMAC384SHA512());
        this.addPrivacyProtocol(new PrivDES());
        this.addPrivacyProtocol(new PrivAES128());
        this.addPrivacyProtocol(new PrivAES192());
        this.addPrivacyProtocol(new PrivAES256());
        return this;
    }

    public synchronized void addAuthenticationProtocol(AuthenticationProtocol auth) {
        if (this.authProtocols.get(auth.getID()) == null) {
            this.authProtocols.put(auth.getID(), auth);
            if (auth.getDigestLength() > this.maxAuthDigestLength) {
                this.maxAuthDigestLength = auth.getDigestLength();
            }
        }
    }

    public AuthenticationProtocol getAuthenticationProtocol(OID id) {
        if (id == null) {
            return null;
        }
        return this.authProtocols.get(id);
    }

    public void removeAuthenticationProtocol(OID authOID) {
        this.authProtocols.remove(authOID);
    }

    public synchronized void addPrivacyProtocol(PrivacyProtocol priv) {
        if (this.privProtocols.get(priv.getID()) == null) {
            this.privProtocols.put(priv.getID(), priv);
            if (priv.getDecryptParamsLength() > this.maxPrivDecryptParamsLength) {
                this.maxPrivDecryptParamsLength = priv.getDecryptParamsLength();
            }
        }
    }

    public PrivacyProtocol getPrivacyProtocol(OID id) {
        if (id == null) {
            return null;
        }
        return this.privProtocols.get(id);
    }

    public void removePrivacyProtocol(OID privOID) {
        this.privProtocols.remove(privOID);
    }

    public byte[] passwordToKey(OID authProtocolID, OctetString passwordString, byte[] engineID) {
        AuthenticationProtocol protocol = this.authProtocols.get(authProtocolID);
        if (protocol == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Serializable)((Object)("Cannot convert password to key because authentication protocol '" + String.valueOf(authProtocolID) + "' not found in authProtocols=" + String.valueOf(this.authProtocols))));
            }
            return null;
        }
        return protocol.passwordToKey(passwordString, engineID);
    }

    public byte[] passwordToKey(OID privProtocolID, OID authProtocolID, OctetString passwordString, byte[] engineID) {
        AuthenticationProtocol authProtocol = this.authProtocols.get(authProtocolID);
        if (authProtocol == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Serializable)((Object)("Cannot convert password to key because authentication protocol '" + String.valueOf(authProtocolID) + "' not found in authProtocols=" + String.valueOf(this.authProtocols))));
            }
            return null;
        }
        PrivacyProtocol privProtocol = this.privProtocols.get(privProtocolID);
        if (privProtocol == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Serializable)((Object)("Cannot convert password to key because privacy protocol '" + String.valueOf(privProtocolID) + "' not found in privacyProtocols=" + String.valueOf(this.privProtocols))));
            }
            return null;
        }
        byte[] key = authProtocol.passwordToKey(passwordString, engineID);
        if (key == null) {
            return null;
        }
        if (key.length >= privProtocol.getMinKeyLength()) {
            if (key.length > privProtocol.getMaxKeyLength()) {
                byte[] truncatedKey = new byte[privProtocol.getMaxKeyLength()];
                System.arraycopy(key, 0, truncatedKey, 0, privProtocol.getMaxKeyLength());
                return truncatedKey;
            }
            return key;
        }
        return privProtocol.extendShortKey(key, passwordString, engineID, authProtocol);
    }

    public int getMaxAuthDigestLength() {
        return this.maxAuthDigestLength;
    }

    public int getMaxPrivDecryptParamsLength() {
        return this.maxPrivDecryptParamsLength;
    }

    public byte[] truncateKey(byte[] key, int maxKeyLength) {
        byte[] truncatedNewKey = new byte[Math.min(maxKeyLength, key.length)];
        System.arraycopy(key, 0, truncatedNewKey, 0, truncatedNewKey.length);
        return truncatedNewKey;
    }

    public Collection<OID> getSecurityProtocolOIDs(SecurityProtocolType securityProtocolType) {
        switch (securityProtocolType.ordinal()) {
            case 0: {
                return this.authProtocols.keySet();
            }
            case 1: {
                return this.privProtocols.keySet();
            }
        }
        return null;
    }

    public static enum SecurityProtocolSet {
        none,
        maxSecurity,
        defaultSecurity,
        maxCompatibility,
        any;

    }

    public static enum SecurityProtocolType {
        authentication,
        privacy;

    }
}

