/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.fluent;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.cert.X509Certificate;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.Snmp;
import org.snmp4j.cfg.EngineBootsProvider;
import org.snmp4j.cfg.EngineIdProvider;
import org.snmp4j.cfg.SnmpEngineIdProvider;
import org.snmp4j.fluent.TargetBuilder;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocol;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.TSM;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.DtlsAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TlsAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DTLSTM;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.transport.TLSTM;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;
import org.snmp4j.util.MultiThreadedMessageDispatcher;
import org.snmp4j.util.ThreadPool;

public class SnmpBuilder {
    protected final Snmp snmp;
    protected final SecurityProtocols securityProtocols;
    protected final SecurityModels securityModels;
    protected CounterSupport counterSupport;
    protected ThreadPool multiThreadedDispatcherPool;
    protected String responderPoolName = "SnmpDispatcherPool";
    protected EngineIdProvider engineIdProvider;
    protected EngineBootsProvider engineBootsProvider;
    protected byte[] localEngineID;

    public SnmpBuilder() {
        this(new Snmp());
    }

    protected SnmpBuilder(Snmp snmp) {
        this.snmp = snmp;
        this.snmp.getMessageDispatcher().addCommandResponder(snmp);
        this.counterSupport = CounterSupport.getInstance();
        this.securityProtocols = new SecurityProtocols(SecurityProtocols.SecurityProtocolSet.defaultSecurity);
        this.securityModels = new SecurityModels();
    }

    public <A extends Address> TargetBuilder<A> target(A address) {
        return TargetBuilder.forAddress(this, address);
    }

    public SnmpBuilder counterSupport(CounterSupport counterSupport) {
        this.counterSupport = counterSupport;
        return this;
    }

    public SnmpBuilder v1() {
        this.snmp.getMessageDispatcher().addMessageProcessingModel(new MPv1());
        return this;
    }

    public SnmpBuilder v2c() {
        this.snmp.getMessageDispatcher().addMessageProcessingModel(new MPv2c());
        return this;
    }

    public SnmpBuilder v3() {
        if (this.localEngineID != null) {
            if (this.engineIdProvider != null) {
                return this.v3(this.engineIdProvider.getEngineId(new OctetString(this.localEngineID)));
            }
            return this.v3(this.localEngineID);
        }
        if (this.engineIdProvider != null) {
            this.localEngineID = MPv3.createLocalEngineID();
            return this.v3(this.engineIdProvider.getEngineId(new OctetString(this.localEngineID)));
        }
        return this.v3(MPv3.createLocalEngineID());
    }

    public SnmpBuilder v3(OctetString id) {
        return this.v3(MPv3.createLocalEngineID(id));
    }

    public SnmpBuilder v3(EngineIdProvider engineIdProvider, OctetString id) {
        this.engineIdProvider = engineIdProvider;
        this.v3(engineIdProvider.getEngineId(new OctetString(MPv3.createLocalEngineID(id))).getValue());
        return this;
    }

    public SnmpBuilder v3(byte[] localEngineID) {
        this.localEngineID = localEngineID;
        MPv3 mpv3 = new MPv3(localEngineID);
        mpv3.setSecurityModels(this.securityModels);
        mpv3.setSecurityProtocols(this.securityProtocols);
        this.snmp.getMessageDispatcher().addMessageProcessingModel(mpv3);
        return this;
    }

    public SnmpBuilder threads(int numThreads) {
        MessageDispatcher messageDispatcher = this.snmp.getMessageDispatcher();
        if (messageDispatcher instanceof MultiThreadedMessageDispatcher) {
            messageDispatcher = ((MultiThreadedMessageDispatcher)messageDispatcher).getDispatcher();
        }
        if (this.multiThreadedDispatcherPool != null) {
            this.multiThreadedDispatcherPool.cancel();
        }
        this.multiThreadedDispatcherPool = ThreadPool.create(this.responderPoolName, numThreads);
        this.snmp.setMessageDispatcher(new MultiThreadedMessageDispatcher(this.multiThreadedDispatcherPool, messageDispatcher));
        return this;
    }

    public SnmpBuilder usm() {
        if (this.engineIdProvider != null && this.engineBootsProvider != null) {
            return this.usm(this.engineIdProvider.getEngineId(new OctetString(this.localEngineID)), this.engineBootsProvider.updateEngineBoots());
        }
        return this.usm(new OctetString(((MPv3)this.snmp.getMessageDispatcher().getMessageProcessingModel(3)).getLocalEngineID()), 0);
    }

    public SnmpBuilder usm(OctetString localEngineID, int engineBoots) {
        this.localEngineID = localEngineID.getValue();
        this.securityModels.addSecurityModel(new USM(this.securityProtocols, localEngineID, engineBoots));
        return this;
    }

    public SnmpBuilder usm(SnmpEngineIdProvider snmpEngineIdProvider, OctetString defaultLocalEngineID) {
        this.engineIdProvider = snmpEngineIdProvider;
        this.engineBootsProvider = snmpEngineIdProvider;
        this.securityModels.addSecurityModel(new USM(this.securityProtocols, this.engineIdProvider.getEngineId(defaultLocalEngineID), this.engineBootsProvider.updateEngineBoots()));
        return this;
    }

    public SnmpBuilder tsm(OctetString localEngineID, boolean usePrefix) {
        this.securityModels.addSecurityModel(new TSM(localEngineID, usePrefix));
        return this;
    }

    public SnmpBuilder tsm(EngineIdProvider engineIdProvider, OctetString defaultLocalEngineID, boolean usePrefix) {
        this.securityModels.addSecurityModel(new TSM(engineIdProvider.getEngineId(defaultLocalEngineID), usePrefix));
        return this;
    }

    public SnmpBuilder udp() throws IOException {
        DefaultUdpTransportMapping tm = new DefaultUdpTransportMapping(new UdpAddress(new InetSocketAddress(0).getAddress(), 0));
        this.snmp.getMessageDispatcher().addTransportMapping(tm);
        tm.addTransportListener(this.snmp.getMessageDispatcher());
        return this;
    }

    public SnmpBuilder udp(UdpAddress ... listenAddresses) throws IOException {
        for (UdpAddress listenAddress : listenAddresses) {
            DefaultUdpTransportMapping udpTransportMapping = new DefaultUdpTransportMapping(listenAddress);
            this.snmp.getMessageDispatcher().addTransportMapping(udpTransportMapping);
            udpTransportMapping.addTransportListener(this.snmp.getMessageDispatcher());
        }
        return this;
    }

    public SnmpBuilder tcp() throws IOException {
        DefaultTcpTransportMapping tm = new DefaultTcpTransportMapping(new TcpAddress(new InetSocketAddress(0).getAddress(), 0), false);
        this.snmp.getMessageDispatcher().addTransportMapping(tm);
        tm.addTransportListener(this.snmp.getMessageDispatcher());
        return this;
    }

    public SnmpBuilder tcp(TcpAddress ... listenAddresses) throws IOException {
        for (TcpAddress listenAddress : listenAddresses) {
            DefaultTcpTransportMapping tcpTransportMapping = new DefaultTcpTransportMapping(listenAddress, true);
            this.snmp.getMessageDispatcher().addTransportMapping(tcpTransportMapping);
            tcpTransportMapping.addTransportListener(this.snmp.getMessageDispatcher());
        }
        return this;
    }

    public SnmpBuilder dtls() throws IOException {
        DTLSTM dtlstm = new DTLSTM(new DtlsAddress(new InetSocketAddress(0).getAddress(), 0), false);
        this.snmp.getMessageDispatcher().addTransportMapping(dtlstm);
        dtlstm.addTransportListener(this.snmp.getMessageDispatcher());
        return this;
    }

    public SnmpBuilder dtls(TlsTmSecurityCallback<X509Certificate> securityCallback, DtlsAddress ... listenAddresses) throws IOException {
        return this.dtls(securityCallback, (String[])null, listenAddresses);
    }

    public SnmpBuilder dtls(TlsTmSecurityCallback<X509Certificate> securityCallback, String[] dtlsProtocolVersions, DtlsAddress ... listenAddresses) throws IOException {
        for (DtlsAddress listenAddress : listenAddresses) {
            DTLSTM dtlsTransportMapping = new DTLSTM(securityCallback, listenAddress, this.counterSupport, true);
            if (dtlsProtocolVersions != null && dtlsProtocolVersions.length > 0) {
                dtlsTransportMapping.setProtocolVersions(dtlsProtocolVersions);
            }
            this.snmp.getMessageDispatcher().addTransportMapping(dtlsTransportMapping);
            dtlsTransportMapping.addTransportListener(this.snmp.getMessageDispatcher());
        }
        return this;
    }

    public SnmpBuilder tls() throws IOException {
        TLSTM tlstm = new TLSTM(new TlsAddress(new InetSocketAddress(0).getAddress(), 0), false);
        this.snmp.getMessageDispatcher().addTransportMapping(tlstm);
        tlstm.addTransportListener(this.snmp.getMessageDispatcher());
        return this;
    }

    public SnmpBuilder tls(TlsTmSecurityCallback<X509Certificate> securityCallback, TlsAddress ... listenAddresses) throws IOException {
        return this.tls(securityCallback, (String[])null, listenAddresses);
    }

    public SnmpBuilder tls(TlsTmSecurityCallback<X509Certificate> securityCallback, String[] tlsProtocolVersions, TlsAddress ... listenAddresses) throws IOException {
        for (TlsAddress listenAddress : listenAddresses) {
            TLSTM tlsTransportMapping = new TLSTM(securityCallback, listenAddress, this.counterSupport, true);
            if (tlsProtocolVersions != null && tlsProtocolVersions.length > 0) {
                tlsTransportMapping.setProtocolVersions(tlsProtocolVersions);
            }
            this.snmp.getMessageDispatcher().addTransportMapping(tlsTransportMapping);
            tlsTransportMapping.addTransportListener(this.snmp.getMessageDispatcher());
        }
        return this;
    }

    public SnmpBuilder securityProtocols(SecurityProtocols.SecurityProtocolSet securityProtocolSet) {
        this.securityProtocols.removeAll();
        this.securityProtocols.addPredefinedProtocolSet(securityProtocolSet);
        return this;
    }

    public SnmpBuilder addSecurityProtocol(SecurityProtocol securityProtocol) {
        if (securityProtocol instanceof AuthenticationProtocol) {
            this.securityProtocols.addAuthenticationProtocol((AuthenticationProtocol)securityProtocol);
        }
        if (securityProtocol instanceof PrivacyProtocol) {
            this.securityProtocols.addPrivacyProtocol((PrivacyProtocol)securityProtocol);
        }
        return this;
    }

    public Snmp build() throws IOException {
        this.snmp.listen();
        return this.snmp;
    }
}

