/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.io.Serializable;
import org.snmp4j.CertifiedIdentity;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.security.SecurityLevel;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;

public class TransportStateReference
implements Serializable {
    private static final long serialVersionUID = 3903263675608991496L;
    private TransportMapping<?> transport;
    private Address address;
    private OctetString securityName;
    private SecurityLevel requestedSecurityLevel;
    private SecurityLevel transportSecurityLevel;
    private boolean sameSecurity;
    private Object sessionID;
    private Target<?> target;

    public TransportStateReference(TransportMapping<?> transport, Address address, OctetString securityName, SecurityLevel requestedSecurityLevel, SecurityLevel transportSecurityLevel, boolean sameSecurity, Object sessionID) {
        this.transport = transport;
        this.address = address;
        this.securityName = securityName;
        this.requestedSecurityLevel = requestedSecurityLevel;
        this.transportSecurityLevel = transportSecurityLevel;
        this.sameSecurity = sameSecurity;
        this.sessionID = sessionID;
    }

    public TransportStateReference(TransportMapping<?> transport, Address address, OctetString securityName, SecurityLevel requestedSecurityLevel, SecurityLevel transportSecurityLevel, boolean sameSecurity, Object sessionID, Target<?> target) {
        this(transport, address, securityName, requestedSecurityLevel, transportSecurityLevel, sameSecurity, sessionID);
        this.target = target;
    }

    public void setTransport(TransportMapping<?> transport) {
        this.transport = transport;
    }

    public TransportMapping<?> getTransport() {
        return this.transport;
    }

    public Address getAddress() {
        return this.address;
    }

    public OctetString getSecurityName() {
        return this.securityName;
    }

    public SecurityLevel getRequestedSecurityLevel() {
        return this.requestedSecurityLevel;
    }

    public SecurityLevel getTransportSecurityLevel() {
        return this.transportSecurityLevel;
    }

    public boolean isSameSecurity() {
        return this.sameSecurity;
    }

    public Object getSessionID() {
        return this.sessionID;
    }

    public void setSecurityName(OctetString securityName) {
        this.securityName = securityName;
    }

    public void setRequestedSecurityLevel(SecurityLevel requestedSecurityLevel) {
        this.requestedSecurityLevel = requestedSecurityLevel;
    }

    public void setTransportSecurityLevel(SecurityLevel transportSecurityLevel) {
        this.transportSecurityLevel = transportSecurityLevel;
    }

    public void setSameSecurity(boolean sameSecurity) {
        this.sameSecurity = sameSecurity;
    }

    @Deprecated
    public CertifiedIdentity getCertifiedIdentity() {
        if (this.target instanceof CertifiedIdentity) {
            return (CertifiedIdentity)((Object)this.target);
        }
        return null;
    }

    public static boolean hasCertifiedIdentity(TransportStateReference transportStateReference) {
        return transportStateReference != null && transportStateReference.getTarget() instanceof CertifiedIdentity;
    }

    public Target<?> getTarget() {
        return this.target;
    }

    public boolean isTransportSecurityValid() {
        return this.transport != null && this.address != null && this.transportSecurityLevel != null;
    }

    public String toString() {
        return "TransportStateReference[transport=" + String.valueOf(this.transport) + ", address=" + String.valueOf(this.address) + ", securityName=" + String.valueOf(this.securityName) + ", requestedSecurityLevel=" + String.valueOf((Object)this.requestedSecurityLevel) + ", transportSecurityLevel=" + String.valueOf((Object)this.transportSecurityLevel) + ", sameSecurity=" + this.sameSecurity + ", sessionID=" + String.valueOf(this.sessionID) + ", target=" + String.valueOf(this.target) + "]";
    }
}

