/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageException;
import org.snmp4j.MutablePDU;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.TransportStateReference;
import org.snmp4j.UserTarget;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BEROutputStream;
import org.snmp4j.event.AuthenticationFailureEvent;
import org.snmp4j.event.AuthenticationFailureListener;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.MutableStateReference;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.PduHandleCallback;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.security.SecurityLevel;
import org.snmp4j.security.TsmSecurityStateReference;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.TransportType;
import org.snmp4j.transport.UnsupportedAddressClassException;

public class MessageDispatcherImpl
implements MessageDispatcher {
    private static final LogAdapter logger = LogFactory.getLogger(MessageDispatcherImpl.class);
    private List<MessageProcessingModel> mpm = new ArrayList<MessageProcessingModel>(3);
    private final Map<Class<?>, List<TransportMapping<? extends Address>>> receiverTransportMappings = Collections.synchronizedMap(new HashMap(5));
    private final Map<Class<?>, List<TransportMapping<? extends Address>>> senderTransportMappings = Collections.synchronizedMap(new HashMap(5));
    private int nextTransactionID = new Random().nextInt(0x7FFFFFFD) + 1;
    private transient List<CommandResponder> commandResponderListeners = new CopyOnWriteArrayList<CommandResponder>();
    private transient List<CounterListener> counterListeners = new CopyOnWriteArrayList<CounterListener>();
    private transient List<AuthenticationFailureListener> authenticationFailureListeners = new CopyOnWriteArrayList<AuthenticationFailureListener>();
    private boolean checkOutgoingMsg = true;

    @Override
    public synchronized void addMessageProcessingModel(MessageProcessingModel model) {
        while (this.mpm.size() <= model.getID()) {
            this.mpm.add(null);
        }
        if (this.mpm.get(model.getID()) == null) {
            this.mpm.set(model.getID(), model);
        }
    }

    @Override
    public synchronized void removeMessageProcessingModel(MessageProcessingModel model) {
        this.mpm.set(model.getID(), null);
    }

    public void addTransportMapping(TransportMapping<?> transport) {
        Set<Class<Address>> supportedAddressClasses = transport.getSupportedAddressClasses();
        for (Class<Address> supportedAddressClass : supportedAddressClasses) {
            if (transport.getSupportedTransportType() == TransportType.any) {
                this.addTransportMapping(transport, supportedAddressClass, TransportType.receiver);
                this.addTransportMapping(transport, supportedAddressClass, TransportType.sender);
                continue;
            }
            this.addTransportMapping(transport, supportedAddressClass, transport.getSupportedTransportType());
        }
    }

    private Map<Class<?>, List<TransportMapping<? extends Address>>> getTransportMappings(TransportType transportType) {
        switch (transportType) {
            case receiver: {
                return this.receiverTransportMappings;
            }
            case sender: {
                return this.senderTransportMappings;
            }
        }
        logger.error((Serializable)((Object)"MessageDispatcher.getTransportMappings called with TransportType.any"));
        return this.receiverTransportMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTransportMapping(TransportMapping<?> transport, Class<? extends Address> supportedAddressClass, TransportType transportType) {
        List transports;
        List list = transports = this.getTransportMappings(transportType).computeIfAbsent(supportedAddressClass, k -> new LinkedList());
        synchronized (list) {
            transports.add(transport);
        }
    }

    public TransportMapping<? extends Address> removeTransportMapping(TransportMapping<?> transport) {
        boolean removed = false;
        Set<Class<Address>> supportedAddressClasses = transport.getSupportedAddressClasses();
        for (Class<Address> supportedAddressClass : supportedAddressClasses) {
            if (transport.getSupportedTransportType() == TransportType.any) {
                removed |= this.removeTransportMapping(transport, supportedAddressClass, TransportType.receiver);
                removed |= this.removeTransportMapping(transport, supportedAddressClass, TransportType.sender);
                continue;
            }
            removed |= this.removeTransportMapping(transport, supportedAddressClass, transport.getSupportedTransportType());
        }
        if (removed) {
            return transport;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeTransportMapping(TransportMapping<?> transport, Class<? extends Address> supportedAddressClass, TransportType transportType) {
        boolean removed;
        List transports;
        Map<Class<?>, List<TransportMapping<Address>>> transportMappings = this.getTransportMappings(transportType);
        List list = transports = transportMappings.computeIfAbsent(supportedAddressClass, k -> new LinkedList());
        synchronized (list) {
            removed = transports.remove(transport);
        }
        if (transports.isEmpty()) {
            transportMappings.remove(supportedAddressClass);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<TransportMapping<? extends Address>> getTransportMappings() {
        List<TransportMapping<? extends Address>> list;
        List<TransportMapping<? extends Address>> tm;
        Iterator<List<TransportMapping<? extends Address>>> iterator;
        HashSet<TransportMapping<? extends Address>> l = new HashSet<TransportMapping<? extends Address>>();
        Map<Class<?>, List<TransportMapping<? extends Address>>> map = this.receiverTransportMappings;
        synchronized (map) {
            iterator = this.receiverTransportMappings.values().iterator();
            while (iterator.hasNext()) {
                list = tm = iterator.next();
                synchronized (list) {
                    l.addAll(tm);
                }
            }
        }
        map = this.senderTransportMappings;
        synchronized (map) {
            iterator = this.senderTransportMappings.values().iterator();
            while (iterator.hasNext()) {
                list = tm = iterator.next();
                synchronized (list) {
                    l.addAll(tm);
                }
            }
        }
        return l;
    }

    @Override
    public synchronized int getNextRequestID() {
        int nextID;
        if ((nextID = this.nextTransactionID++) <= 0) {
            nextID = 1;
            this.nextTransactionID = 2;
        }
        return nextID;
    }

    protected PduHandle createPduHandle() {
        return new PduHandle(this.getNextRequestID());
    }

    protected <A extends Address> void sendMessage(TransportMapping<? super A> transport, A destAddress, byte[] message, TransportStateReference tmStateReference, long timeoutMillis, int maxRetries) throws IOException {
        if (transport != null) {
            if (destAddress instanceof GenericAddress) {
                transport.sendMessage(((GenericAddress)destAddress).getAddress(), message, tmStateReference, timeoutMillis, maxRetries);
            } else {
                transport.sendMessage(destAddress, message, tmStateReference, timeoutMillis, maxRetries);
            }
        } else {
            String txt = "No transport mapping for address class: " + destAddress.getClass().getName() + "=" + String.valueOf(destAddress);
            logger.error((Serializable)((Object)txt));
            throw new IOException(txt);
        }
    }

    @Override
    @Deprecated
    public <A extends Address> TransportMapping<? super A> getTransport(A destAddress) {
        TransportMapping<A> transportMapping = this.getTransport(destAddress, TransportType.receiver);
        if (transportMapping == null) {
            transportMapping = this.getTransport(destAddress, TransportType.sender);
        }
        return transportMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Address> TransportMapping<? super A> getTransport(A destAddress, TransportType transportType) {
        if (transportType == TransportType.any) {
            throw new IllegalArgumentException("TransportType.any not allowed for transport lookup");
        }
        Class<?> addressClass = destAddress.getClass();
        do {
            List<TransportMapping<? extends Address>> l;
            if ((l = this.getTransportMappings(transportType).get(addressClass)) == null) continue;
            List<TransportMapping<? extends Address>> list = l;
            synchronized (list) {
                if (!l.isEmpty()) {
                    for (TransportMapping<? extends Address> transportMapping : l) {
                        if (!transportMapping.isAddressSupported(destAddress, true)) continue;
                        return transportMapping;
                    }
                    for (TransportMapping<? extends Address> transportMapping : l) {
                        if (!transportMapping.isAddressSupported(destAddress) || !destAddress.isTransportCompatible(transportMapping.getSupportedAddressClass())) continue;
                        return transportMapping;
                    }
                }
            }
        } while ((addressClass = addressClass.getSuperclass()) != null);
        return null;
    }

    protected <A extends Address> void dispatchMessage(TransportMapping<? super A> sourceTransport, MessageProcessingModel mp, A incomingAddress, BERInputStream wholeMessage, TransportStateReference tmStateReference) throws IOException {
        MutablePDU pdu = new MutablePDU();
        Integer32 messageProcessingModel = new Integer32();
        Integer32 securityModel = new Integer32();
        OctetString securityName = new OctetString();
        Integer32 securityLevel = new Integer32();
        PduHandle handle = this.createPduHandle();
        Integer32 maxSizeRespPDU = new Integer32(sourceTransport.getMaxOutboundMessageSize() - MPv3.MAX_HEADER_LENGTH);
        StatusInformation statusInfo = new StatusInformation();
        MutableStateReference mutableStateReference = new MutableStateReference();
        StateReference<A> stateReference = new StateReference<A>();
        stateReference.setTransportMapping(sourceTransport);
        stateReference.setAddress(incomingAddress);
        mutableStateReference.setStateReference(stateReference);
        int status = mp.prepareDataElements(this, incomingAddress, wholeMessage, tmStateReference, messageProcessingModel, securityModel, securityName, securityLevel, pdu, handle, maxSizeRespPDU, statusInfo, mutableStateReference);
        if (mutableStateReference.getStateReference() != null) {
            mutableStateReference.getStateReference().setTransportMapping(sourceTransport);
        }
        if (status == 0) {
            CommandResponderEvent<A> e = new CommandResponderEvent<A>(this, sourceTransport, incomingAddress, messageProcessingModel.getValue(), securityModel.getValue(), securityName.getValue(), securityLevel.getValue(), handle, pdu.getPdu(), maxSizeRespPDU.getValue(), mutableStateReference.getStateReference());
            e.setTmStateReference(tmStateReference);
            CounterEvent responseTimeEvent = null;
            if (SNMP4JSettings.getSnmp4jStatistics() != SNMP4JSettings.Snmp4jStatistics.none) {
                responseTimeEvent = new CounterEvent(this, SnmpConstants.snmp4jStatsResponseProcessTime, incomingAddress, System.nanoTime());
            }
            this.fireProcessPdu(e);
            if (responseTimeEvent != null) {
                long increment = (System.nanoTime() - responseTimeEvent.getIncrement()) / 1000000L;
                responseTimeEvent.setIncrement(increment);
                this.fireIncrementCounter(responseTimeEvent);
            }
        } else {
            switch (status) {
                case -1414: 
                case -1412: 
                case -1402: 
                case 1403: 
                case 1404: 
                case 1407: 
                case 1408: 
                case 1410: 
                case 1411: 
                case 1412: 
                case 1603: {
                    AuthenticationFailureEvent<? super A> event = new AuthenticationFailureEvent<A>(this, incomingAddress, sourceTransport, status, wholeMessage);
                    this.fireAuthenticationFailure(event);
                    break;
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info("Dispatching message canceled due to security issue: statusInfo=" + String.valueOf(statusInfo) + ", status=" + status + ",tmStateReference=" + String.valueOf(tmStateReference));
            }
        }
    }

    @Override
    public <A extends Address> void processMessage(TransportMapping<? super A> sourceTransport, A incomingAddress, ByteBuffer wholeMessage, TransportStateReference tmStateReference) {
        this.processMessage(sourceTransport, incomingAddress, new BERInputStream(wholeMessage), tmStateReference);
    }

    public <A extends Address> void processMessage(TransportMapping<? super A> sourceTransport, A incomingAddress, BERInputStream wholeMessage, TransportStateReference tmStateReference) {
        block12: {
            this.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpInPkts));
            if (!wholeMessage.markSupported()) {
                String txt = "Message stream must support marks";
                logger.error((Serializable)((Object)txt));
                throw new IllegalArgumentException(txt);
            }
            try {
                Integer32 version = MessageDispatcherImpl.getSnmpVersion(wholeMessage);
                if (version == null) {
                    logger.error((Serializable)((Object)"ASN.1 parse error (message is not a sequence)"));
                    CounterEvent event = new CounterEvent(this, SnmpConstants.snmpInASNParseErrs);
                    this.fireIncrementCounter(event);
                } else {
                    MessageProcessingModel mp = this.getMessageProcessingModel(version.getValue());
                    if (mp == null) {
                        logger.warn((Serializable)((Object)("SNMP version " + String.valueOf(version) + " is not supported")));
                        CounterEvent event = new CounterEvent(this, SnmpConstants.snmpInBadVersions);
                        this.fireIncrementCounter(event);
                    } else {
                        this.dispatchMessage(sourceTransport, mp, incomingAddress, wholeMessage, tmStateReference);
                    }
                }
            }
            catch (IOException iox) {
                if (logger.isDebugEnabled()) {
                    iox.printStackTrace();
                }
                logger.warn(iox);
                CounterEvent event = new CounterEvent(this, SnmpConstants.snmpInvalidMsgs);
                this.fireIncrementCounter(event);
            }
            catch (Exception ex) {
                logger.error(ex);
                if (logger.isDebugEnabled()) {
                    ex.printStackTrace();
                }
                if (SNMP4JSettings.isForwardRuntimeExceptions()) {
                    throw new RuntimeException(ex);
                }
            }
            catch (OutOfMemoryError oex) {
                logger.error(oex);
                if (!SNMP4JSettings.isForwardRuntimeExceptions()) break block12;
                throw oex;
            }
        }
    }

    public static Integer32 getSnmpVersion(BERInputStream wholeMessage) throws IOException {
        wholeMessage.mark(16);
        BER.MutableByte type = new BER.MutableByte();
        BER.decodeHeader(wholeMessage, type, false);
        if (type.getValue() != 48) {
            return null;
        }
        Integer32 version = new Integer32();
        version.decodeBER(wholeMessage);
        wholeMessage.reset();
        return version;
    }

    @Override
    public <A extends Address> PduHandle sendPdu(Target<A> target, PDU pdu, boolean expectResponse) throws MessageException {
        return this.sendPdu(null, target, pdu, expectResponse);
    }

    @Override
    public <A extends Address> PduHandle sendPdu(TransportMapping<? super A> transport, Target<A> target, PDU pdu, boolean expectResponse, PduHandleCallback<PDU> pduHandleCallback) throws MessageException {
        int messageProcessingModel = target.getVersion();
        A transportAddress = target.getAddress();
        int securityModel = target.getSecurityModel();
        int securityLevel = target.getSecurityLevel();
        try {
            byte[] securityName = OctetString.toByteArray(target.getSecurityName());
            MessageProcessingModel mp = this.getMessageProcessingModel(messageProcessingModel);
            if (mp == null) {
                String msg = "Unsupported message processing model: " + messageProcessingModel;
                logger.error((Serializable)((Object)msg));
                throw new MessageException(msg, 1702);
            }
            if (!mp.isProtocolVersionSupported(messageProcessingModel)) {
                String msg = "SNMP version " + messageProcessingModel + " is not supported by message processing model " + messageProcessingModel;
                logger.error((Serializable)((Object)msg));
                throw new MessageException(msg, 1704);
            }
            if (transport == null) {
                transport = this.getTransport(transportAddress, pdu.isResponsePdu() ? TransportType.receiver : TransportType.sender);
            }
            if (transport == null) {
                String msg = "Unsupported address class (transport mapping is null): " + transportAddress.getClass().getName();
                logger.error((Serializable)((Object)msg));
                throw new UnsupportedAddressClassException(msg, transportAddress.getClass());
            }
            if (pdu.isConfirmedPdu()) {
                MessageDispatcherImpl.checkListening4ConfirmedPDU(pdu, target.getAddress(), transport);
            }
            this.checkOutgoingMsg((Address)transportAddress, messageProcessingModel, pdu);
            Integer32 reqID = pdu.getRequestID();
            PduHandle pduHandle = (reqID == null || reqID.getValue() == 0) && pdu.getType() != -94 ? this.createPduHandle() : new PduHandle(pdu.getRequestID().getValue());
            if (pdu.getType() != -92) {
                pdu.setRequestID(new Integer32(pduHandle.getTransactionID()));
            }
            TransportStateReference tmStateReference = new TransportStateReference(transport, (Address)transportAddress, OctetString.fromByteArray(securityName), SecurityLevel.get(securityLevel), SecurityLevel.undefined, false, null, target);
            if (pdu.isConfirmedPdu()) {
                this.configureAuthoritativeEngineID(target, mp);
            }
            BEROutputStream outgoingMessage = new BEROutputStream();
            int status = mp.prepareOutgoingMessage(transportAddress, transport.getMaxOutboundMessageSize(), messageProcessingModel, securityModel, securityName, securityLevel, pdu, expectResponse, pduHandle, outgoingMessage, tmStateReference);
            if (status == 0) {
                if (pduHandleCallback != null) {
                    pduHandleCallback.pduHandleAssigned(pduHandle, pdu);
                }
            } else {
                String msg = "Message processing model " + mp.getID() + " returned error: " + SnmpConstants.mpErrorMessage(status);
                logger.error((Serializable)((Object)msg));
                throw new MessageException(msg, status);
            }
            byte[] messageBytes = outgoingMessage.getBuffer().array();
            this.sendMessage(transport, transportAddress, messageBytes, tmStateReference, target.getTimeout(), target.getRetries());
            return pduHandle;
        }
        catch (IndexOutOfBoundsException iobex) {
            String msg = "Unsupported message processing model: " + messageProcessingModel;
            logger.error(msg, iobex);
            throw new MessageException(msg, 1702, iobex);
        }
        catch (MessageException mex) {
            if (logger.isDebugEnabled()) {
                mex.printStackTrace();
            }
            throw mex;
        }
        catch (IOException iox) {
            logger.error(iox.getMessage(), iox);
            if (logger.isDebugEnabled()) {
                iox.printStackTrace();
            }
            throw new MessageException(iox.getMessage(), 1701, iox);
        }
    }

    protected void configureAuthoritativeEngineID(Target<?> target, MessageProcessingModel mp) {
        UserTarget userTarget;
        if (target instanceof UserTarget && mp instanceof MPv3 && (userTarget = (UserTarget)target).getAuthoritativeEngineID() != null && userTarget.getAuthoritativeEngineID().length > 0) {
            ((MPv3)mp).addEngineID((Address)target.getAddress(), new OctetString(userTarget.getAuthoritativeEngineID()));
        }
    }

    private static void checkListening4ConfirmedPDU(PDU pdu, Address target, TransportMapping<?> transport) {
        if (transport != null && !transport.isListening()) {
            logger.warn((Serializable)((Object)("Sending confirmed PDU " + String.valueOf(pdu) + " to target " + String.valueOf(target) + " although transport mapping " + String.valueOf(transport) + " is not listening for a response")));
        }
    }

    protected void checkOutgoingMsg(Address transportAddress, int messageProcessingModel, PDU pdu) throws MessageException {
        if (this.checkOutgoingMsg && (messageProcessingModel == 0 || SNMP4JSettings.isNoGetBulk()) && pdu.getType() == -91) {
            if (messageProcessingModel == 0) {
                logger.warn((Serializable)((Object)("Converting GETBULK PDU to GETNEXT for SNMPv1 target: " + String.valueOf(transportAddress))));
            } else {
                logger.info("Converting GETBULK PDU to GETNEXT for target: " + String.valueOf(transportAddress));
            }
            pdu.setType(-95);
            if (!(pdu instanceof PDUv1)) {
                pdu.setMaxRepetitions(0);
                pdu.setNonRepeaters(0);
            }
        }
    }

    @Override
    public <A extends Address> int returnResponsePdu(int messageProcessingModel, int securityModel, byte[] securityName, int securityLevel, PDU pdu, int maxSizeResponseScopedPDU, StateReference<A> stateReference, StatusInformation statusInformation) throws MessageException {
        try {
            TransportMapping<A> transport;
            MessageProcessingModel mp = this.getMessageProcessingModel(messageProcessingModel);
            if (mp == null) {
                throw new MessageException("Unsupported message processing model: " + messageProcessingModel, 1702);
            }
            TransportMapping<A> transportMapping = transport = stateReference != null ? stateReference.getTransportMapping() : null;
            if (transport == null && stateReference != null) {
                transport = this.getTransport(stateReference.getAddress(), TransportType.receiver);
            }
            if (transport == null) {
                throw new MessageException("Unsupported address class (transport mapping is null): " + (stateReference != null ? stateReference.getAddress().getClass().getName() : "stateReference is null"), 1703);
            }
            BEROutputStream outgoingMessage = new BEROutputStream();
            int status = mp.prepareResponseMessage(messageProcessingModel, transport.getMaxInboundMessageSize(), securityModel, securityName, securityLevel, pdu, maxSizeResponseScopedPDU, stateReference, statusInformation, outgoingMessage);
            if (status == 0) {
                TransportStateReference tmStateReference = null;
                if (stateReference.getSecurityStateReference() instanceof TsmSecurityStateReference) {
                    tmStateReference = ((TsmSecurityStateReference)stateReference.getSecurityStateReference()).getTmStateReference();
                }
                this.sendMessage((TransportMapping<? super A>)transport, stateReference.getAddress(), outgoingMessage.getBuffer().array(), tmStateReference, 0L, 0);
            }
            return status;
        }
        catch (ArrayIndexOutOfBoundsException aex) {
            throw new MessageException("Unsupported message processing model: " + messageProcessingModel, 1702, aex);
        }
        catch (IOException iox) {
            throw new MessageException(iox.getMessage(), 1701, iox);
        }
    }

    @Override
    public void releaseStateReference(int messageProcessingModel, PduHandle pduHandle) {
        MessageProcessingModel mp = this.getMessageProcessingModel(messageProcessingModel);
        if (mp == null) {
            throw new IllegalArgumentException("Unsupported message processing model: " + messageProcessingModel);
        }
        mp.releaseStateReference(pduHandle);
    }

    @Override
    public void removeCommandResponder(CommandResponder l) {
        this.commandResponderListeners.remove(l);
    }

    @Override
    public void addCommandResponder(CommandResponder l) {
        if (!this.commandResponderListeners.contains(l)) {
            this.commandResponderListeners.add(l);
        }
    }

    protected void fireProcessPdu(CommandResponderEvent<?> e) {
        List<CommandResponder> listeners = this.commandResponderListeners;
        for (CommandResponder listener : listeners) {
            listener.processPdu(e);
            if (!e.isProcessed()) continue;
            return;
        }
    }

    @Override
    public MessageProcessingModel getMessageProcessingModel(int messageProcessingModel) {
        try {
            return this.mpm.get(messageProcessingModel);
        }
        catch (IndexOutOfBoundsException iobex) {
            return null;
        }
    }

    @Override
    public synchronized CounterListener removeCounterListener(CounterListener counterListener) {
        return this.counterListeners.remove(counterListener) ? counterListener : null;
    }

    @Override
    public void addCounterListener(CounterListener counterListener) {
        if (!this.counterListeners.contains(counterListener)) {
            this.counterListeners.add(counterListener);
        }
    }

    protected void fireIncrementCounter(CounterEvent event) {
        for (CounterListener cl : this.counterListeners) {
            cl.incrementCounter(event);
        }
    }

    public void setCheckOutgoingMsg(boolean checkOutgoingMsg) {
        this.checkOutgoingMsg = checkOutgoingMsg;
    }

    public boolean isCheckOutgoingMsg() {
        return this.checkOutgoingMsg;
    }

    public synchronized void addAuthenticationFailureListener(AuthenticationFailureListener l) {
        if (!this.authenticationFailureListeners.contains(l)) {
            this.authenticationFailureListeners.add(l);
        }
    }

    public synchronized void removeAuthenticationFailureListener(AuthenticationFailureListener l) {
        this.authenticationFailureListeners.remove(l);
    }

    protected void fireAuthenticationFailure(AuthenticationFailureEvent<?> event) {
        List<AuthenticationFailureListener> listeners = this.authenticationFailureListeners;
        for (AuthenticationFailureListener listener : listeners) {
            listener.authenticationFailure(event);
        }
    }

    @Override
    public <A extends Address> PduHandle sendPdu(TransportMapping<? super A> transportMapping, Target<A> target, PDU pdu, boolean expectResponse) throws MessageException {
        return this.sendPdu(transportMapping, target, pdu, expectResponse, null);
    }

    private class TransportMappingKey {
        private TransportType transportType;
        private Class<?> rootAddressClass;

        public TransportMappingKey(TransportType transportType, Class<?> rootAddressClass) {
            this.transportType = transportType;
            this.rootAddressClass = rootAddressClass;
        }

        public TransportType getTransportType() {
            return this.transportType;
        }

        public Class<?> getRootAddressClass() {
            return this.rootAddressClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransportMappingKey that = (TransportMappingKey)o;
            if (this.getTransportType() != that.getTransportType()) {
                return false;
            }
            return this.getRootAddressClass().equals(that.getRootAddressClass());
        }

        public int hashCode() {
            int result = this.getTransportType().hashCode();
            result = 31 * result + this.getRootAddressClass().hashCode();
            return result;
        }

        public String toString() {
            return "TransportMappingKey{transportType=" + String.valueOf((Object)this.transportType) + ", rootAddressClass=" + String.valueOf(this.rootAddressClass) + "}";
        }
    }
}

